/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.template.soy.types.SoyType;
import java.util.Map;
import java.util.Objects;

public final class RecordType
implements SoyType {
    private final ImmutableSortedMap<String, SoyType> members;

    private RecordType(Map<String, ? extends SoyType> members) {
        this.members = ImmutableSortedMap.copyOf(members);
    }

    public static RecordType of(Map<String, ? extends SoyType> members) {
        return new RecordType(members);
    }

    @Override
    public SoyType.Kind getKind() {
        return SoyType.Kind.RECORD;
    }

    @Override
    public boolean isAssignableFrom(SoyType srcType) {
        if (srcType.getKind() == SoyType.Kind.RECORD) {
            RecordType srcRecord = (RecordType)srcType;
            for (Map.Entry entry : this.members.entrySet()) {
                SoyType fieldType = (SoyType)srcRecord.members.get(entry.getKey());
                if (fieldType != null && ((SoyType)entry.getValue()).isAssignableFrom(fieldType)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ImmutableSortedMap<String, SoyType> getMembers() {
        return this.members;
    }

    public SoyType getFieldType(String fieldName) {
        return (SoyType)this.members.get((Object)fieldName);
    }

    public ImmutableSet<String> getFieldNames() {
        return this.members.keySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (Map.Entry entry : this.members.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append((String)entry.getKey());
            sb.append(": ");
            sb.append(entry.getValue());
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object other) {
        return other != null && other.getClass() == this.getClass() && ((RecordType)other).members.equals(this.members);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.members);
    }
}

