/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.internal.proto.ProtoUtils;
import com.google.template.soy.types.AnyType;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.ErrorType;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.LegacyObjectMapType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.UnionType;
import com.google.template.soy.types.UnknownType;
import com.google.template.soy.types.ast.GenericTypeNode;
import com.google.template.soy.types.ast.NamedTypeNode;
import com.google.template.soy.types.ast.RecordTypeNode;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.TypeNodeVisitor;
import com.google.template.soy.types.ast.UnionTypeNode;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class SoyTypeRegistry {
    private static final ExtensionRegistry REGISTRY = SoyTypeRegistry.createRegistry();
    private static final SoyErrorKind UNKNOWN_TYPE = SoyErrorKind.of("Unknown type ''{0}''.{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind DUPLICATE_RECORD_FIELD = SoyErrorKind.of("Duplicate field ''{0}'' in record declaration.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_TYPE_PARAM = SoyErrorKind.of("Unexpected type parameter: ''{0}'' only has {1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind EXPECTED_TYPE_PARAM = SoyErrorKind.of("Expected a type parameter: ''{0}'' has {1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind NOT_A_GENERIC_TYPE = SoyErrorKind.of("''{0}'' is not a generic type, expected ''list'' or ''map''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MISSING_GENERIC_TYPE_PARAMETERS = SoyErrorKind.of("''{0}'' is a generic type, expected {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final ImmutableSet<SoyType.Kind> ALLOWED_MAP_KEY_TYPES = ImmutableSet.of((Object)((Object)SoyType.Kind.BOOL), (Object)((Object)SoyType.Kind.INT), (Object)((Object)SoyType.Kind.STRING), (Object)((Object)SoyType.Kind.PROTO_ENUM));
    private static final SoyErrorKind BAD_MAP_KEY_TYPE;
    private static final ImmutableMap<String, SoyType> BUILTIN_TYPES;
    private static final ImmutableMap<String, SanitizedType> SAFE_PROTO_TO_SANITIZED_TYPE;
    public static final SoyTypeRegistry DEFAULT_UNKNOWN;
    private final Object lock = new Object();
    private final Interner<ListType> listTypes = Interners.newStrongInterner();
    private final Interner<MapType> mapTypes = Interners.newStrongInterner();
    private final Interner<LegacyObjectMapType> legacyObjectMapTypes = Interners.newStrongInterner();
    private final Interner<UnionType> unionTypes = Interners.newStrongInterner();
    private final Interner<RecordType> recordTypes = Interners.newStrongInterner();
    @GuardedBy(value="lock")
    private ImmutableList<String> lazyAllSortedTypeNames;
    @GuardedBy(value="lock")
    private final Map<String, SoyType> protoTypeCache;
    private final ImmutableMap<String, Descriptors.GenericDescriptor> descriptors;
    private final ImmutableSetMultimap<String, Descriptors.FieldDescriptor> extensions;
    private static final ImmutableMap<String, GenericTypeInfo> GENERIC_TYPES;

    private static final ExtensionRegistry createRegistry() {
        ExtensionRegistry instance = ExtensionRegistry.newInstance();
        return instance;
    }

    private SoyTypeRegistry(Builder builder) {
        DescriptorVisitor visitor = new DescriptorVisitor();
        try {
            builder.accept(visitor);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new RuntimeException("Malformed descriptor set", e);
        }
        this.descriptors = ImmutableMap.copyOf(visitor.descriptors);
        this.extensions = ImmutableSetMultimap.copyOf(visitor.extensions);
        this.protoTypeCache = new HashMap<String, SanitizedType>((Map<String, SanitizedType>)SAFE_PROTO_TO_SANITIZED_TYPE);
    }

    public SoyTypeRegistry() {
        this(new Builder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SoyType getType(String typeName) {
        SoyType result = (SoyType)BUILTIN_TYPES.get((Object)typeName);
        if (result != null) {
            return result;
        }
        Object object = this.lock;
        synchronized (object) {
            result = this.protoTypeCache.get(typeName);
            if (result == null) {
                Descriptors.GenericDescriptor descriptor = (Descriptors.GenericDescriptor)this.descriptors.get((Object)typeName);
                if (descriptor == null) {
                    return null;
                }
                result = descriptor instanceof Descriptors.EnumDescriptor ? new SoyProtoEnumType((Descriptors.EnumDescriptor)descriptor) : new SoyProtoType(this, (Descriptors.Descriptor)descriptor, (Set<Descriptors.FieldDescriptor>)this.extensions.get((Object)typeName));
                this.protoTypeCache.put(typeName, result);
            }
        }
        return result;
    }

    public String findTypeWithMatchingNamespace(String prefix) {
        prefix = prefix + ".";
        for (String name : this.getAllSortedTypeNames()) {
            if (!name.startsWith(prefix)) continue;
            return name;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<String> getAllSortedTypeNames() {
        Object object = this.lock;
        synchronized (object) {
            if (this.lazyAllSortedTypeNames == null) {
                this.lazyAllSortedTypeNames = Ordering.natural().immutableSortedCopy(Iterables.concat((Iterable)BUILTIN_TYPES.keySet(), (Iterable)this.descriptors.keySet()));
            }
            return this.lazyAllSortedTypeNames;
        }
    }

    public ListType getOrCreateListType(SoyType elementType) {
        return (ListType)this.listTypes.intern((Object)ListType.of(elementType));
    }

    public LegacyObjectMapType getOrCreateLegacyObjectMapType(SoyType keyType, SoyType valueType) {
        return (LegacyObjectMapType)this.legacyObjectMapTypes.intern((Object)LegacyObjectMapType.of(keyType, valueType));
    }

    public MapType getOrCreateMapType(SoyType keyType, SoyType valueType) {
        return (MapType)this.mapTypes.intern((Object)MapType.of(keyType, valueType));
    }

    public SoyType getOrCreateUnionType(Collection<SoyType> members) {
        SoyType type = UnionType.of(members);
        if (type.getKind() == SoyType.Kind.UNION) {
            type = (SoyType)this.unionTypes.intern((Object)((UnionType)type));
        }
        return type;
    }

    public SoyType getOrCreateUnionType(SoyType ... members) {
        return this.getOrCreateUnionType(Arrays.asList(members));
    }

    public RecordType getOrCreateRecordType(Map<String, SoyType> fields) {
        return (RecordType)this.recordTypes.intern((Object)RecordType.of(fields));
    }

    public SoyType getOrCreateType(@Nullable TypeNode node, ErrorReporter errorReporter) {
        if (node == null) {
            return UnknownType.getInstance();
        }
        return node.accept(new TypeNodeConverter(errorReporter));
    }

    static {
        StringBuilder sb = new StringBuilder("''{0}'' is not allowed as a map key type. Allowed map key types: ");
        ImmutableList allowed = ALLOWED_MAP_KEY_TYPES.asList();
        for (int i = 0; i < allowed.size() - 1; ++i) {
            sb.append(((SoyType.Kind)((Object)allowed.get(i))).toString().toLowerCase()).append(", ");
        }
        sb.append(((SoyType.Kind)((Object)allowed.get(allowed.size() - 1))).toString().toLowerCase()).append(".");
        BAD_MAP_KEY_TYPE = SoyErrorKind.of(sb.toString(), new SoyErrorKind.StyleAllowance[0]);
        BUILTIN_TYPES = ImmutableMap.builder().put((Object)"?", (Object)UnknownType.getInstance()).put((Object)"any", (Object)AnyType.getInstance()).put((Object)"null", (Object)NullType.getInstance()).put((Object)"bool", (Object)BoolType.getInstance()).put((Object)"int", (Object)IntType.getInstance()).put((Object)"float", (Object)FloatType.getInstance()).put((Object)"string", (Object)StringType.getInstance()).put((Object)"number", (Object)SoyTypes.NUMBER_TYPE).put((Object)"html", (Object)SanitizedType.HtmlType.getInstance()).put((Object)"attributes", (Object)SanitizedType.AttributesType.getInstance()).put((Object)"css", (Object)SanitizedType.CssType.getInstance()).put((Object)"uri", (Object)SanitizedType.UriType.getInstance()).put((Object)"trusted_resource_url", (Object)SanitizedType.TrustedResourceUriType.getInstance()).put((Object)"js", (Object)SanitizedType.JsType.getInstance()).build();
        SAFE_PROTO_TO_SANITIZED_TYPE = ImmutableMap.builder().put((Object)SafeHtmlProto.getDescriptor().getFullName(), (Object)SanitizedType.HtmlType.getInstance()).put((Object)SafeScriptProto.getDescriptor().getFullName(), (Object)SanitizedType.JsType.getInstance()).put((Object)SafeStyleProto.getDescriptor().getFullName(), (Object)SanitizedType.CssType.getInstance()).put((Object)SafeStyleSheetProto.getDescriptor().getFullName(), (Object)SanitizedType.CssType.getInstance()).put((Object)SafeUrlProto.getDescriptor().getFullName(), (Object)SanitizedType.UriType.getInstance()).put((Object)TrustedResourceUrlProto.getDescriptor().getFullName(), (Object)SanitizedType.TrustedResourceUriType.getInstance()).build();
        DEFAULT_UNKNOWN = new SoyTypeRegistry(){

            @Override
            @Nullable
            public SoyType getType(String typeName) {
                SoyType type = super.getType(typeName);
                if (type == null) {
                    return UnknownType.getInstance();
                }
                return type;
            }
        };
        GENERIC_TYPES = ImmutableMap.of((Object)"list", (Object)new GenericTypeInfo(1){

            @Override
            SoyType create(List<SoyType> types, SoyTypeRegistry registry) {
                return registry.getOrCreateListType(types.get(0));
            }
        }, (Object)"legacy_object_map", (Object)new GenericTypeInfo(2){

            @Override
            SoyType create(List<SoyType> types, SoyTypeRegistry registry) {
                return registry.getOrCreateLegacyObjectMapType(types.get(0), types.get(1));
            }
        }, (Object)"map", (Object)new GenericTypeInfo(2){

            @Override
            SoyType create(List<SoyType> types, SoyTypeRegistry registry) {
                return registry.getOrCreateMapType(types.get(0), types.get(1));
            }

            @Override
            void checkPermissibleGenericTypes(List<SoyType> types, List<TypeNode> typeNodes, ErrorReporter errorReporter) {
                SoyType keyType = types.get(0);
                if (!ALLOWED_MAP_KEY_TYPES.contains((Object)keyType.getKind())) {
                    errorReporter.report(typeNodes.get(0).sourceLocation(), BAD_MAP_KEY_TYPE, keyType);
                }
            }
        });
    }

    private static final class DescriptorVisitor {
        final Set<String> visited = new HashSet<String>();
        final Map<String, Descriptors.GenericDescriptor> descriptors = new LinkedHashMap<String, Descriptors.GenericDescriptor>();
        final SetMultimap<String, Descriptors.FieldDescriptor> extensions = MultimapBuilder.linkedHashKeys().treeSetValues((Comparator)new Comparator<Descriptors.FieldDescriptor>(){

            @Override
            public int compare(Descriptors.FieldDescriptor left, Descriptors.FieldDescriptor right) {
                return ComparisonChain.start().compare(left.getNumber(), right.getNumber()).compare((Comparable)((Object)left.getContainingType().getFullName()), (Comparable)((Object)right.getContainingType().getFullName())).result();
            }
        }).build();

        private DescriptorVisitor() {
        }

        void visit(Iterable<? extends Descriptors.GenericDescriptor> descriptors) {
            for (Descriptors.GenericDescriptor genericDescriptor : descriptors) {
                this.visit(genericDescriptor);
            }
        }

        void visit(Descriptors.GenericDescriptor descriptor) {
            if (!this.visited.add(descriptor.getFullName())) {
                return;
            }
            if (descriptor instanceof Descriptors.FileDescriptor) {
                Descriptors.FileDescriptor fileDescriptor = (Descriptors.FileDescriptor)descriptor;
                this.visit(fileDescriptor.getMessageTypes());
                this.visit(fileDescriptor.getExtensions());
                this.visit(fileDescriptor.getEnumTypes());
                this.visit(fileDescriptor.getDependencies());
            } else if (descriptor instanceof Descriptors.Descriptor) {
                Descriptors.Descriptor messageDescriptor = (Descriptors.Descriptor)descriptor;
                this.descriptors.put(messageDescriptor.getFullName(), (Descriptors.GenericDescriptor)messageDescriptor);
                this.visit(messageDescriptor.getEnumTypes());
                this.visit(messageDescriptor.getExtensions());
                this.visit(messageDescriptor.getNestedTypes());
                this.visit(messageDescriptor.getFields());
            } else if (descriptor instanceof Descriptors.FieldDescriptor) {
                Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)descriptor;
                if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                    this.visit((Descriptors.GenericDescriptor)fieldDescriptor.getMessageType());
                }
                if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
                    this.visit((Descriptors.GenericDescriptor)fieldDescriptor.getEnumType());
                }
                if (fieldDescriptor.isExtension() && !ProtoUtils.shouldJsIgnoreField(fieldDescriptor)) {
                    this.extensions.put((Object)fieldDescriptor.getContainingType().getFullName(), (Object)fieldDescriptor);
                }
            } else if (descriptor instanceof Descriptors.EnumDescriptor) {
                Descriptors.EnumDescriptor enumDescriptor = (Descriptors.EnumDescriptor)descriptor;
                this.descriptors.put(descriptor.getFullName(), (Descriptors.GenericDescriptor)enumDescriptor);
            }
        }
    }

    public static final class Builder {
        private final Map<String, DescriptorProtos.FileDescriptorProto> nameToProtos = new LinkedHashMap<String, DescriptorProtos.FileDescriptorProto>();
        private final List<Descriptors.GenericDescriptor> descriptors = new ArrayList<Descriptors.GenericDescriptor>();

        public Builder addFileDescriptorSetFromFile(File descriptorFile) throws IOException {
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(descriptorFile));){
                for (DescriptorProtos.FileDescriptorProto file : DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)inputStream, (ExtensionRegistryLite)REGISTRY).getFileList()) {
                    this.nameToProtos.put(file.getName(), file);
                }
            }
            return this;
        }

        public Builder addDescriptors(Iterable<? extends Descriptors.GenericDescriptor> descriptorsToAdd) {
            for (Descriptors.GenericDescriptor genericDescriptor : descriptorsToAdd) {
                this.descriptors.add(genericDescriptor);
            }
            return this;
        }

        private void accept(DescriptorVisitor visitor) throws Descriptors.DescriptorValidationException {
            HashMap<String, Descriptors.FileDescriptor> parsedDescriptors = new HashMap<String, Descriptors.FileDescriptor>();
            for (String name : this.nameToProtos.keySet()) {
                visitor.visit((Descriptors.GenericDescriptor)Builder.buildDescriptor(null, name, parsedDescriptors, this.nameToProtos));
            }
            visitor.visit(this.descriptors);
        }

        private static Descriptors.FileDescriptor buildDescriptor(String requestor, String name, Map<String, Descriptors.FileDescriptor> descriptors, Map<String, DescriptorProtos.FileDescriptorProto> protos) throws Descriptors.DescriptorValidationException {
            Descriptors.FileDescriptor file = descriptors.get(name);
            if (file != null) {
                return file;
            }
            DescriptorProtos.FileDescriptorProto proto = protos.get(name);
            if (proto == null) {
                throw new IllegalStateException("Cannot find proto descriptor for " + name + " which is a dependency of " + requestor);
            }
            Descriptors.FileDescriptor[] deps = new Descriptors.FileDescriptor[proto.getDependencyCount()];
            for (int i = 0; i < proto.getDependencyCount(); ++i) {
                deps[i] = Builder.buildDescriptor(name, proto.getDependency(i), descriptors, protos);
            }
            file = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)proto, (Descriptors.FileDescriptor[])deps);
            descriptors.put(name, file);
            return file;
        }

        public SoyTypeRegistry build() {
            return new SoyTypeRegistry(this);
        }
    }

    private final class TypeNodeConverter
    implements TypeNodeVisitor<SoyType>,
    Function<TypeNode, SoyType> {
        final ErrorReporter errorReporter;

        TypeNodeConverter(ErrorReporter errorReporter) {
            this.errorReporter = errorReporter;
        }

        @Override
        public SoyType visit(NamedTypeNode node) {
            String name = node.name();
            SoyType type = SoyTypeRegistry.this.getType(name);
            if (type == null) {
                GenericTypeInfo genericType = (GenericTypeInfo)GENERIC_TYPES.get((Object)name);
                if (genericType != null) {
                    this.errorReporter.report(node.sourceLocation(), MISSING_GENERIC_TYPE_PARAMETERS, name, genericType.formatNumTypeParams());
                } else {
                    this.errorReporter.report(node.sourceLocation(), UNKNOWN_TYPE, name, SoyErrors.getDidYouMeanMessage(SoyTypeRegistry.this.getAllSortedTypeNames(), name));
                }
                type = ErrorType.getInstance();
            }
            return type;
        }

        @Override
        public SoyType visit(GenericTypeNode node) {
            ImmutableList<TypeNode> args = node.arguments();
            String name = node.name();
            GenericTypeInfo genericType = (GenericTypeInfo)GENERIC_TYPES.get((Object)name);
            if (genericType == null) {
                this.errorReporter.report(node.sourceLocation(), NOT_A_GENERIC_TYPE, name);
                return ErrorType.getInstance();
            }
            if (args.size() < genericType.numParams) {
                this.errorReporter.report(node.sourceLocation().getEndLocation(), EXPECTED_TYPE_PARAM, name, genericType.formatNumTypeParams());
                return ErrorType.getInstance();
            }
            if (args.size() > genericType.numParams) {
                this.errorReporter.report(((TypeNode)args.get(genericType.numParams)).sourceLocation(), UNEXPECTED_TYPE_PARAM, name, genericType.formatNumTypeParams());
                return ErrorType.getInstance();
            }
            List genericTypes = Lists.transform(args, (Function)this);
            ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
            genericType.checkPermissibleGenericTypes(genericTypes, (List<TypeNode>)args, this.errorReporter);
            return this.errorReporter.errorsSince(checkpoint) ? ErrorType.getInstance() : genericType.create(genericTypes, SoyTypeRegistry.this);
        }

        @Override
        public SoyType visit(UnionTypeNode node) {
            return SoyTypeRegistry.this.getOrCreateUnionType(Collections2.transform(node.candidates(), (Function)this));
        }

        @Override
        public SoyType visit(RecordTypeNode node) {
            LinkedHashMap map = Maps.newLinkedHashMap();
            for (RecordTypeNode.Property property : node.properties()) {
                SoyType oldType = map.put(property.name(), property.type().accept(this));
                if (oldType == null) continue;
                this.errorReporter.report(property.nameLocation(), DUPLICATE_RECORD_FIELD, property.name());
                map.put(property.name(), oldType);
            }
            return SoyTypeRegistry.this.getOrCreateRecordType(map);
        }

        public SoyType apply(TypeNode node) {
            return node.accept(this);
        }
    }

    private static abstract class GenericTypeInfo {
        final int numParams;

        GenericTypeInfo(int numParams) {
            this.numParams = numParams;
        }

        final String formatNumTypeParams() {
            return this.numParams + " type parameter" + (this.numParams > 1 ? "s" : "");
        }

        abstract SoyType create(List<SoyType> var1, SoyTypeRegistry var2);

        void checkPermissibleGenericTypes(List<SoyType> types, List<TypeNode> typeNodes, ErrorReporter errorReporter) {
        }
    }
}

