/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.errorprone.annotations.ForOverride;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.template.soy.CacheLoaders;
import com.google.template.soy.CommandLineError;
import com.google.template.soy.FileSystemSoyFileReader;
import com.google.template.soy.PluginLoader;
import com.google.template.soy.SoyCmdLineParser;
import com.google.template.soy.SoyCompilerFileReader;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.SoyInputCache;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.error.SoyCompilationException;
import com.google.template.soy.logging.AnnotatedLoggingConfig;
import com.google.template.soy.logging.ValidatedLoggingConfig;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;

public abstract class AbstractSoyCompiler {
    private final String usagePrefix = "Usage:\njava " + this.getClass().getName() + " \\\n     [<flag1> <flag2> ...] --jar <jarName>  \\\n     --srcs <soyFilePath>,... [--deps <soyFilePath>,...]\n";
    @Option(name="--srcs", usage="The list of source Soy files (if applicable). Extra arguments are treated as srcs. Sources are typically required and read from this flag or as extra arguments.", handler=SoyCmdLineParser.FileListOptionHandler.class)
    List<File> srcs = new ArrayList<File>();
    @Option(name="--generated_files", usage="A map of generated files that map back to their short name", handler=SoyCmdLineParser.StringStringMapHandler.class)
    private Map<String, String> generatedFiles = new HashMap<String, String>();
    @Option(name="--depHeaders", usage="The list of dependency Soy header files (if applicable). The compiler needs deps for analysis/checking..", handler=SoyCmdLineParser.FileListOptionHandler.class)
    private List<File> depHeaders = new ArrayList<File>();
    @Option(name="--indirectDepHeaders", usage="Soy file headers required by deps, but which may not be used by srcs.  Used by the compiler for typechecking and call analysis.", handler=SoyCmdLineParser.FileListOptionHandler.class)
    private List<File> indirectDepHeaders = new ArrayList<File>();
    @Option(name="--compileTimeGlobalsFile", aliases={"--compileTimeGlobalsFiles"}, usage="The path to a file containing the mappings for global names to be substituted at compile time. Each line of the file should have the format \"<global_name> = <primitive_data>\" where primitive_data is a valid Soy expression literal for a primitive type (null, boolean, integer, float, or string). Empty lines and lines beginning with \"//\" are ignored. The file should be encoded in UTF-8. If you need to generate a file in this format from Java, consider using the utility SoyUtils.generateCompileTimeGlobalsFile().", handler=SoyCmdLineParser.FileListOptionHandler.class)
    private List<File> globalsFiles = new ArrayList<File>();
    @Option(name="--pluginModules", usage="Specifies the full class names of Guice modules for function plugins and print directive plugins (comma-delimited list).", handler=SoyCmdLineParser.ModuleListOptionHandler.class)
    private List<Module> pluginModules = new ArrayList<Module>();
    @Option(name="--pluginFunctions", usage="Specifies the full class names of SoySourceFunction plugins (comma-delimited list).", handler=SoyCmdLineParser.SourceFunctionListOptionHandler.class)
    private List<SoySourceFunction> sourceFunctions = new ArrayList<SoySourceFunction>();
    @Option(name="--protoFileDescriptors", usage="Location of protocol buffer definitions in the form of a file descriptor set.The compiler needs defs for parameter type checking and generating direct access support for proto types.", handler=SoyCmdLineParser.FileListOptionHandler.class)
    private List<File> protoFileDescriptors = new ArrayList<File>();
    @Option(name="--loggingConfig", aliases={"--loggingConfigs"}, usage="Location of logging config protos in binary proto format. Optional.", handler=SoyCmdLineParser.FileListOptionHandler.class)
    private List<File> loggingConfigs = new ArrayList<File>();
    @Option(name="--cssMetadata", aliases={"--cssMetadata"}, usage="List of css metadata files used to check strict deps against css dependencies and css() calls.", handler=SoyCmdLineParser.FileListOptionHandler.class)
    private List<File> cssMetadata = new ArrayList<File>();
    @Option(name="--check_css_list", usage="Filename for list of files to exempt from checking css() calls for classes in CSS files.")
    private File checkCssList = null;
    @Option(name="--skip_css_reference_check", usage="Whether to skip the go/css-conformance#check-css-references check.")
    private boolean skipCssReferenceCheck = false;
    @Option(name="--enableExperimentalFeatures", usage="Enable experimental features that are not generally available. These experimental features may change, break, or disappear at any time. We make absolutely no guarantees about what may happen if you turn one of these experiments on. Please proceed with caution at your own risk.", handler=SoyCmdLineParser.StringListOptionHandler.class)
    private List<String> experimentalFeatures = new ArrayList<String>();
    @Option(name="--disableOptimizerForTestingUseOnly", usage="Disable optimizer in Soy compiler. Optimzer tries to simplify the Soy AST and improves the performance in general. This flag should only be set in integration test environment.")
    private boolean disableOptimizer = false;
    @Argument
    private List<String> arguments = new ArrayList<String>();
    protected final SoyCompilerFileReader soyCompilerFileReader;
    final PluginLoader pluginLoader;
    private final SoyInputCache cache;

    protected AbstractSoyCompiler(PluginLoader pluginLoader, SoyInputCache cache, SoyCompilerFileReader soyCompilerFileReader) {
        this.cache = cache;
        this.pluginLoader = pluginLoader;
        this.soyCompilerFileReader = soyCompilerFileReader;
    }

    protected AbstractSoyCompiler(PluginLoader pluginLoader, SoyCompilerFileReader soyCompilerFileReader) {
        this(pluginLoader, SoyInputCache.DEFAULT, soyCompilerFileReader);
    }

    protected AbstractSoyCompiler(PluginLoader pluginLoader, SoyInputCache cache) {
        this(pluginLoader, cache, FileSystemSoyFileReader.INSTANCE);
    }

    protected AbstractSoyCompiler() {
        this((PluginLoader)new PluginLoader.Default(), SoyInputCache.DEFAULT);
    }

    final void runMain(String ... args) {
        int status = this.run(args, System.err);
        System.exit(status);
    }

    @CheckReturnValue
    public int run(String[] args, PrintStream err) {
        try {
            this.doMain(args, err);
            return 0;
        }
        catch (SoyCompilationException compilationException) {
            err.println(this.formatCompilationException(compilationException));
            return 1;
        }
        catch (CommandLineError e) {
            e.printStackTrace(err);
            return 1;
        }
        catch (Throwable e) {
            err.println("INTERNAL SOY ERROR.\nPlease open an issue at https://github.com/google/closure-templates/issues with this stack trace and repro steps");
            e.printStackTrace(err);
            return 1;
        }
    }

    private void doMain(String[] args, PrintStream err) throws IOException {
        Stopwatch timer = Stopwatch.createStarted();
        Stopwatch guiceTimer = Stopwatch.createUnstarted();
        SoyCmdLineParser cmdLineParser = new SoyCmdLineParser(this.pluginLoader);
        cmdLineParser.registerFlagsObject(this);
        for (Object flagsObject : this.extraFlagsObjects()) {
            cmdLineParser.registerFlagsObject(flagsObject);
        }
        try {
            cmdLineParser.parseArgument(args);
        }
        catch (CmdLineException cle) {
            StringWriter sw = new StringWriter();
            cmdLineParser.setUsageWidth(100);
            cmdLineParser.printUsage(sw, null);
            AbstractSoyCompiler.exitWithError(String.format("%s\n\n%s\n%s", cle.getMessage(), this.usagePrefix, sw));
        }
        this.validateFlags();
        if (!this.arguments.isEmpty()) {
            AbstractSoyCompiler.exitWithError("Found unexpected extra arguments passed on the command line:\n  " + Joiner.on((String)" ").join(this.arguments));
        }
        if (this.requireSources() && this.srcs.isEmpty()) {
            AbstractSoyCompiler.exitWithError("Must provide list of source Soy files (--srcs).");
        }
        SoyFileSet.Builder sfsBuilder = new SoyFileSet.Builder(true);
        if (!this.pluginModules.isEmpty()) {
            Injector injector;
            guiceTimer.start();
            ArrayList<Module> modules = new ArrayList<Module>();
            modules.addAll(this.pluginModules);
            try {
                injector = Guice.createInjector(modules);
            }
            catch (Throwable t) {
                throw new CommandLineError("Failed to create Guice injector.  Is there a bug in one of the modules passed to --pluginModules?", t);
            }
            Optional.ofNullable(injector.getExistingBinding((Key)new Key<Set<SoyFunction>>(){})).ifPresent(b -> sfsBuilder.addSoyFunctions((Iterable)b.getProvider().get()));
            Optional.ofNullable(injector.getExistingBinding((Key)new Key<Set<SoyPrintDirective>>(){})).ifPresent(b -> sfsBuilder.addSoyPrintDirectives((Iterable)b.getProvider().get()));
            guiceTimer.stop();
        }
        sfsBuilder.addSourceFunctions(this.sourceFunctions).setWarningSink(err).setValidatedLoggingConfig(this.parseLoggingConfig()).setExperimentalFeatures(this.experimentalFeatures).addProtoDescriptors(AbstractSoyCompiler.parseProtos(this.protoFileDescriptors, this.cache, this.soyCompilerFileReader, err)).setCompileTimeGlobals(this.parseGlobals()).setSoyAstCache(this.cache.astCache());
        for (File src : this.srcs) {
            try {
                SourceFilePath normalizedPath = SourceFilePath.create(this.generatedFiles.getOrDefault(src.getPath(), src.getPath()));
                sfsBuilder.add(this.cache.createFileSupplier(src, normalizedPath, this.soyCompilerFileReader));
            }
            catch (FileNotFoundException fnfe) {
                throw new CommandLineError("File: " + src.getPath() + " passed to --srcs does not exist", fnfe);
            }
        }
        this.addCompilationUnitsToBuilder(sfsBuilder);
        if (this.disableOptimizer) {
            sfsBuilder.disableOptimizer();
        }
        sfsBuilder.setRequireTemplateImports(this.experimentalFeatures.contains("requireTemplateImports") && this.generatedFiles.isEmpty());
        this.compile(sfsBuilder);
        timer.stop();
        if (timer.elapsed().compareTo(Duration.ofSeconds(1L)) > 0 && guiceTimer.elapsed().compareTo(timer.elapsed().dividedBy(2L)) > 0) {
            err.println("WARNING: This compile took " + timer + " but more than 50% of that (" + guiceTimer + ") was creating a guice injector for plugins.  Please migrate to passing plugins via the --pluginFunctions flag to improve compiler performance.");
        }
    }

    @VisibleForTesting
    static List<Descriptors.FileDescriptor> parseProtos(List<File> protoFileDescriptors, SoyInputCache cache, SoyCompilerFileReader reader, PrintStream err) {
        SetMultimap protoFileToDescriptor = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
        ArrayList<CacheLoaders.CachedDescriptorSet> cachedDescriptors = new ArrayList<CacheLoaders.CachedDescriptorSet>(protoFileDescriptors.size());
        for (File file : protoFileDescriptors) {
            try {
                CacheLoaders.CachedDescriptorSet cachedDescriptor = cache.read(file, CacheLoaders.CACHED_DESCRIPTOR_SET_LOADER, reader);
                for (String protoFileName : cachedDescriptor.getProtoFileNames()) {
                    protoFileToDescriptor.put((Object)protoFileName, (Object)cachedDescriptor);
                }
                cachedDescriptors.add(cachedDescriptor);
            }
            catch (IOException ioe) {
                throw new CommandLineError("Error parsing proto file descriptor from " + file + ": " + ioe.getMessage());
            }
        }
        for (Map.Entry entry : Multimaps.asMap((SetMultimap)protoFileToDescriptor).entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            err.println("WARNING: " + (String)entry.getKey() + " has a descriptor defined in each of these files: " + ((Set)entry.getValue()).stream().map(c -> c.getFile().getPath()).sorted().collect(Collectors.joining(", ")) + ". Do your proto_library rules have overlapping sources?");
        }
        ArrayList<Descriptors.FileDescriptor> descriptors = new ArrayList<Descriptors.FileDescriptor>(protoFileToDescriptor.size());
        for (CacheLoaders.CachedDescriptorSet cachedDescriptor : cachedDescriptors) {
            try {
                descriptors.addAll(cachedDescriptor.getFileDescriptors((SetMultimap<String, CacheLoaders.CachedDescriptorSet>)protoFileToDescriptor, cache));
            }
            catch (Descriptors.DescriptorValidationException e) {
                throw new CommandLineError("Error parsing proto file descriptor from " + cachedDescriptor.getFile() + ": " + e.getMessage());
            }
        }
        return descriptors;
    }

    private void addCompilationUnitsToBuilder(SoyFileSet.Builder sfsBuilder) {
        HashSet<File> soFar = new HashSet<File>();
        for (File depHeader : this.depHeaders) {
            this.addCompilationUnitToBuilder(sfsBuilder, depHeader, SoyFileKind.DEP, soFar);
        }
        for (File indirectDep : this.indirectDepHeaders) {
            this.addCompilationUnitToBuilder(sfsBuilder, indirectDep, SoyFileKind.INDIRECT_DEP, soFar);
        }
    }

    private void addCompilationUnitToBuilder(SoyFileSet.Builder sfsBuilder, File depFile, SoyFileKind depKind, Set<File> soFar) {
        if (soFar.add(depFile)) {
            try {
                sfsBuilder.addCompilationUnit(depKind, SourceFilePath.create(depFile.getPath()), this.cache.read(depFile, CacheLoaders.COMPILATION_UNIT_LOADER, this.soyCompilerFileReader));
            }
            catch (IOException e) {
                throw new CommandLineError("Unable to read header file: " + depFile + ": " + e.getMessage());
            }
        }
    }

    protected Map<String, String> getGeneratedFiles() {
        return this.generatedFiles;
    }

    private ValidatedLoggingConfig parseLoggingConfig() {
        AnnotatedLoggingConfig.Builder configBuilder = AnnotatedLoggingConfig.newBuilder();
        for (File loggingConfig : this.loggingConfigs) {
            try {
                configBuilder.mergeFrom(this.cache.read(loggingConfig, CacheLoaders.LOGGING_CONFIG_LOADER, this.soyCompilerFileReader));
            }
            catch (IllegalArgumentException e) {
                throw new CommandLineError("Error parsing logging config proto: " + loggingConfig + ": " + e.getMessage());
            }
            catch (InvalidProtocolBufferException e) {
                throw new CommandLineError("Invalid logging config proto: " + loggingConfig + ": " + e.getMessage());
            }
            catch (IOException e) {
                throw new CommandLineError("Unable to read logging config proto: " + loggingConfig + ": " + e.getMessage());
            }
        }
        return ValidatedLoggingConfig.create(configBuilder.build());
    }

    private Map<String, PrimitiveData> parseGlobals() {
        HashMap<String, PrimitiveData> globals = new HashMap<String, PrimitiveData>();
        HashMap<String, File> globalsToFilePath = new HashMap<String, File>();
        for (File globalsFile : this.globalsFiles) {
            try {
                ImmutableMap<String, PrimitiveData> parsedGlobals = this.cache.read(globalsFile, CacheLoaders.GLOBALS_LOADER, this.soyCompilerFileReader);
                for (Map.Entry entry : parsedGlobals.entrySet()) {
                    PrimitiveData oldValue = globals.put((String)entry.getKey(), (PrimitiveData)entry.getValue());
                    if (oldValue != null && !((PrimitiveData)entry.getValue()).equals(oldValue)) {
                        throw new CommandLineError(String.format("Found 2 values for the global '%s': '%s' was provided in %s and '%s' was provided in %s", entry.getKey(), oldValue, globalsToFilePath.get(entry.getKey()), entry.getValue(), globalsFile));
                    }
                    globalsToFilePath.put((String)entry.getKey(), globalsFile);
                }
            }
            catch (IOException e) {
                throw new CommandLineError("Unable to soy globals file: " + globalsFile + ": " + e.getMessage());
            }
        }
        return globals;
    }

    @ForOverride
    protected void validateFlags() {
    }

    @ForOverride
    boolean requireSources() {
        return true;
    }

    @ForOverride
    Iterable<?> extraFlagsObjects() {
        return ImmutableList.of();
    }

    @ForOverride
    String formatCompilationException(SoyCompilationException sce) {
        return sce.getMessage();
    }

    @ForOverride
    protected abstract void compile(SoyFileSet.Builder var1) throws IOException;

    protected static final RuntimeException exitWithError(String errorMsg) {
        throw new CommandLineError(errorMsg);
    }
}

