/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.template.soy.AbstractSoyCompiler;
import com.google.template.soy.PluginLoader;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.SoyInputCache;
import com.google.template.soy.TemplateMetadataSerializer;
import com.google.template.soy.css.CssMetadata;
import com.google.template.soy.css.CssRegistry;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CompilationUnit;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.templatecall.TemplateCallMetadata;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.kohsuke.args4j.Option;

final class SoyHeaderCompiler
extends AbstractSoyCompiler {
    private static final int OUTPUT_STREAM_BUFFER_SIZE = 65536;
    @Option(name="--output", required=true, usage="[Required] The file name of the output file to be written.  Each compiler invocation will produce exactly one file containing all the TemplateMetadata")
    private File output;
    @Option(name="--cssMetadataOutput", usage="Where to write metadata about CSS.  This will be a file containing a gzipped CssMetadata proto")
    private File cssMetadataOutput = null;
    @Option(name="--templateCallMetadataOutput", usage="Where to write metadata about the template calls.  This will be a file containing a gzipped TemplateCallMetadata proto")
    private File templateCallMetadataOutput = null;

    SoyHeaderCompiler(PluginLoader loader, SoyInputCache cache) {
        super(loader, cache);
    }

    SoyHeaderCompiler() {
    }

    @Override
    protected void compile(SoyFileSet.Builder sfsBuilder) throws IOException {
        SoyFileSet.HeaderResult result = sfsBuilder.build().compileMinimallyForHeaders();
        CompilationUnit unit = TemplateMetadataSerializer.compilationUnitFromFileSet(result.fileSet(), result.templateRegistry());
        try (GZIPOutputStream os = new GZIPOutputStream((OutputStream)new FileOutputStream(this.output), 65536);){
            unit.writeTo(os);
        }
        if (this.cssMetadataOutput != null) {
            os = new GZIPOutputStream((OutputStream)new FileOutputStream(this.cssMetadataOutput), 65536);
            var5_5 = null;
            try {
                SoyHeaderCompiler.calculateCssMetadata(result.fileSet(), result.cssRegistry()).writeTo(os);
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                SoyHeaderCompiler.$closeResource(var5_5, os);
            }
        }
        if (this.templateCallMetadataOutput != null) {
            os = new GZIPOutputStream((OutputStream)new FileOutputStream(this.templateCallMetadataOutput), 65536);
            var5_5 = null;
            try {
                SoyHeaderCompiler.calculateTemplateCallMetadata(result.fileSet()).writeTo(os);
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                SoyHeaderCompiler.$closeResource(var5_5, os);
            }
        }
    }

    private static CssMetadata calculateCssMetadata(SoyFileSetNode fileSet, CssRegistry cssRegistry) {
        LinkedHashSet<String> requiredCssNames = new LinkedHashSet<String>();
        LinkedHashSet<String> requiredCssPaths = new LinkedHashSet<String>();
        for (SoyFileNode file : fileSet.getChildren()) {
            requiredCssNames.addAll((Collection<String>)file.getRequiredCssNamespaces());
            for (SoyFileNode.CssPath cssPath : file.getRequiredCssPaths()) {
                cssPath.resolvedPath().ifPresent(requiredCssPaths::add);
            }
            for (TemplateNode template : file.getTemplates()) {
                requiredCssNames.addAll((Collection<String>)template.getRequiredCssNamespaces());
            }
        }
        LinkedHashSet<String> cssClassNames = new LinkedHashSet<String>();
        SoyTreeUtils.allFunctionInvocations(fileSet, BuiltinFunction.CSS).forEach(fn -> cssClassNames.add(((StringNode)Iterables.getLast(fn.getChildren())).getValue()));
        return CssMetadata.newBuilder().addAllRequireCssNames(requiredCssNames).addAllRequireCssPaths(requiredCssPaths).addAllRequireCssPathsFromNamespaces(requiredCssNames.stream().map(namespace -> (String)cssRegistry.symbolToFilePath().get(namespace)).filter(f -> f != null).collect(Collectors.toList())).addAllCssClassNames(cssClassNames).build();
    }

    private static TemplateCallMetadata calculateTemplateCallMetadata(SoyFileSetNode fileSet) {
        TemplateCallMetadata.Builder templateCallMetadata = TemplateCallMetadata.newBuilder();
        for (SoyFileNode file : fileSet.getChildren()) {
            for (TemplateNode template : file.getTemplates()) {
                TemplateCallMetadata.Template.Builder templateMetadata = TemplateCallMetadata.Template.newBuilder().setName(template.getTemplateName()).setDelpackage(Strings.nullToEmpty((String)template.getDelPackageName()));
                for (CallNode callNode : SoyTreeUtils.getAllNodesOfType(template, CallNode.class)) {
                    templateMetadata.addCalls(TemplateCallMetadata.TemplateCall.newBuilder().setDestTemplateName(SoyHeaderCompiler.getDestTemplateName(callNode)).setIsDelcall(callNode.getKind() == SoyNode.Kind.CALL_DELEGATE_NODE).setDataArg(SoyHeaderCompiler.getDataArgStr(callNode)));
                }
                templateCallMetadata.addTemplates(templateMetadata.build());
            }
        }
        return templateCallMetadata.build();
    }

    private static String getDestTemplateName(CallNode callNode) {
        switch (callNode.getKind()) {
            case CALL_BASIC_NODE: {
                CallBasicNode basicNode = (CallBasicNode)callNode;
                return basicNode.isStaticCall() ? basicNode.getCalleeName() : basicNode.getCalleeExpr().toSourceString();
            }
            case CALL_DELEGATE_NODE: {
                return ((CallDelegateNode)callNode).getDelCalleeName();
            }
        }
        throw new IllegalStateException("Unknown CallNode kind");
    }

    private static String getDataArgStr(CallNode callNode) {
        return callNode.getDataExpr() != null ? callNode.getDataExpr().toSourceString() : (callNode.isPassingAllData() ? "all" : "");
    }

    public static void main(String[] args) throws IOException {
        new SoyHeaderCompiler().runMain(args);
    }
}

