/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.AbstractSoyCompiler;
import com.google.template.soy.PerInputOutputFiles;
import com.google.template.soy.PluginLoader;
import com.google.template.soy.SoyCmdLineParser;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.SoyInputCache;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.SoyMsgBundleHandler;
import com.google.template.soy.msgs.SoyMsgPlugin;
import com.google.template.soy.shared.internal.MainEntryPointUtils;
import com.google.template.soy.xliffmsgplugin.XliffMsgPlugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.Option;

public final class SoyToJsSrcCompiler
extends AbstractSoyCompiler {
    @Option(name="--allowExternalCalls", usage="Whether to allow external calls. New projects should set this to false, and existing projects should remove existing external calls and then set this to false. It will save you a lot of headaches. Currently defaults to true for backward compatibility.")
    private boolean allowExternalCalls = true;
    @Option(name="--locales", usage="[Required for generating localized JS] Comma-delimited list of locales for which to generate localized JS. There will be one output JS file for each combination of input Soy file and locale.", handler=SoyCmdLineParser.StringListOptionHandler.class)
    private List<String> locales = new ArrayList<String>();
    @Option(name="--messageFilePathFormat", usage="[Required for generating localized JS] A format string that specifies how to build the path to each translated messages file. The format string can include literal characters as well as the placeholders {INPUT_PREFIX}, {LOCALE}, and {LOCALE_LOWER_CASE}. Note {LOCALE_LOWER_CASE} also turns dash into underscore, e.g. pt-BR becomes pt_br. The format string must end with an extension matching the message file format (case-insensitive).")
    private String messageFilePathFormat = "";
    @Option(name="--shouldGenerateGoogMsgDefs", usage="When this option is used, all 'msg' blocks will be turned into goog.getMsg definitions and corresponding usages. Must be used with either --bidiGlobalDir, or --useGoogIsRtlForBidiGlobalDir, usually the latter. Also see --googMsgsAreExternal.")
    private boolean shouldGenerateGoogMsgDefs = false;
    @Option(name="--googMsgsAreExternal", usage="[Only applicable if --shouldGenerateGoogMsgDefs is true] If this option is true, then we generate \"var MSG_EXTERNAL_<soyGeneratedMsgId> = goog.getMsg(...);\". If this option is false, then we generate \"var MSG_UNNAMED_<uniquefier> = goog.getMsg(...);\".  [Explanation of true value] Set this option to true if your project is having Closure Templates do message extraction (e.g. with SoyMsgExtractor) and then having the Closure Compiler do translated message insertion.  [Explanation of false value] Set this option to false if your project is having the Closure Compiler do all of its localization, i.e. if you want the Closure Compiler to do both message extraction and translated message insertion. A significant drawback to this setup is that, if your templates are used from both JS and Java, you will end up with two separate and possibly different sets of translations for your messages.")
    private boolean googMsgsAreExternal = false;
    @Option(name="--bidiGlobalDir", usage="The bidi global directionality (ltr=1, rtl=-1). Only applicable if your Soy code uses bidi functions/directives. Also note that this flag is usually not necessary if a message file is provided, because by default the bidi global directionality is simply inferred from the message file.")
    private int bidiGlobalDir = 0;
    @Option(name="--useGoogIsRtlForBidiGlobalDir", usage="[Only applicable if both --shouldGenerateGoogMsgDefs is true] Whether to determine the bidi global direction at template runtime by evaluating (goog.i18n.bidi.IS_RTL). Do not combine with --bidiGlobalDir.")
    private boolean useGoogIsRtlForBidiGlobalDir = false;
    @Option(name="--messagePlugin", usage="Specifies the full class name of a SoyMsgPlugin. If not specified, the default is com.google.template.soy.xliffmsgplugin.XliffMsgPlugin. ")
    private SoyMsgPlugin messagePlugin = new XliffMsgPlugin();
    private final PerInputOutputFiles outputFiles = new PerInputOutputFiles("soy.js", PerInputOutputFiles.JS_JOINER);

    SoyToJsSrcCompiler(PluginLoader loader, SoyInputCache cache) {
        super(loader, cache);
    }

    SoyToJsSrcCompiler() {
    }

    public static void main(String[] args) throws IOException {
        new SoyToJsSrcCompiler().runMain(args);
    }

    @Override
    protected void validateFlags() {
        this.outputFiles.validateFlags();
    }

    @Override
    Iterable<?> extraFlagsObjects() {
        return ImmutableList.of((Object)this.outputFiles);
    }

    @Override
    protected void compile(SoyFileSet.Builder sfsBuilder) throws IOException {
        boolean generateLocalizedJs;
        sfsBuilder.setAllowExternalCalls(this.allowExternalCalls);
        SoyFileSet sfs = sfsBuilder.build();
        SoyJsSrcOptions jsSrcOptions = new SoyJsSrcOptions();
        jsSrcOptions.setShouldGenerateGoogMsgDefs(this.shouldGenerateGoogMsgDefs);
        jsSrcOptions.setGoogMsgsAreExternal(this.googMsgsAreExternal);
        jsSrcOptions.setBidiGlobalDir(this.bidiGlobalDir);
        jsSrcOptions.setUseGoogIsRtlForBidiGlobalDir(this.useGoogIsRtlForBidiGlobalDir);
        boolean bl = generateLocalizedJs = !this.locales.isEmpty();
        if (generateLocalizedJs) {
            for (String locale : this.locales) {
                String msgFilePath = MainEntryPointUtils.buildFilePath(this.messageFilePathFormat, locale, null);
                SoyMsgBundle msgBundle = new SoyMsgBundleHandler(this.messagePlugin).createFromFile(new File(msgFilePath));
                if (msgBundle.getLocaleString() == null && !locale.startsWith("en")) {
                    throw new IOException("Error opening or reading message file " + msgFilePath);
                }
                this.outputFiles.writeFiles(this.srcs, sfs.compileToJsSrcInternal(jsSrcOptions, msgBundle), locale);
            }
        } else {
            this.outputFiles.writeFiles(this.srcs, sfs.compileToJsSrcInternal(jsSrcOptions, null), null);
        }
    }
}

