/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

final class SoyValueUnconverter {
    private SoyValueUnconverter() {
    }

    static Object unconvert(SoyValueProvider provider) {
        SoyValue soyValue = provider.resolve();
        if (soyValue instanceof NullData) {
            return null;
        }
        if (soyValue instanceof BooleanData) {
            return ((BooleanData)soyValue).getValue();
        }
        if (soyValue instanceof IntegerData) {
            return ((IntegerData)soyValue).getValue();
        }
        if (soyValue instanceof FloatData) {
            return ((FloatData)soyValue).getValue();
        }
        if (soyValue instanceof StringData) {
            return ((StringData)soyValue).getValue();
        }
        if (soyValue instanceof SoyList) {
            return ((SoyList)soyValue).asResolvedJavaList().stream().map(SoyValueUnconverter::unconvert).collect(Collectors.toList());
        }
        if (soyValue instanceof SoyMap) {
            LinkedHashMap unconverted = new LinkedHashMap();
            ((SoyMap)soyValue).asJavaMap().forEach((key, value) -> unconverted.put(SoyValueUnconverter.unconvert(key), SoyValueUnconverter.unconvert(value)));
            return unconverted;
        }
        if (soyValue instanceof SoyProtoValue) {
            return ((SoyProtoValue)soyValue).getProto();
        }
        if (soyValue instanceof SoyRecord) {
            LinkedHashMap unconverted = new LinkedHashMap();
            ((SoyRecord)soyValue).recordAsMap().forEach((key, value) -> unconverted.put(key, SoyValueUnconverter.unconvert(value)));
            return unconverted;
        }
        if (soyValue instanceof SanitizedContent) {
            SanitizedContent sc = (SanitizedContent)soyValue;
            switch (sc.getContentKind()) {
                case ATTRIBUTES: {
                    return sc;
                }
                case CSS: {
                    try {
                        return sc.toSafeStyle();
                    }
                    catch (IllegalStateException e) {
                        return sc.toSafeStyleSheet();
                    }
                }
                case HTML: {
                    return sc.toSafeHtml();
                }
                case JS: {
                    return sc.toSafeScript();
                }
                case TRUSTED_RESOURCE_URI: {
                    return sc.toTrustedResourceUrl();
                }
                case URI: {
                    return sc.toSafeUrl();
                }
            }
            throw new IllegalArgumentException(sc.getContentKind().toString());
        }
        throw new IllegalArgumentException("Can't unconvert values of type: " + soyValue.getClass().getName());
    }
}

