/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.ParamStore;
import java.util.Map;
import javax.annotation.Nonnull;

public final class BasicParamStore
extends ParamStore {
    private final Map<String, SoyValueProvider> localStore;

    public BasicParamStore(int size) {
        this.localStore = Maps.newHashMapWithExpectedSize((int)size);
    }

    @Override
    public BasicParamStore setField(String name, @Nonnull SoyValueProvider valueProvider) {
        Preconditions.checkNotNull((Object)valueProvider);
        this.localStore.put(name, valueProvider);
        return this;
    }

    @Override
    public boolean hasField(String name) {
        return this.localStore.containsKey(name);
    }

    @Override
    public SoyValueProvider getFieldProvider(String name) {
        return this.localStore.get(name);
    }

    @Override
    public ImmutableMap<String, SoyValueProvider> recordAsMap() {
        return ImmutableMap.copyOf(this.localStore);
    }
}

