/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.common.base.Preconditions;
import java.text.MessageFormat;

public final class SoyErrorKind {
    private final MessageFormat messageFormat;
    private final int requiredArgs;

    private SoyErrorKind(MessageFormat messageFormat) {
        this.messageFormat = messageFormat;
        this.requiredArgs = messageFormat.getFormatsByArgumentIndex().length;
    }

    public String format(Object ... args) {
        Preconditions.checkState((args.length == this.requiredArgs ? 1 : 0) != 0, (String)"Error format (%s) required %s parameters, %s were supplied.", (Object)this.messageFormat.toPattern(), (Object)this.requiredArgs, (Object)args.length);
        return this.messageFormat.format(args);
    }

    public static SoyErrorKind of(String format, StyleAllowance ... exceptions) {
        SoyErrorKind.checkFormat(format, exceptions);
        return new SoyErrorKind(new MessageFormat(format));
    }

    private static void checkFormat(String format, StyleAllowance ... exceptions) {
        char lastChar;
        int index = 0;
        int singleQuote = 39;
        while ((index = format.indexOf(singleQuote, index)) != -1) {
            int nextIndex = format.indexOf(singleQuote, index + 1);
            if (nextIndex == -1) {
                throw new IllegalArgumentException("Found an unmatched single quote at char: " + index + " in '" + format + "'");
            }
            index = nextIndex + 1;
        }
        boolean checkCaps = true;
        boolean checkPunctuation = true;
        for (StyleAllowance ex : exceptions) {
            if (ex == StyleAllowance.NO_CAPS) {
                checkCaps = false;
            }
            if (ex != StyleAllowance.NO_PUNCTUATION) continue;
            checkPunctuation = false;
        }
        if (checkCaps && Character.isLowerCase(format.charAt(0))) {
            throw new IllegalArgumentException("Message must start with a capital letter: " + format);
        }
        if (checkPunctuation && Character.getType(lastChar = format.charAt(format.length() - 1)) != 24) {
            throw new IllegalArgumentException("Message must end with punctuation: " + format);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.messageFormat.toPattern() + "}";
    }

    public static enum StyleAllowance {
        NO_CAPS,
        NO_PUNCTUATION;

    }
}

