/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractExprNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.UnknownType;

public final class GlobalNode
extends AbstractExprNode {
    private Identifier identifier;
    private boolean suppressUnknownGlobalErrors;
    private ExprNode.PrimitiveNode value = null;
    private SoyType soyType = UnknownType.getInstance();
    private ResolutionCallback resolveCallback;

    public static GlobalNode error(SourceLocation location) {
        return new GlobalNode(Identifier.create("error", "error", location));
    }

    public GlobalNode(Identifier identifier) {
        super(identifier.location());
        this.identifier = identifier;
    }

    private GlobalNode(GlobalNode orig, CopyState copyState) {
        super(orig, copyState);
        this.identifier = orig.identifier;
        this.soyType = orig.soyType;
        this.value = orig.value == null ? null : orig.value.copy(copyState);
        this.resolveCallback = orig.resolveCallback;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.GLOBAL_NODE;
    }

    @Override
    public SoyType getType() {
        return this.soyType;
    }

    public void upgradeTemplateType(SoyType type) {
        Preconditions.checkState((this.soyType != null ? 1 : 0) != 0);
        this.soyType = (SoyType)Preconditions.checkNotNull((Object)type);
    }

    public void resolve(SoyType soyType, ExprNode.PrimitiveNode value) {
        Preconditions.checkState((this.value == null ? 1 : 0) != 0, (Object)"value has already been set");
        this.soyType = (SoyType)Preconditions.checkNotNull((Object)soyType);
        this.value = (ExprNode.PrimitiveNode)Preconditions.checkNotNull((Object)value);
        if (this.resolveCallback != null) {
            this.resolveCallback.onResolve(value);
            this.resolveCallback = null;
        }
    }

    public void onResolve(ResolutionCallback callback) {
        Preconditions.checkState((this.resolveCallback == null ? 1 : 0) != 0, (Object)"callback has already been set.");
        Preconditions.checkState((this.value == null ? 1 : 0) != 0, (Object)"value is resolved.");
        this.resolveCallback = (ResolutionCallback)Preconditions.checkNotNull((Object)callback);
    }

    public boolean isResolved() {
        return this.value != null;
    }

    public ExprNode.PrimitiveNode getValue() {
        return this.value;
    }

    public String getName() {
        return this.identifier.identifier();
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setName(String name) {
        this.identifier = Identifier.create(name, this.identifier.originalName(), this.identifier.location());
    }

    public void suppressUnknownGlobalErrors() {
        this.suppressUnknownGlobalErrors = true;
    }

    public boolean shouldSuppressUnknownGlobalErrors() {
        return this.suppressUnknownGlobalErrors;
    }

    @Override
    public String toSourceString() {
        return this.identifier.originalName();
    }

    @Override
    public GlobalNode copy(CopyState copyState) {
        return new GlobalNode(this, copyState);
    }

    public static interface ResolutionCallback {
        public void onResolve(ExprNode.PrimitiveNode var1);
    }
}

