/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.ExprNode;

public final class RecordLiteralNode
extends AbstractParentExprNode {
    private final Identifier recordIdentifier;
    private final ImmutableList<Identifier> keys;

    public RecordLiteralNode(Identifier recordIdentifier, Iterable<Identifier> keys, SourceLocation sourceLocation) {
        super(sourceLocation);
        this.recordIdentifier = recordIdentifier;
        this.keys = ImmutableList.copyOf(keys);
    }

    private RecordLiteralNode(RecordLiteralNode orig, CopyState copyState) {
        super(orig, copyState);
        this.recordIdentifier = orig.recordIdentifier;
        this.keys = orig.keys;
    }

    public Identifier getRecordIdentifier() {
        return this.recordIdentifier;
    }

    public ImmutableList<Identifier> getKeys() {
        return this.keys;
    }

    public Identifier getKey(int i) {
        return (Identifier)this.keys.get(i);
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.RECORD_LITERAL_NODE;
    }

    @Override
    public String toSourceString() {
        StringBuilder sourceSb = new StringBuilder();
        sourceSb.append("record(");
        int n = this.numChildren();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                sourceSb.append(", ");
            }
            sourceSb.append(this.getKey(i)).append(": ").append(this.getChild(i).toSourceString());
        }
        sourceSb.append(')');
        return sourceSb.toString();
    }

    @Override
    public RecordLiteralNode copy(CopyState copyState) {
        return new RecordLiteralNode(this, copyState);
    }
}

