/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractExprNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.types.SoyType;
import javax.annotation.Nullable;

public final class VarRefNode
extends AbstractExprNode {
    private final String name;
    private VarDefn defn;
    private SoyType substituteType;

    public static VarRefNode error(SourceLocation location) {
        return new VarRefNode("$error", location, null);
    }

    public VarRefNode(String name, SourceLocation sourceLocation, @Nullable VarDefn defn) {
        super(sourceLocation);
        this.name = name;
        this.defn = defn;
    }

    private VarRefNode(VarRefNode orig, CopyState copyState) {
        super(orig, copyState);
        this.name = orig.name;
        this.substituteType = orig.substituteType;
        if (orig.defn != null) {
            if (orig.defn instanceof VarDefn.ImmutableVarDefn) {
                this.defn = orig.defn;
            } else {
                this.defn = orig.defn;
                copyState.registerRefListener(orig.defn, this::setDefn);
            }
        }
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.VAR_REF_NODE;
    }

    @Override
    public SoyType getType() {
        Preconditions.checkState((this.defn != null ? 1 : 0) != 0);
        return this.substituteType != null ? this.substituteType : this.defn.type();
    }

    public boolean hasType() {
        return this.defn != null && (this.substituteType != null || this.defn.hasType());
    }

    public String getName() {
        return this.name;
    }

    public String getNameWithoutLeadingDollar() {
        return this.name.startsWith("$") ? this.name.substring(1) : this.name;
    }

    public boolean isInjected() {
        return this.defn.isInjected();
    }

    public void setDefn(VarDefn defn) {
        this.defn = defn;
    }

    public VarDefn getDefnDecl() {
        return this.defn;
    }

    public boolean isLocalVar() {
        return this.defn.kind() == VarDefn.Kind.LOCAL_VAR;
    }

    public Boolean isPossibleHeaderVar() {
        if (this.defn == null) {
            throw new NullPointerException(this.getSourceLocation().toString());
        }
        return this.defn.kind() == VarDefn.Kind.PARAM || this.defn.kind() == VarDefn.Kind.STATE || this.defn.kind() == VarDefn.Kind.UNDECLARED;
    }

    public void setSubstituteType(SoyType type) {
        this.substituteType = type;
    }

    @Override
    public String toSourceString() {
        return this.name;
    }

    @Override
    public VarRefNode copy(CopyState copyState) {
        return new VarRefNode(this, copyState);
    }
}

