/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.i18ndirectives;

import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.NumberData;
import com.ibm.icu.text.CompactDecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import javax.annotation.Nullable;

public final class I18NDirectivesRuntime {
    private I18NDirectivesRuntime() {
    }

    public static String formatNum(ULocale uLocale, @Nullable SoyValue number, String formatType, String numbersKeyword, @Nullable NumberData minFractionDigits, @Nullable NumberData maxFractionDigits) {
        if (number == null) {
            return "";
        }
        if (number instanceof NumberData) {
            return I18NDirectivesRuntime.formatInternal(uLocale, ((NumberData)number).toFloat(), formatType, numbersKeyword, minFractionDigits != null ? Integer.valueOf((int)minFractionDigits.numberValue()) : null, maxFractionDigits != null ? Integer.valueOf((int)maxFractionDigits.numberValue()) : null);
        }
        return "NaN";
    }

    private static String formatInternal(ULocale uLocale, double number, String formatType, String numbersKeyword, @Nullable Integer minFractionDigits, @Nullable Integer maxFractionDigits) {
        NumberFormat numberFormat;
        uLocale = uLocale.setKeywordValue("numbers", numbersKeyword);
        switch (formatType) {
            case "decimal": {
                numberFormat = NumberFormat.getInstance((ULocale)uLocale);
                break;
            }
            case "percent": {
                numberFormat = NumberFormat.getPercentInstance((ULocale)uLocale);
                break;
            }
            case "currency": {
                numberFormat = NumberFormat.getCurrencyInstance((ULocale)uLocale);
                break;
            }
            case "scientific": {
                numberFormat = NumberFormat.getScientificInstance((ULocale)uLocale);
                break;
            }
            case "compact_short": {
                numberFormat = CompactDecimalFormat.getInstance((ULocale)uLocale, (CompactDecimalFormat.CompactStyle)CompactDecimalFormat.CompactStyle.SHORT);
                break;
            }
            case "compact_long": {
                numberFormat = CompactDecimalFormat.getInstance((ULocale)uLocale, (CompactDecimalFormat.CompactStyle)CompactDecimalFormat.CompactStyle.LONG);
                break;
            }
            default: {
                throw new IllegalArgumentException("First argument to formatNum must be constant, and one of: 'decimal', 'currency', 'percent', 'scientific', 'compact_short', or 'compact_long'.");
            }
        }
        if (minFractionDigits != null || maxFractionDigits != null) {
            if (maxFractionDigits == null) {
                maxFractionDigits = minFractionDigits;
            }
            if (minFractionDigits != null) {
                numberFormat.setMinimumFractionDigits(minFractionDigits.intValue());
            }
            numberFormat.setMaximumFractionDigits(maxFractionDigits.intValue());
        } else if (numberFormat instanceof CompactDecimalFormat) {
            ((CompactDecimalFormat)numberFormat).setMaximumSignificantDigits(3);
        }
        return numberFormat.format(number);
    }
}

