/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.jbcsrc.AutoValue_CompiledTemplateMetadata;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.ConstructorRef;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

@AutoValue
abstract class CompiledTemplateMetadata {
    private static final Method GENERATED_CONSTRUCTOR = new Method("<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{BytecodeUtils.SOY_RECORD_TYPE, BytecodeUtils.SOY_RECORD_TYPE}));
    private static final Method RENDER_METHOD;
    private static final Method FACTORY_METHOD;

    CompiledTemplateMetadata() {
    }

    static CompiledTemplateMetadata create(String templateName) {
        String className = Names.javaClassNameFromSoyTemplateName(templateName);
        TypeInfo type = TypeInfo.createClass(className);
        return new AutoValue_CompiledTemplateMetadata(ConstructorRef.create(type, GENERATED_CONSTRUCTOR), MethodRef.createInstanceMethod(type, RENDER_METHOD).asNonNullable(), MethodRef.createStaticMethod(type, FACTORY_METHOD).asCheap(), type);
    }

    abstract ConstructorRef constructor();

    abstract MethodRef renderMethod();

    abstract MethodRef factoryMethod();

    abstract TypeInfo typeInfo();

    static {
        FACTORY_METHOD = new Method("factory", Type.getMethodDescriptor((Type)BytecodeUtils.COMPILED_TEMPLATE_FACTORY_TYPE, (Type[])new Type[0]));
        try {
            RENDER_METHOD = Method.getMethod((java.lang.reflect.Method)CompiledTemplate.class.getMethod("render", LoggingAdvisingAppendable.class, RenderContext.class));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

