/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyCompilationException;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.jbcsrc.JavaSourceFunctionCompiler;
import com.google.template.soy.jbcsrc.TemplateCompiler;
import com.google.template.soy.jbcsrc.internal.AbstractMemoryClassLoader;
import com.google.template.soy.jbcsrc.internal.ClassData;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class CompilingClassLoader
extends AbstractMemoryClassLoader {
    private final Map<String, ClassData> classesByName = Collections.synchronizedMap(new HashMap());
    private final ImmutableMap<SourceFilePath, SoyFileSupplier> filePathsToSuppliers;
    private final ImmutableMap<String, TemplateNode> templateNameToTemplateNode;
    private final SoyTypeRegistry typeRegistry;

    CompilingClassLoader(SoyFileSetNode fileSet, ImmutableMap<SourceFilePath, SoyFileSupplier> filePathsToSuppliers, SoyTypeRegistry typeRegistry) {
        ImmutableMap.Builder templateNameToTemplateNode = ImmutableMap.builder();
        for (SoyFileNode file : fileSet.getChildren()) {
            for (TemplateNode template : file.getTemplates()) {
                templateNameToTemplateNode.put((Object)template.getTemplateName(), (Object)template);
            }
        }
        this.templateNameToTemplateNode = templateNameToTemplateNode.build();
        this.typeRegistry = typeRegistry;
        this.filePathsToSuppliers = filePathsToSuppliers;
    }

    @Override
    protected ClassData getClassData(String name) {
        ClassData classDef = this.classesByName.remove(name);
        if (classDef != null) {
            return classDef;
        }
        if (!name.startsWith("com.google.template.soy.jbcsrc.gen.")) {
            return null;
        }
        String templateName = Names.soyTemplateNameFromJavaClassName(name);
        TemplateNode node = (TemplateNode)this.templateNameToTemplateNode.get((Object)templateName);
        if (node == null) {
            return null;
        }
        CompiledTemplateMetadata meta = CompiledTemplateMetadata.create(templateName);
        ClassData clazzToLoad = null;
        ErrorReporter reporter = ErrorReporter.create(this.filePathsToSuppliers);
        for (ClassData clazz : new TemplateCompiler(meta, node, new JavaSourceFunctionCompiler(this.typeRegistry, reporter)).compile()) {
            String className = clazz.type().className();
            if (className.equals(name)) {
                clazzToLoad = clazz;
                continue;
            }
            this.classesByName.put(className, clazz);
        }
        if (reporter.hasErrors()) {
            Iterable errors = Iterables.concat(reporter.getErrors(), reporter.getWarnings());
            throw new SoyCompilationException(errors);
        }
        return clazzToLoad;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

