/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.jbcsrc.AutoValue_ControlFlow_IfBlock;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.Statement;
import java.util.List;
import java.util.Optional;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class ControlFlow {
    private ControlFlow() {
    }

    static Statement ifElseChain(final List<IfBlock> ifs, final Optional<Statement> elseBlock) {
        Preconditions.checkArgument((!ifs.isEmpty() ? 1 : 0) != 0);
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Label end = new Label();
                for (int i = 0; i < ifs.size(); ++i) {
                    IfBlock curr = (IfBlock)ifs.get(i);
                    boolean isLastIfBlock = i == ifs.size() - 1;
                    Label next = isLastIfBlock && !elseBlock.isPresent() ? end : new Label();
                    curr.condition().gen(adapter);
                    adapter.ifZCmp(153, next);
                    curr.block().gen(adapter);
                    if (end != next) {
                        adapter.goTo(end);
                    }
                    adapter.mark(next);
                }
                if (elseBlock.isPresent()) {
                    ((Statement)elseBlock.get()).gen(adapter);
                    adapter.mark(end);
                }
            }
        };
    }

    @AutoValue
    static abstract class IfBlock {
        IfBlock() {
        }

        static IfBlock create(Expression cond, Statement block) {
            cond.checkAssignableTo(Type.BOOLEAN_TYPE);
            return new AutoValue_ControlFlow_IfBlock(cond, block);
        }

        abstract Expression condition();

        abstract Statement block();

        Statement asStatement() {
            return ControlFlow.ifElseChain((List<IfBlock>)ImmutableList.of((Object)this), Optional.empty());
        }
    }
}

