/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.template.soy.jbcsrc.AppendableExpression;
import com.google.template.soy.jbcsrc.AutoValue_DetachState_ReattachState;
import com.google.template.soy.jbcsrc.ExpressionDetacher;
import com.google.template.soy.jbcsrc.FieldManager;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class DetachState
implements ExpressionDetacher.Factory {
    private final TemplateVariableManager variables;
    private final List<ReattachState> reattaches = new ArrayList<ReattachState>();
    private final Expression thisExpr;
    private final FieldManager fields;
    @Nullable
    private FieldRef stateField;
    int disabledCount;

    DetachState(TemplateVariableManager variables, Expression thisExpr, FieldManager fields) {
        this.variables = variables;
        this.thisExpr = thisExpr;
        this.fields = fields;
    }

    private FieldRef getStateField() {
        if (this.stateField == null) {
            this.stateField = this.fields.addField("$state", Type.INT_TYPE);
        }
        return this.stateField;
    }

    NoNewDetaches expectNoNewDetaches() {
        ++this.disabledCount;
        return () -> {
            --this.disabledCount;
            if (this.disabledCount < 0) {
                throw new AssertionError();
            }
        };
    }

    private void checkDetachesAllowed() {
        if (this.disabledCount > 0) {
            throw new IllegalStateException();
        }
    }

    @Override
    public ExpressionDetacher createExpressionDetacher(Label reattachPoint) {
        return new ExpressionDetacher.BasicDetacher(() -> {
            this.checkDetachesAllowed();
            TemplateVariableManager.SaveRestoreState saveRestoreState = this.variables.saveRestoreState();
            int state = this.addState(reattachPoint, saveRestoreState.restore());
            Statement saveState = this.getStateField().putInstanceField(this.thisExpr, BytecodeUtils.constant(state));
            return Statement.concat(saveRestoreState.save().orElse(Statement.NULL_STATEMENT), saveState);
        });
    }

    Statement detachLimited(AppendableExpression appendable) {
        this.checkDetachesAllowed();
        this.variables.assertSaveRestoreStateIsEmpty();
        if (!appendable.supportsSoftLimiting()) {
            return appendable.toStatement();
        }
        final Expression isSoftLimited = appendable.softLimitReached();
        final Statement returnLimited = Statement.returnExpression(MethodRef.RENDER_RESULT_LIMITED.invoke(new Expression[0]));
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Label continueLabel = new Label();
                isSoftLimited.gen(adapter);
                adapter.ifZCmp(153, continueLabel);
                returnLimited.gen(adapter);
                adapter.mark(continueLabel);
            }
        };
    }

    Statement assertFullyRenderered(Expression render) {
        return render.invokeVoid(MethodRef.RENDER_RESULT_ASSERT_DONE, new Expression[0]);
    }

    Statement detachForRender(final Expression render) {
        this.checkDetachesAllowed();
        Preconditions.checkArgument((boolean)render.resultType().equals((Object)BytecodeUtils.RENDER_RESULT_TYPE));
        final Label reattachPoint = new Label();
        final TemplateVariableManager.SaveRestoreState saveRestoreState = this.variables.saveRestoreState();
        int state = this.addState(reattachPoint, saveRestoreState.restore());
        final Statement saveState = this.getStateField().putInstanceField(this.thisExpr, BytecodeUtils.constant(state));
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                adapter.mark(reattachPoint);
                render.gen(adapter);
                adapter.dup();
                MethodRef.RENDER_RESULT_IS_DONE.invokeUnchecked(adapter);
                Label end = new Label();
                adapter.ifZCmp(154, end);
                saveRestoreState.save().orElse(Statement.NULL_STATEMENT).gen(adapter);
                saveState.gen(adapter);
                adapter.returnValue();
                adapter.mark(end);
                adapter.pop();
            }
        };
    }

    Statement generateReattachTable() {
        if (this.stateField == null) {
            Preconditions.checkState((boolean)this.reattaches.isEmpty(), (String)"expected no reattaches: %s", this.reattaches);
            return Statement.NULL_STATEMENT;
        }
        if (this.reattaches.isEmpty()) {
            throw new IllegalStateException("inconsistent state, never generated a state but has reattach logic.");
        }
        final Expression readField = this.getStateField().accessor(this.thisExpr);
        final Label unexpectedState = new Label();
        Label end = new Label();
        final ArrayList<Label> caseLabels = new ArrayList<Label>();
        ArrayList<Statement> casesToGen = new ArrayList<Statement>();
        caseLabels.add(end);
        for (final ReattachState reattachState : this.reattaches) {
            if (reattachState.restoreStatement().isPresent()) {
                Label caseLabel = new Label();
                Statement caseBody = Statement.concat(reattachState.restoreStatement().get(), new Statement(){

                    @Override
                    protected void doGen(CodeBuilder cb) {
                        cb.goTo(reattachState.reattachPoint());
                    }
                }).labelStart(caseLabel);
                casesToGen.add(caseBody);
                caseLabels.add(caseLabel);
                continue;
            }
            caseLabels.add(reattachState.reattachPoint());
        }
        casesToGen.add(Statement.throwExpression(MethodRef.RUNTIME_UNEXPECTED_STATE_ERROR.invoke(this.getStateField().accessor(this.thisExpr))).labelStart(unexpectedState));
        return Statement.concat(new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                readField.gen(adapter);
                adapter.visitTableSwitchInsn(0, DetachState.this.reattaches.size(), unexpectedState, caseLabels.toArray(new Label[0]));
            }
        }, Statement.concat(casesToGen)).labelEnd(end);
    }

    private int addState(Label reattachPoint, Optional<Statement> restore) {
        ReattachState create = ReattachState.create(reattachPoint, restore);
        this.reattaches.add(create);
        return this.reattaches.size();
    }

    int getNumberOfDetaches() {
        return this.reattaches.size();
    }

    @AutoValue
    static abstract class ReattachState {
        ReattachState() {
        }

        static ReattachState create(Label reattachPoint, Optional<Statement> restore) {
            return new AutoValue_DetachState_ReattachState(reattachPoint, restore);
        }

        abstract Label reattachPoint();

        abstract Optional<Statement> restoreStatement();
    }

    static interface NoNewDetaches
    extends AutoCloseable {
        @Override
        public void close();
    }
}

