/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.jbcsrc.AbstractTemplateParameterLookup;
import com.google.template.soy.jbcsrc.AppendableExpression;
import com.google.template.soy.jbcsrc.AutoValue_SoyNodeCompiler_CompiledForeachRangeArgs;
import com.google.template.soy.jbcsrc.AutoValue_SoyNodeCompiler_CompiledMethodBody;
import com.google.template.soy.jbcsrc.ControlFlow;
import com.google.template.soy.jbcsrc.DetachState;
import com.google.template.soy.jbcsrc.ExpressionCompiler;
import com.google.template.soy.jbcsrc.ExpressionDetacher;
import com.google.template.soy.jbcsrc.ExpressionToSoyValueProviderCompiler;
import com.google.template.soy.jbcsrc.ExtraCodeCompiler;
import com.google.template.soy.jbcsrc.FieldManager;
import com.google.template.soy.jbcsrc.JavaSourceFunctionCompiler;
import com.google.template.soy.jbcsrc.LazyClosureCompiler;
import com.google.template.soy.jbcsrc.MsgCompiler;
import com.google.template.soy.jbcsrc.PrintDirectives;
import com.google.template.soy.jbcsrc.RenderContextExpression;
import com.google.template.soy.jbcsrc.SyntheticVarName;
import com.google.template.soy.jbcsrc.TemplateAnalysis;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.UnexpectedCompilerFailureException;
import com.google.template.soy.jbcsrc.internal.InnerClasses;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.ConstructorRef;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyRuntimeType;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.shared.ClassLoaderFallbackCallFactory;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.shared.RangeArgs;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractReturningSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class SoyNodeCompiler
extends AbstractReturningSoyNodeVisitor<Statement> {
    final TemplateAnalysis analysis;
    final Expression thisVar;
    final InnerClasses innerClasses;
    final DetachState detachState;
    final TemplateVariableManager variables;
    final AbstractTemplateParameterLookup parameterLookup;
    final FieldManager fields;
    final AppendableExpression appendableExpression;
    final ExpressionCompiler exprCompiler;
    final ExpressionToSoyValueProviderCompiler expressionToSoyValueProviderCompiler;
    final ExpressionCompiler.BasicExpressionCompiler constantCompiler;
    final JavaSourceFunctionCompiler javaSourceFunctionCompiler;
    private TemplateVariableManager.Scope currentScope;
    private static final Handle CONSTRUCTION_HANDLE = MethodRef.create(ClassLoaderFallbackCallFactory.class, "bootstrapConstruction", MethodHandles.Lookup.class, String.class, MethodType.class, String.class).asHandle();
    private static final String TEMPLATE_CONSTRUCTION_SIGNATURE = Type.getMethodDescriptor((Type)BytecodeUtils.COMPILED_TEMPLATE_TYPE, (Type[])new Type[]{BytecodeUtils.RENDER_CONTEXT_TYPE, BytecodeUtils.SOY_RECORD_TYPE, BytecodeUtils.SOY_RECORD_TYPE});

    static SoyNodeCompiler create(TemplateAnalysis analysis, InnerClasses innerClasses, Expression thisVar, AppendableExpression appendableVar, TemplateVariableManager variables, AbstractTemplateParameterLookup parameterLookup, FieldManager fields, ExpressionCompiler.BasicExpressionCompiler constantCompiler, JavaSourceFunctionCompiler javaSourceFunctionCompiler) {
        DetachState detachState = new DetachState(variables, thisVar, fields);
        ExpressionCompiler expressionCompiler = ExpressionCompiler.create(analysis, parameterLookup, variables, javaSourceFunctionCompiler);
        ExpressionToSoyValueProviderCompiler soyValueProviderCompiler = ExpressionToSoyValueProviderCompiler.create(analysis, expressionCompiler, parameterLookup);
        return new SoyNodeCompiler(analysis, thisVar, innerClasses, detachState, variables, parameterLookup, fields, appendableVar, expressionCompiler, soyValueProviderCompiler, constantCompiler, javaSourceFunctionCompiler);
    }

    SoyNodeCompiler(TemplateAnalysis analysis, Expression thisVar, InnerClasses innerClasses, DetachState detachState, TemplateVariableManager variables, AbstractTemplateParameterLookup parameterLookup, FieldManager fields, AppendableExpression appendableExpression, ExpressionCompiler exprCompiler, ExpressionToSoyValueProviderCompiler expressionToSoyValueProviderCompiler, ExpressionCompiler.BasicExpressionCompiler constantCompiler, JavaSourceFunctionCompiler javaSourceFunctionCompiler) {
        this.analysis = (TemplateAnalysis)Preconditions.checkNotNull((Object)analysis);
        this.thisVar = (Expression)Preconditions.checkNotNull((Object)thisVar);
        this.innerClasses = innerClasses;
        this.detachState = (DetachState)Preconditions.checkNotNull((Object)detachState);
        this.variables = (TemplateVariableManager)Preconditions.checkNotNull((Object)variables);
        this.parameterLookup = (AbstractTemplateParameterLookup)Preconditions.checkNotNull((Object)parameterLookup);
        this.fields = (FieldManager)Preconditions.checkNotNull((Object)fields);
        this.appendableExpression = (AppendableExpression)Preconditions.checkNotNull((Object)appendableExpression);
        this.exprCompiler = (ExpressionCompiler)Preconditions.checkNotNull((Object)exprCompiler);
        this.expressionToSoyValueProviderCompiler = (ExpressionToSoyValueProviderCompiler)Preconditions.checkNotNull((Object)expressionToSoyValueProviderCompiler);
        this.constantCompiler = constantCompiler;
        this.javaSourceFunctionCompiler = javaSourceFunctionCompiler;
    }

    CompiledMethodBody compile(SoyNode.RenderUnitNode node, ExtraCodeCompiler prefix, ExtraCodeCompiler suffix) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        if (SoyNodeCompiler.shouldCheckForSoftLimit(node)) {
            statements.add(this.detachState.detachLimited(this.appendableExpression));
        }
        statements.add(this.doCompile(node, prefix, suffix));
        statements.add(0, this.detachState.generateReattachTable());
        return CompiledMethodBody.create(Statement.concat(statements), this.detachState.getNumberOfDetaches());
    }

    Statement compileWithoutDetaches(SoyNode.RenderUnitNode node, ExtraCodeCompiler prefix, ExtraCodeCompiler suffix) {
        try (DetachState.NoNewDetaches noNewDetaches = this.detachState.expectNoNewDetaches();){
            Statement statement = this.doCompile(node, prefix, suffix);
            return statement;
        }
    }

    private Statement doCompile(SoyNode.RenderUnitNode node, ExtraCodeCompiler prefix, ExtraCodeCompiler suffix) {
        return Statement.concat(this.appendableExpression.setSanitizedContentKindAndDirectionality(node.getContentKind()).toStatement(), prefix.compile(this.exprCompiler, this.appendableExpression, this.detachState), this.visitChildrenInNewScope(node), suffix.compile(this.exprCompiler, this.appendableExpression, this.detachState));
    }

    @Override
    protected Statement visit(SoyNode node) {
        try {
            return ((Statement)super.visit(node)).withSourceLocation(node.getSourceLocation());
        }
        catch (UnexpectedCompilerFailureException e) {
            e.addLocation(node);
            throw e;
        }
        catch (Throwable t) {
            throw new UnexpectedCompilerFailureException(node, t);
        }
    }

    private static boolean kindRequiresDetach(SanitizedContentKind kind) {
        switch (kind) {
            case TEXT: 
            case HTML: 
            case HTML_ELEMENT: 
            case CSS: 
            case JS: {
                return true;
            }
            case TRUSTED_RESOURCE_URI: 
            case URI: 
            case ATTRIBUTES: {
                return false;
            }
        }
        throw new AssertionError((Object)("invalid kind: " + (Object)((Object)kind)));
    }

    private static boolean directlyPrintingNode(Node node) {
        if (node instanceof SoyNode) {
            SoyNode.Kind kind = ((SoyNode)node).getKind();
            return kind == SoyNode.Kind.RAW_TEXT_NODE || kind == SoyNode.Kind.PRINT_NODE;
        }
        return false;
    }

    private static boolean shouldCheckForSoftLimit(SoyNode.RenderUnitNode node) {
        if (!(node instanceof TemplateNode)) {
            return false;
        }
        if (!SoyNodeCompiler.kindRequiresDetach(node.getContentKind())) {
            return false;
        }
        return SoyTreeUtils.allNodes(node, n -> {
            if (!(n instanceof SoyNode) || n instanceof LetContentNode || n instanceof CallParamContentNode) {
                return SoyTreeUtils.VisitDirective.SKIP_CHILDREN;
            }
            return SoyTreeUtils.VisitDirective.CONTINUE;
        }).anyMatch(SoyNodeCompiler::directlyPrintingNode);
    }

    @Override
    protected Statement visitTemplateNode(TemplateNode node) {
        throw new AssertionError((Object)"should not be called");
    }

    private Statement visitChildrenInNewScope(SoyNode.BlockNode node) {
        TemplateVariableManager.Scope prev = this.currentScope;
        this.currentScope = this.variables.enterScope();
        List children = this.visitChildren(node);
        Statement leave = this.currentScope.exitScope();
        children.add(leave);
        this.currentScope = prev;
        return Statement.concat(children);
    }

    @Override
    protected Statement visitIfNode(IfNode node) {
        ArrayList<ControlFlow.IfBlock> ifs = new ArrayList<ControlFlow.IfBlock>();
        Optional<Statement> elseBlock = Optional.empty();
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode icn = (IfCondNode)child;
                SoyExpression cond = this.exprCompiler.compileRootExpression(icn.getExpr(), this.detachState).coerceToBoolean();
                Statement block = this.visitChildrenInNewScope(icn);
                ifs.add(ControlFlow.IfBlock.create(cond, block));
                continue;
            }
            IfElseNode ien = (IfElseNode)child;
            elseBlock = Optional.of(this.visitChildrenInNewScope(ien));
        }
        return ControlFlow.ifElseChain(ifs, elseBlock);
    }

    @Override
    protected Statement visitSwitchNode(SwitchNode node) {
        List children = node.getChildren();
        if (children.isEmpty()) {
            return Statement.NULL_STATEMENT;
        }
        if (children.size() == 1 && children.get(0) instanceof SwitchDefaultNode) {
            return this.visitChildrenInNewScope((SoyNode.BlockNode)children.get(0));
        }
        SoyExpression switchVar = this.exprCompiler.compileRootExpression(node.getExpr(), this.detachState);
        TemplateVariableManager.Scope scope = this.variables.enterScope();
        TemplateVariableManager.Variable variable = scope.createSynthetic(SyntheticVarName.forSwitch(node), switchVar, TemplateVariableManager.SaveStrategy.STORE);
        Statement initializer = variable.initializer();
        switchVar = switchVar.withSource(variable.local());
        ArrayList<ControlFlow.IfBlock> cases = new ArrayList<ControlFlow.IfBlock>();
        Optional<Statement> defaultBlock = Optional.empty();
        for (SoyNode child : children) {
            if (child instanceof SwitchCaseNode) {
                SwitchCaseNode caseNode = (SwitchCaseNode)child;
                Label reattachPoint = new Label();
                ArrayList<Expression> comparisons = new ArrayList<Expression>();
                for (ExprRootNode caseExpr : caseNode.getExprList()) {
                    comparisons.add(BytecodeUtils.compareSoyEquals(switchVar, this.exprCompiler.compileSubExpression(caseExpr, this.detachState.createExpressionDetacher(reattachPoint))));
                }
                Expression condition = BytecodeUtils.logicalOr(comparisons).labelStart(reattachPoint);
                Statement block = this.visitChildrenInNewScope(caseNode);
                cases.add(ControlFlow.IfBlock.create(condition, block));
                continue;
            }
            SwitchDefaultNode defaultNode = (SwitchDefaultNode)child;
            defaultBlock = Optional.of(this.visitChildrenInNewScope(defaultNode));
        }
        Statement exitScope = scope.exitScope();
        return Statement.concat(initializer, ControlFlow.ifElseChain(cases, defaultBlock), exitScope);
    }

    @Override
    protected Statement visitForNode(ForNode node) {
        TemplateVariableManager.Variable itemVar;
        TemplateVariableManager.Variable userIndexVar;
        TemplateVariableManager.Variable indexVar;
        TemplateVariableManager.Variable sizeVar;
        ForNonemptyNode nonEmptyNode = (ForNonemptyNode)node.getChild(0);
        Optional<RangeArgs> exprAsRangeArgs = RangeArgs.createFromNode(node);
        TemplateVariableManager.Scope scope = this.variables.enterScope();
        final ArrayList<Statement> initializers = new ArrayList<Statement>();
        if (exprAsRangeArgs.isPresent()) {
            final CompiledForeachRangeArgs compiledArgs = this.calculateRangeArgs(node, scope);
            initializers.addAll((Collection<Statement>)compiledArgs.initStatements());
            sizeVar = scope.createSynthetic(SyntheticVarName.foreachLoopLength(nonEmptyNode), MethodRef.RUNTIME_RANGE_LOOP_LENGTH.invoke(compiledArgs.start(), compiledArgs.end(), compiledArgs.step()), TemplateVariableManager.SaveStrategy.DERIVED);
            indexVar = scope.createSynthetic(SyntheticVarName.foreachLoopIndex(nonEmptyNode), BytecodeUtils.constant(0), TemplateVariableManager.SaveStrategy.STORE);
            userIndexVar = nonEmptyNode.getIndexVar() == null ? null : scope.create(nonEmptyNode.getIndexVarName(), SoyExpression.forInt(BytecodeUtils.numericConversion(indexVar.local(), Type.LONG_TYPE)).boxAsSoyValueProvider().checkedCast(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE), TemplateVariableManager.SaveStrategy.DERIVED);
            itemVar = scope.create(nonEmptyNode.getVarName(), new Expression(Type.LONG_TYPE, Expression.Feature.CHEAP, new Expression.Feature[0]){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    compiledArgs.start().gen(adapter);
                    compiledArgs.step().gen(adapter);
                    indexVar.local().gen(adapter);
                    adapter.visitInsn(104);
                    adapter.visitInsn(96);
                    adapter.cast(Type.INT_TYPE, Type.LONG_TYPE);
                }
            }, TemplateVariableManager.SaveStrategy.DERIVED);
        } else {
            SoyExpression expr = this.exprCompiler.compileRootExpression(node.getExpr(), this.detachState).unboxAsList();
            TemplateVariableManager.Variable listVar = scope.createSynthetic(SyntheticVarName.foreachLoopList(nonEmptyNode), expr, TemplateVariableManager.SaveStrategy.STORE);
            initializers.add(listVar.initializer());
            sizeVar = scope.createSynthetic(SyntheticVarName.foreachLoopLength(nonEmptyNode), MethodRef.LIST_SIZE.invoke(listVar.local()), TemplateVariableManager.SaveStrategy.DERIVED);
            indexVar = scope.createSynthetic(SyntheticVarName.foreachLoopIndex(nonEmptyNode), BytecodeUtils.constant(0), TemplateVariableManager.SaveStrategy.STORE);
            userIndexVar = nonEmptyNode.getIndexVar() == null ? null : scope.create(nonEmptyNode.getIndexVarName(), SoyExpression.forInt(BytecodeUtils.numericConversion(indexVar.local(), Type.LONG_TYPE)).boxAsSoyValueProvider().checkedCast(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE), TemplateVariableManager.SaveStrategy.DERIVED);
            itemVar = scope.create(nonEmptyNode.getVarName(), MethodRef.LIST_GET.invoke(listVar.local(), indexVar.local()).checkedCast(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE), TemplateVariableManager.SaveStrategy.DERIVED);
        }
        initializers.add(sizeVar.initializer());
        final Statement loopBody = this.visitChildrenInNewScope(nonEmptyNode);
        final Statement exitScope = scope.exitScope();
        final Statement emptyBlock = node.numChildren() == 2 ? this.visitChildrenInNewScope((SoyNode.BlockNode)node.getChild(1)) : null;
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                for (Statement initializer : initializers) {
                    initializer.gen(adapter);
                }
                sizeVar.local().gen(adapter);
                Label emptyListLabel = new Label();
                adapter.ifZCmp(153, emptyListLabel);
                indexVar.initializer().gen(adapter);
                Label loopStart = adapter.mark();
                itemVar.initializer().gen(adapter);
                if (userIndexVar != null) {
                    userIndexVar.initializer().gen(adapter);
                }
                loopBody.gen(adapter);
                adapter.iinc(indexVar.local().index(), 1);
                indexVar.local().gen(adapter);
                sizeVar.local().gen(adapter);
                adapter.ifICmp(155, loopStart);
                exitScope.gen(adapter);
                if (emptyBlock != null) {
                    Label skipIfEmptyBlock = new Label();
                    adapter.goTo(skipIfEmptyBlock);
                    adapter.mark(emptyListLabel);
                    emptyBlock.gen(adapter);
                    adapter.mark(skipIfEmptyBlock);
                } else {
                    adapter.mark(emptyListLabel);
                }
            }
        };
    }

    private CompiledForeachRangeArgs calculateRangeArgs(ForNode forNode, TemplateVariableManager.Scope scope) {
        RangeArgs rangeArgs = RangeArgs.createFromNode(forNode).get();
        ForNonemptyNode nonEmptyNode = (ForNonemptyNode)forNode.getChild(0);
        ImmutableList.Builder initStatements = ImmutableList.builder();
        Expression startExpression = this.computeRangeValue(SyntheticVarName.foreachLoopRangeStart(nonEmptyNode), rangeArgs.start(), 0, scope, (ImmutableList.Builder<Statement>)initStatements);
        Expression stepExpression = this.computeRangeValue(SyntheticVarName.foreachLoopRangeStep(nonEmptyNode), rangeArgs.increment(), 1, scope, (ImmutableList.Builder<Statement>)initStatements);
        Expression endExpression = this.computeRangeValue(SyntheticVarName.foreachLoopRangeEnd(nonEmptyNode), Optional.of(rangeArgs.limit()), Integer.MAX_VALUE, scope, (ImmutableList.Builder<Statement>)initStatements);
        return new AutoValue_SoyNodeCompiler_CompiledForeachRangeArgs(startExpression, endExpression, stepExpression, (ImmutableList<Statement>)initStatements.build());
    }

    private Expression computeRangeValue(SyntheticVarName varName, Optional<ExprNode> expression, int defaultValue, TemplateVariableManager.Scope scope, ImmutableList.Builder<Statement> initStatements) {
        if (!expression.isPresent()) {
            return BytecodeUtils.constant(defaultValue);
        }
        if (expression.get() instanceof IntegerNode && ((IntegerNode)expression.get()).isInt()) {
            int value = Ints.checkedCast((long)((IntegerNode)expression.get()).getValue());
            return BytecodeUtils.constant(value);
        }
        Label startDetachPoint = new Label();
        SoyExpression compiledExpression = this.exprCompiler.compileSubExpression(expression.get(), this.detachState.createExpressionDetacher(startDetachPoint));
        SoyRuntimeType type = compiledExpression.soyRuntimeType();
        Expression rangeValue = !type.isKnownInt() ? MethodRef.INTS_CHECKED_CAST.invoke(BytecodeUtils.numericConversion(type.isKnownFloat() ? compiledExpression.unboxAsDouble() : compiledExpression.coerceToDouble(), Type.LONG_TYPE)) : MethodRef.INTS_CHECKED_CAST.invoke(compiledExpression.unboxAsLong());
        if (!rangeValue.isCheap()) {
            TemplateVariableManager.Variable startVar = scope.createSynthetic(varName, rangeValue, TemplateVariableManager.SaveStrategy.STORE);
            initStatements.add((Object)startVar.initializer().labelStart(startDetachPoint));
            rangeValue = startVar.local();
        }
        return rangeValue;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected Statement visitPrintNode(PrintNode node) {
        block3: {
            if (node.getExpr().getRoot() instanceof FunctionNode && (fn = (FunctionNode)node.getExpr().getRoot()).getSoyFunction() instanceof LoggingFunction) {
                return this.visitLoggingFunction(node, fn, (LoggingFunction)fn.getSoyFunction());
            }
            if (!PrintDirectives.areAllPrintDirectivesStreamable(node)) break block3;
            reattachPoint = new Label();
            expr = node.getExpr();
            asSoyValueProvider = this.expressionToSoyValueProviderCompiler.compileToSoyValueProviderIfUsefulToPreserveStreaming(expr, this.detachState.createExpressionDetacher(reattachPoint));
            if (!asSoyValueProvider.isPresent()) break block3;
            if (this.exprCompiler.requiresDetach(expr)) ** GOTO lbl-1000
            if (node.getChildren().stream().flatMap((Function<PrintDirectiveNode, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$visitPrintNode$1(com.google.template.soy.soytree.PrintDirectiveNode ), (Lcom/google/template/soy/soytree/PrintDirectiveNode;)Ljava/util/stream/Stream;)()).anyMatch((Predicate<ExprRootNode>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, requiresDetach(com.google.template.soy.exprtree.ExprNode ), (Lcom/google/template/soy/exprtree/ExprRootNode;)Z)((ExpressionCompiler)this.exprCompiler))) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            requiresDetachLogic = v0;
            return this.renderIncrementally(asSoyValueProvider.get(), node.getChildren(), reattachPoint, requiresDetachLogic);
        }
        reattachPoint = new Label();
        value = this.compilePrintNodeAsExpression(node, reattachPoint);
        renderSoyValue = this.appendableExpression.appendString(value.coerceToString()).labelStart(reattachPoint);
        return renderSoyValue.toStatement();
    }

    private Statement visitLoggingFunction(PrintNode node, FunctionNode fn, LoggingFunction loggingFunction) {
        ArrayList<Expression> printDirectives = new ArrayList<Expression>(node.numChildren());
        for (PrintDirectiveNode child : node.getChildren()) {
            Preconditions.checkState((boolean)child.getArgs().isEmpty());
            printDirectives.add(this.parameterLookup.getRenderContext().getEscapingDirectiveAsFunction(child.getName()));
        }
        Label reattachPoint = new Label();
        SoyFunctionSignature functionSignature = loggingFunction.getClass().getAnnotation(SoyFunctionSignature.class);
        Preconditions.checkNotNull((Object)functionSignature, (String)"LoggingFunction %s must be annotated with @SoyFunctionSignature", (Object)loggingFunction.getClass().getName());
        return this.appendableExpression.appendLoggingFunctionInvocation(functionSignature.name(), loggingFunction.getPlaceholder(), this.exprCompiler.asBasicCompiler(this.detachState.createExpressionDetacher(reattachPoint)).compileToList(fn.getChildren()), printDirectives).labelStart(reattachPoint).toStatement();
    }

    private SoyExpression compilePrintNodeAsExpression(PrintNode node, Label reattachPoint) {
        ExpressionCompiler.BasicExpressionCompiler basic = this.exprCompiler.asBasicCompiler(this.detachState.createExpressionDetacher(reattachPoint));
        SoyExpression value = basic.compile(node.getExpr());
        for (PrintDirectiveNode printDirective : node.getChildren()) {
            value = this.parameterLookup.getRenderContext().applyPrintDirective(printDirective.getPrintDirective(), value, basic.compileToList((List<? extends ExprNode>)printDirective.getArgs()));
        }
        return value;
    }

    private Statement renderIncrementally(Expression soyValueProvider, List<PrintDirectiveNode> directives, Label reattachPoint, boolean requiresDetachLogic) {
        Statement initRenderee = Statement.NULL_STATEMENT;
        Statement clearRenderee = Statement.NULL_STATEMENT;
        if (!soyValueProvider.isCheap()) {
            FieldRef currentRendereeField = this.fields.getCurrentRenderee();
            initRenderee = currentRendereeField.putInstanceField(this.thisVar, soyValueProvider);
            clearRenderee = currentRendereeField.putInstanceField(this.thisVar, BytecodeUtils.constantNull(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE));
            soyValueProvider = currentRendereeField.accessor(this.thisVar);
        }
        initRenderee = initRenderee.labelStart(reattachPoint);
        Statement initAppendable = Statement.NULL_STATEMENT;
        Statement clearAppendable = Statement.NULL_STATEMENT;
        Expression appendable = this.appendableExpression;
        if (!directives.isEmpty()) {
            Label printDirectiveArgumentReattachPoint = new Label();
            PrintDirectives.AppendableAndFlushBuffersDepth wrappedAppendable = PrintDirectives.applyStreamingPrintDirectives(directives, appendable, this.exprCompiler.asBasicCompiler(this.detachState.createExpressionDetacher(printDirectiveArgumentReattachPoint)), this.parameterLookup.getPluginContext());
            FieldRef currentAppendableField = this.fields.getCurrentAppendable();
            initAppendable = currentAppendableField.putInstanceField(this.thisVar, wrappedAppendable.appendable()).labelStart(printDirectiveArgumentReattachPoint);
            appendable = currentAppendableField.accessor(this.thisVar).asNonNullable();
            clearAppendable = currentAppendableField.putInstanceField(this.thisVar, BytecodeUtils.constantNull(BytecodeUtils.LOGGING_ADVISING_APPENDABLE_TYPE));
            if (wrappedAppendable.flushBuffersDepth() >= 0) {
                clearAppendable = Statement.concat(AppendableExpression.forExpression(appendable).flushBuffers(wrappedAppendable.flushBuffersDepth()), clearAppendable);
            }
        }
        Expression callRenderAndResolve = soyValueProvider.invoke(MethodRef.SOY_VALUE_PROVIDER_RENDER_AND_RESOLVE, appendable, BytecodeUtils.constant(false));
        Statement doCall = requiresDetachLogic ? this.detachState.detachForRender(callRenderAndResolve) : this.detachState.assertFullyRenderered(callRenderAndResolve);
        return Statement.concat(initRenderee, initAppendable, doCall, clearAppendable, clearRenderee);
    }

    @Override
    protected Statement visitRawTextNode(RawTextNode node) {
        AppendableExpression render = node.getRawText().length() == 1 ? this.appendableExpression.appendChar(BytecodeUtils.constant(node.getRawText().charAt(0))) : this.appendableExpression.appendString(BytecodeUtils.constant(node.getRawText()));
        return render.toStatement();
    }

    @Override
    protected Statement visitDebuggerNode(DebuggerNode node) {
        return MethodRef.RUNTIME_DEBUGGER.invokeVoid(BytecodeUtils.constant(node.getSourceLocation().getFilePath().path()), BytecodeUtils.constant(node.getSourceLocation().getBeginLine()));
    }

    @Override
    protected Statement visitKeyNode(KeyNode node) {
        return Statement.NULL_STATEMENT;
    }

    @Override
    protected Statement visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        MsgNode msg = node.getMsg();
        MsgUtils.MsgPartsAndIds idAndParts = MsgUtils.buildMsgPartsAndComputeMsgIdForDualFormat(msg);
        ImmutableList<SoyPrintDirective> escapingDirectives = node.getEscapingDirectives();
        Statement renderDefault = this.getMsgCompiler().compileMessage(idAndParts, msg, escapingDirectives);
        if (node.hasFallbackMsg()) {
            MsgNode fallback = node.getFallbackMsg();
            MsgUtils.MsgPartsAndIds fallbackIdAndParts = MsgUtils.buildMsgPartsAndComputeMsgIdForDualFormat(fallback);
            Expression cond = msg.getAlternateId().isPresent() ? (fallback.getAlternateId().isPresent() ? this.parameterLookup.getRenderContext().usePrimaryOrAlternateIfFallbackOrFallbackAlternate(idAndParts.id, msg.getAlternateId().getAsLong(), fallbackIdAndParts.id, fallback.getAlternateId().getAsLong()) : this.parameterLookup.getRenderContext().usePrimaryOrAlternateIfFallback(idAndParts.id, msg.getAlternateId().getAsLong(), fallbackIdAndParts.id)) : (fallback.getAlternateId().isPresent() ? this.parameterLookup.getRenderContext().usePrimaryIfFallbackOrFallbackAlternate(idAndParts.id, fallbackIdAndParts.id, fallback.getAlternateId().getAsLong()) : this.parameterLookup.getRenderContext().usePrimaryMsgIfFallback(idAndParts.id, fallbackIdAndParts.id));
            ControlFlow.IfBlock ifAvailableRenderDefault = ControlFlow.IfBlock.create(cond, renderDefault);
            return ControlFlow.ifElseChain((List<ControlFlow.IfBlock>)ImmutableList.of((Object)ifAvailableRenderDefault), Optional.of(this.getMsgCompiler().compileMessage(fallbackIdAndParts, fallback, escapingDirectives)));
        }
        return renderDefault;
    }

    @Override
    protected Statement visitCallDelegateNode(CallDelegateNode node) {
        Label reattachPoint = new Label();
        Expression variantExpr = node.getDelCalleeVariantExpr() == null ? BytecodeUtils.constant("") : this.exprCompiler.compileSubExpression(node.getDelCalleeVariantExpr(), this.detachState.createExpressionDetacher(reattachPoint)).coerceToString();
        Expression calleeExpression = this.parameterLookup.getRenderContext().getDeltemplate(node.getDelCalleeName(), variantExpr, node.allowEmptyDefault(), this.prepareParamsHelper(node, reattachPoint), this.parameterLookup.getIjRecord());
        return this.renderCallNode(reattachPoint, node, calleeExpression);
    }

    @Override
    protected Statement visitCallBasicNode(final CallBasicNode node) {
        Expression calleeExpression;
        Label reattachPoint = new Label();
        final Expression params = this.prepareParamsHelper(node, reattachPoint);
        final Expression ijRecord = this.parameterLookup.getIjRecord();
        if (node.isStaticCall()) {
            final RenderContextExpression renderContext = this.parameterLookup.getRenderContext();
            calleeExpression = new Expression(BytecodeUtils.COMPILED_TEMPLATE_TYPE){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    renderContext.gen(adapter);
                    params.gen(adapter);
                    ijRecord.gen(adapter);
                    adapter.visitInvokeDynamicInsn("create", TEMPLATE_CONSTRUCTION_SIGNATURE, CONSTRUCTION_HANDLE, new Object[]{node.getCalleeName()});
                }
            };
        } else {
            calleeExpression = this.exprCompiler.compileSubExpression(node.getCalleeExpr(), this.detachState.createExpressionDetacher(reattachPoint)).checkedCast(BytecodeUtils.COMPILED_TEMPLATE_FACTORY_VALUE_TYPE).invoke(MethodRef.COMPILED_TEMPLATE_FACTORY_VALUE_CREATE_TEMPLATE, params, ijRecord);
        }
        return this.renderCallNode(reattachPoint, node, calleeExpression);
    }

    @Override
    protected Statement visitVeLogNode(VeLogNode node) {
        final Label restartPoint = new Label();
        final SoyExpression veData = this.exprCompiler.compileSubExpression(node.getVeDataExpression(), this.detachState.createExpressionDetacher(restartPoint));
        final Expression hasLogger = this.parameterLookup.getRenderContext().hasLogger();
        final Statement exitStatement = ControlFlow.IfBlock.create(hasLogger, this.appendableExpression.exitLoggableElement().toStatement()).asStatement();
        if (node.getLogonlyExpression() != null) {
            final SoyExpression logonlyExpression = this.exprCompiler.compileSubExpression(node.getLogonlyExpression(), this.detachState.createExpressionDetacher(restartPoint)).unboxAsBoolean();
            final Statement body = Statement.concat(this.visitChildrenInNewScope(node));
            return new Statement(){

                @Override
                protected void doGen(CodeBuilder cb) {
                    cb.mark(restartPoint);
                    logonlyExpression.gen(cb);
                    Label noLogger = new Label();
                    hasLogger.gen(cb);
                    cb.ifZCmp(153, noLogger);
                    veData.gen(cb);
                    MethodRef.CREATE_LOG_STATEMENT.invokeUnchecked(cb);
                    SoyNodeCompiler.this.appendableExpression.gen(cb);
                    cb.swap();
                    AppendableExpression.ENTER_LOGGABLE_STATEMENT.invokeUnchecked(cb);
                    cb.pop();
                    Label bodyLabel = new Label();
                    cb.goTo(bodyLabel);
                    cb.mark(noLogger);
                    cb.ifZCmp(153, bodyLabel);
                    cb.throwException(BytecodeUtils.ILLEGAL_STATE_EXCEPTION_TYPE, "Cannot set logonly=\"true\" unless there is a logger configured");
                    cb.mark(bodyLabel);
                    body.gen(cb);
                    exitStatement.gen(cb);
                }
            };
        }
        Statement enterStatement = ControlFlow.IfBlock.create(hasLogger, this.appendableExpression.enterLoggableElement(MethodRef.CREATE_LOG_STATEMENT.invoke(BytecodeUtils.constant(false), veData)).toStatement().labelStart(restartPoint)).asStatement();
        return Statement.concat(enterStatement, Statement.concat(this.visitChildrenInNewScope(node)), exitStatement);
    }

    private Statement renderCallNode(Label parametersReattachPoint, CallNode node, Expression calleeExpression) {
        Statement initAppendable = Statement.NULL_STATEMENT;
        Statement clearAppendable = Statement.NULL_STATEMENT;
        Expression appendable = this.appendableExpression;
        FieldRef currentCalleeField = this.fields.getCurrentCalleeField();
        if (!PrintDirectives.areAllPrintDirectivesStreamable(node)) {
            calleeExpression = MethodRef.RUNTIME_APPLY_ESCAPERS.invoke(calleeExpression, this.getEscapingDirectivesList(node));
        } else if (!node.getEscapingDirectives().isEmpty()) {
            PrintDirectives.AppendableAndFlushBuffersDepth wrappedAppendable = PrintDirectives.applyStreamingEscapingDirectives(node.getEscapingDirectives(), appendable, this.parameterLookup.getPluginContext());
            FieldRef currentAppendableField = this.fields.getCurrentAppendable();
            initAppendable = currentAppendableField.putInstanceField(this.thisVar, wrappedAppendable.appendable());
            appendable = currentAppendableField.accessor(this.thisVar).asNonNullable();
            clearAppendable = currentAppendableField.putInstanceField(this.thisVar, BytecodeUtils.constantNull(BytecodeUtils.LOGGING_ADVISING_APPENDABLE_TYPE));
            if (wrappedAppendable.flushBuffersDepth() >= 0) {
                clearAppendable = Statement.concat(AppendableExpression.forExpression(appendable).flushBuffers(wrappedAppendable.flushBuffersDepth()), clearAppendable);
            }
        }
        Statement initCallee = currentCalleeField.putInstanceField(this.thisVar, calleeExpression).labelStart(parametersReattachPoint);
        Expression callRender = currentCalleeField.accessor(this.thisVar).invoke(MethodRef.COMPILED_TEMPLATE_RENDER, appendable, this.parameterLookup.getRenderContext()).withSourceLocation(node.getSourceLocation());
        Statement callCallee = this.detachState.detachForRender(callRender);
        Statement clearCallee = currentCalleeField.putInstanceField(this.thisVar, BytecodeUtils.constantNull(BytecodeUtils.COMPILED_TEMPLATE_TYPE));
        return Statement.concat(initCallee, initAppendable, callCallee, clearAppendable, clearCallee);
    }

    private Expression getEscapingDirectivesList(CallNode node) {
        ImmutableList<SoyPrintDirective> escapingDirectives = node.getEscapingDirectives();
        ArrayList<Expression> directiveExprs = new ArrayList<Expression>(escapingDirectives.size());
        for (SoyPrintDirective directive : escapingDirectives) {
            directiveExprs.add(this.parameterLookup.getRenderContext().getPrintDirective(directive.getName()));
        }
        return BytecodeUtils.asImmutableList(directiveExprs);
    }

    private Expression prepareParamsHelper(CallNode node, Label reattachPoint) {
        if (node.numChildren() == 0) {
            if (!node.isPassingData()) {
                return FieldRef.EMPTY_PARAMS.accessor();
            }
            if (!node.isPassingAllData()) {
                return this.getDataRecordExpression(node, reattachPoint);
            }
            Expression paramsRecord = this.parameterLookup.getParamsRecord();
            return this.maybeAddDefaultParams(node, ConstructorRef.AUGMENTED_PARAM_STORE.construct(paramsRecord, BytecodeUtils.constant(node.numChildren()))).orElse(paramsRecord);
        }
        Expression paramStoreExpression = this.getParamStoreExpression(node, reattachPoint);
        for (CallParamNode child : node.getChildren()) {
            String paramKey = child.getKey().identifier();
            Expression valueExpr = child instanceof CallParamContentNode ? new LazyClosureCompiler(this).compileLazyContent("param", (CallParamContentNode)child, paramKey).soyValueProvider() : new LazyClosureCompiler(this).compileLazyExpression("param", child, paramKey, ((CallParamValueNode)child).getExpr()).soyValueProvider();
            paramStoreExpression = MethodRef.PARAM_STORE_SET_FIELD.invoke(paramStoreExpression, BytecodeUtils.constant(paramKey), valueExpr);
        }
        return paramStoreExpression;
    }

    private Expression getParamStoreExpression(CallNode node, Label reattachPoint) {
        if (!node.isPassingData()) {
            return ConstructorRef.BASIC_PARAM_STORE.construct(BytecodeUtils.constant(node.numChildren()));
        }
        Expression dataExpression = node.isPassingAllData() ? this.parameterLookup.getParamsRecord() : this.getDataRecordExpression(node, reattachPoint);
        Expression paramStoreExpression = ConstructorRef.AUGMENTED_PARAM_STORE.construct(dataExpression, BytecodeUtils.constant(node.numChildren()));
        if (node.isPassingAllData()) {
            paramStoreExpression = this.maybeAddDefaultParams(node, paramStoreExpression).orElse(paramStoreExpression);
        }
        return paramStoreExpression;
    }

    private Optional<Expression> maybeAddDefaultParams(CallNode node, Expression paramStoreExpression) {
        boolean foundDefaultParams = false;
        for (TemplateParam param : node.getNearestAncestor(TemplateNode.class).getParams()) {
            if (!param.hasDefault()) continue;
            foundDefaultParams = true;
            paramStoreExpression = MethodRef.PARAM_STORE_SET_FIELD.invoke(paramStoreExpression, BytecodeUtils.constant(param.name()), this.parameterLookup.getParam(param));
        }
        return foundDefaultParams ? Optional.of(paramStoreExpression) : Optional.empty();
    }

    private Expression getDataRecordExpression(CallNode node, Label reattachPoint) {
        return this.exprCompiler.compileSubExpression(node.getDataExpr(), this.detachState.createExpressionDetacher(reattachPoint)).box().checkedCast(SoyRecord.class);
    }

    @Override
    protected Statement visitLogNode(LogNode node) {
        return this.compilerWithNewAppendable(AppendableExpression.logger()).visitChildrenInNewScope(node);
    }

    @Override
    protected Statement visitLetValueNode(LetValueNode node) {
        return this.storeClosure(new LazyClosureCompiler(this).compileLazyExpression("let", node, node.getVarName(), node.getExpr()));
    }

    @Override
    protected Statement visitLetContentNode(LetContentNode node) {
        return this.storeClosure(new LazyClosureCompiler(this).compileLazyContent("let", node, node.getVarName()));
    }

    Statement storeClosure(LazyClosureCompiler.LazyClosure newLetValue) {
        if (newLetValue.isTrivial()) {
            this.currentScope.createTrivial(newLetValue.name(), newLetValue.soyValueProvider());
            return Statement.NULL_STATEMENT;
        }
        return this.currentScope.create(newLetValue.name(), newLetValue.soyValueProvider(), TemplateVariableManager.SaveStrategy.STORE).initializer();
    }

    @Override
    protected Statement visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        return Statement.concat(this.visitChildren(node));
    }

    @Override
    protected Statement visitSoyNode(SoyNode node) {
        throw new UnsupportedOperationException("The jbcsrc backend doesn't support: " + (Object)((Object)node.getKind()) + " nodes yet.");
    }

    private MsgCompiler getMsgCompiler() {
        return new MsgCompiler(this.thisVar, this.detachState, this.parameterLookup, this.fields, this.appendableExpression, new MsgCompiler.PlaceholderCompiler(){

            @Override
            public MsgCompiler.PlaceholderCompiler.Placeholder compile(ExprRootNode node, ExpressionDetacher expressionDetatcher) {
                return MsgCompiler.PlaceholderCompiler.Placeholder.create(SoyNodeCompiler.this.expressionToSoyValueProviderCompiler.compile(node, expressionDetatcher), SoyNodeCompiler.this.exprCompiler.requiresDetach(node));
            }

            @Override
            public MsgCompiler.PlaceholderCompiler.Placeholder compile(String phname, SoyNode.StandaloneNode node, ExtraCodeCompiler prefix, ExtraCodeCompiler suffix) {
                LetContentNode fakeLet = LetContentNode.forVariable(-1, node.getSourceLocation(), "$" + phname, node.getSourceLocation(), SanitizedContentKind.TEXT);
                MsgPlaceholderNode placeholderParent = (MsgPlaceholderNode)node.getParent();
                Preconditions.checkState((placeholderParent.numChildren() == 1 ? 1 : 0) != 0);
                fakeLet.addChild(node);
                placeholderParent.addChild(fakeLet);
                LazyClosureCompiler.LazyClosure closure = new LazyClosureCompiler(SoyNodeCompiler.this).compileLazyContent("ph", fakeLet, phname, prefix, suffix);
                placeholderParent.removeChild(fakeLet);
                placeholderParent.addChild(node);
                return MsgCompiler.PlaceholderCompiler.Placeholder.create(closure.soyValueProvider(), closure.requiresDetachLogicToResolve());
            }
        });
    }

    SoyNodeCompiler compilerWithNewAppendable(AppendableExpression appendable) {
        return new SoyNodeCompiler(this.analysis, this.thisVar, this.innerClasses, this.detachState, this.variables, this.parameterLookup, this.fields, appendable, this.exprCompiler, this.expressionToSoyValueProviderCompiler, this.constantCompiler, this.javaSourceFunctionCompiler);
    }

    private static /* synthetic */ Stream lambda$visitPrintNode$1(PrintDirectiveNode pdn) {
        return pdn.getExprList().stream();
    }

    @AutoValue
    static abstract class CompiledForeachRangeArgs {
        CompiledForeachRangeArgs() {
        }

        abstract Expression start();

        abstract Expression end();

        abstract Expression step();

        abstract ImmutableList<Statement> initStatements();
    }

    @AutoValue
    static abstract class CompiledMethodBody {
        CompiledMethodBody() {
        }

        static CompiledMethodBody create(Statement body, int numDetaches) {
            return new AutoValue_SoyNodeCompiler_CompiledMethodBody(body, numDetaches);
        }

        abstract Statement body();

        abstract int numberOfDetachStates();
    }
}

