/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.internal.Converters;
import com.google.template.soy.exprtree.AbstractLocalVarDefn;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.exprtree.VeLiteralNode;
import com.google.template.soy.jbcsrc.AbstractTemplateParameterLookup;
import com.google.template.soy.jbcsrc.AppendableExpression;
import com.google.template.soy.jbcsrc.AutoAnnotation_TemplateCompiler_createDefaultDelTemplateMetadata;
import com.google.template.soy.jbcsrc.AutoAnnotation_TemplateCompiler_createDelTemplateMetadata;
import com.google.template.soy.jbcsrc.AutoAnnotation_TemplateCompiler_createTemplateMetadata;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.jbcsrc.ExpressionCompiler;
import com.google.template.soy.jbcsrc.ExtraCodeCompiler;
import com.google.template.soy.jbcsrc.FieldManager;
import com.google.template.soy.jbcsrc.JavaSourceFunctionCompiler;
import com.google.template.soy.jbcsrc.RenderContextExpression;
import com.google.template.soy.jbcsrc.SimpleLocalVariableManager;
import com.google.template.soy.jbcsrc.SoyNodeCompiler;
import com.google.template.soy.jbcsrc.SyntheticVarName;
import com.google.template.soy.jbcsrc.TemplateAnalysis;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.internal.ClassData;
import com.google.template.soy.jbcsrc.internal.InnerClasses;
import com.google.template.soy.jbcsrc.internal.SoyClassWriter;
import com.google.template.soy.jbcsrc.restricted.AnnotationRef;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.LocalVariable;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyRuntimeType;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.TemplateMetadata;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class TemplateCompiler {
    private static final AnnotationRef<TemplateMetadata> TEMPLATE_METADATA_REF = AnnotationRef.forType(TemplateMetadata.class);
    private static final TypeInfo TEMPLATE_TYPE = TypeInfo.create(CompiledTemplate.class);
    private FieldRef paramsField;
    private FieldRef ijField;
    private final FieldManager fields;
    private final ImmutableMap<String, FieldRef> paramFields;
    private final CompiledTemplateMetadata template;
    private final TemplateNode templateNode;
    private final InnerClasses innerClasses;
    private SoyClassWriter writer;
    private TemplateAnalysis analysis;
    private final JavaSourceFunctionCompiler javaSourceFunctionCompiler;
    private static final Handle METAFACTORY_HANDLE = MethodRef.create(LambdaMetafactory.class, "metafactory", MethodHandles.Lookup.class, String.class, MethodType.class, MethodType.class, MethodHandle.class, MethodType.class).asHandle();
    private static final String COMPILED_TEMPLATE_FACTORY_INIT_DESCRIPTOR = Type.getMethodDescriptor((Type)BytecodeUtils.COMPILED_TEMPLATE_FACTORY_TYPE, (Type[])new Type[0]);
    private static final Type COMPILED_TEMPLATE_FACTORY_CREATE_DESCRIPTOR = Type.getMethodType((Type)Type.getType(CompiledTemplate.class), (Type[])new Type[]{Type.getType(SoyRecord.class), Type.getType(SoyRecord.class)});

    TemplateCompiler(CompiledTemplateMetadata template, TemplateNode templateNode, JavaSourceFunctionCompiler javaSourceFunctionCompiler) {
        this.template = template;
        this.templateNode = templateNode;
        this.innerClasses = new InnerClasses(template.typeInfo());
        this.fields = new FieldManager(template.typeInfo());
        this.javaSourceFunctionCompiler = javaSourceFunctionCompiler;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TemplateParam param : templateNode.getAllParams()) {
            String name = param.name();
            builder.put((Object)name, (Object)(TemplateCompiler.shouldResolveParamValueInConstructor(param) ? this.fields.addFinalField(name, BytecodeUtils.SOY_VALUE_PROVIDER_TYPE).asNonNull() : this.fields.addField(name, BytecodeUtils.SOY_VALUE_PROVIDER_TYPE).asNonNull()));
        }
        this.paramFields = builder.build();
    }

    private static boolean shouldResolveParamValueInConstructor(TemplateParam param) {
        return !param.hasDefault() || !SoyTypes.transitivelyContainsKind(param.type(), SoyType.Kind.TEMPLATE) && !TemplateCompiler.hasVeMetadataDefault(param);
    }

    private static boolean hasVeMetadataDefault(TemplateParam param) {
        return param.hasDefault() && SoyTreeUtils.allNodesOfType(param.defaultValue(), VeLiteralNode.class).anyMatch(ve -> ve.getLoggableElement().hasMetadata());
    }

    Iterable<ClassData> compile() {
        this.analysis = TemplateAnalysis.analyze(this.templateNode);
        ArrayList<ClassData> classes = new ArrayList<ClassData>();
        this.writer = SoyClassWriter.builder(this.template.typeInfo()).setAccess(49).implementing(TEMPLATE_TYPE).sourceFileName(this.templateNode.getSourceLocation().getFileName()).build();
        ExpressionCompiler.BasicExpressionCompiler constantCompiler = ExpressionCompiler.createConstantCompiler(this.analysis, new SimpleLocalVariableManager(BytecodeUtils.CLASS_INIT, true), this.javaSourceFunctionCompiler);
        this.generateTemplateMetadata();
        this.generateRenderMethod(constantCompiler);
        this.generateConstructor(constantCompiler);
        this.innerClasses.registerAllInnerClasses(this.writer);
        this.fields.defineFields(this.writer);
        this.fields.defineStaticInitializer(this.writer);
        this.generateFactoryMethod();
        this.writer.visitEnd();
        classes.add(this.writer.toClassData());
        classes.addAll((Collection<ClassData>)this.innerClasses.getInnerClassData());
        this.writer = null;
        return classes;
    }

    private void generateFactoryMethod() {
        final Handle ctorHandle = this.template.constructor().toHandle();
        Statement.returnExpression(new Expression(this.template.factoryMethod().returnType()){

            @Override
            protected void doGen(CodeBuilder cb) {
                cb.visitInvokeDynamicInsn("create", COMPILED_TEMPLATE_FACTORY_INIT_DESCRIPTOR, METAFACTORY_HANDLE, new Object[]{COMPILED_TEMPLATE_FACTORY_CREATE_DESCRIPTOR, ctorHandle, COMPILED_TEMPLATE_FACTORY_CREATE_DESCRIPTOR});
            }
        }).writeMethod((this.templateNode.getVisibility() == Visibility.PUBLIC ? 1 : 0) | 8, this.template.factoryMethod().method(), this.writer);
    }

    private void generateTemplateMetadata() {
        TemplateMetadata.DelTemplateMetadata deltemplateMetadata;
        SanitizedContent.ContentKind kind = Converters.contentKindfromSanitizedContentKind(this.templateNode.getContentKind());
        Set uniqueIjs = (Set)SoyTreeUtils.allNodesOfType(this.templateNode, VarRefNode.class).filter(VarRefNode::isInjected).map(VarRefNode::getNameWithoutLeadingDollar).collect(ImmutableSet.toImmutableSet());
        Set callees = (Set)SoyTreeUtils.allNodesOfType(this.templateNode, TemplateLiteralNode.class).map(TemplateLiteralNode::getResolvedName).collect(ImmutableSet.toImmutableSet());
        Set delCallees = (Set)SoyTreeUtils.allNodesOfType(this.templateNode, CallDelegateNode.class).map(CallDelegateNode::getDelCalleeName).collect(ImmutableSet.toImmutableSet());
        if (this.templateNode.getKind() == SoyNode.Kind.TEMPLATE_DELEGATE_NODE) {
            TemplateDelegateNode delegateNode = (TemplateDelegateNode)this.templateNode;
            deltemplateMetadata = TemplateCompiler.createDelTemplateMetadata(Strings.nullToEmpty((String)delegateNode.getDelPackageName()), delegateNode.getDelTemplateName(), delegateNode.getDelTemplateVariant());
        } else {
            deltemplateMetadata = TemplateCompiler.createDefaultDelTemplateMetadata();
        }
        LinkedHashSet namespaces = Sets.newLinkedHashSet();
        namespaces.addAll(this.templateNode.getParent().getRequiredCssNamespaces());
        namespaces.addAll(this.templateNode.getRequiredCssNamespaces());
        TemplateMetadata metadata = TemplateCompiler.createTemplateMetadata(kind, namespaces, uniqueIjs, callees, delCallees, deltemplateMetadata);
        TEMPLATE_METADATA_REF.write(metadata, this.writer);
    }

    static TemplateMetadata createTemplateMetadata(SanitizedContent.ContentKind contentKind, Set<String> requiredCssNames, Set<String> injectedParams, Set<String> callees, Set<String> delCallees, TemplateMetadata.DelTemplateMetadata deltemplateMetadata) {
        return new AutoAnnotation_TemplateCompiler_createTemplateMetadata(contentKind, requiredCssNames, injectedParams, callees, delCallees, deltemplateMetadata);
    }

    static TemplateMetadata.DelTemplateMetadata createDefaultDelTemplateMetadata() {
        return new AutoAnnotation_TemplateCompiler_createDefaultDelTemplateMetadata();
    }

    static TemplateMetadata.DelTemplateMetadata createDelTemplateMetadata(String delPackage, String name, String variant) {
        return new AutoAnnotation_TemplateCompiler_createDelTemplateMetadata(delPackage, name, variant);
    }

    private void generateRenderMethod(ExpressionCompiler.BasicExpressionCompiler constantCompiler) {
        final Label start = new Label();
        final Label end = new Label();
        final LocalVariable thisVar = LocalVariable.createThisVar(this.template.typeInfo(), start, end);
        final LocalVariable appendableVar = LocalVariable.createLocal("appendable", 1, BytecodeUtils.LOGGING_ADVISING_APPENDABLE_TYPE, start, end).asNonNullable();
        final LocalVariable contextVar = LocalVariable.createLocal("context", 2, BytecodeUtils.RENDER_CONTEXT_TYPE, start, end).asNonNullable();
        final TemplateVariableManager variableSet = new TemplateVariableManager(this.fields, thisVar, this.template.renderMethod().method());
        TemplateVariables variables = new TemplateVariables(variableSet, thisVar, new RenderContextExpression(contextVar));
        ExtraCodeCompiler resolveDefaultValuesForTemplateParams = (expressionCompiler, appendable, detachState) -> {
            ArrayList<Statement> statements = new ArrayList<Statement>();
            for (TemplateParam param : this.templateNode.getAllParams()) {
                if (TemplateCompiler.shouldResolveParamValueInConstructor(param)) continue;
                Optional<SoyExpression> defaultExpression = expressionCompiler.compileWithNoDetaches(param.defaultValue());
                Preconditions.checkState((boolean)defaultExpression.isPresent(), (Object)"Default expression unexpectedly required detachment");
                Expression paramProvider = TemplateCompiler.getParam(variables.getParamsRecordField().accessor(thisVar), variables.getIjRecordField().accessor(thisVar), param, defaultExpression.get());
                statements.add(((FieldRef)this.paramFields.get((Object)param.name())).putInstanceField(thisVar, paramProvider));
            }
            return Statement.concat(statements);
        };
        final SoyNodeCompiler.CompiledMethodBody methodBody = SoyNodeCompiler.create(this.analysis, this.innerClasses, thisVar, AppendableExpression.forExpression(appendableVar), variableSet, variables, this.fields, constantCompiler, this.javaSourceFunctionCompiler).compile(this.templateNode, resolveDefaultValuesForTemplateParams, ExtraCodeCompiler.NO_OP);
        final Statement returnDone = Statement.returnExpression(MethodRef.RENDER_RESULT_DONE.invoke(new Expression[0]));
        new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                adapter.mark(start);
                methodBody.body().gen(adapter);
                adapter.mark(end);
                returnDone.gen(adapter);
                thisVar.tableEntry(adapter);
                appendableVar.tableEntry(adapter);
                contextVar.tableEntry(adapter);
                variableSet.generateTableEntries(adapter);
            }
        }.writeIOExceptionMethod(1, this.template.renderMethod().method(), this.writer);
        this.writer.setNumDetachStates(methodBody.numberOfDetachStates());
    }

    private SoyExpression getDefaultValueVarRef(TemplateHeaderVarDefn headerVar, ExpressionCompiler.BasicExpressionCompiler constantCompiler) {
        SoyExpression varRef = headerVar.defaultValue().getType() == NullType.getInstance() ? SoyExpression.forSoyValue(headerVar.type(), BytecodeUtils.constantNull(SoyRuntimeType.getBoxedType(headerVar.type()).runtimeType())) : constantCompiler.compile(headerVar.defaultValue());
        if (!varRef.isCheap()) {
            FieldRef ref = headerVar.kind() == VarDefn.Kind.STATE ? this.fields.addPackagePrivateStaticField(headerVar.name(), varRef) : this.fields.addStaticField("default$" + headerVar.name(), varRef);
            varRef = varRef.withSource(ref.accessor());
        }
        return varRef;
    }

    private void generateConstructor(ExpressionCompiler.BasicExpressionCompiler constantCompiler) {
        final Label start = new Label();
        final Label end = new Label();
        final LocalVariable thisVar = LocalVariable.createThisVar(this.template.typeInfo(), start, end);
        final LocalVariable paramsVar = LocalVariable.createLocal("params", 1, BytecodeUtils.SOY_RECORD_TYPE, start, end);
        final LocalVariable ijVar = LocalVariable.createLocal("ij", 2, BytecodeUtils.SOY_RECORD_TYPE, start, end);
        final ArrayList<Statement> assignments = new ArrayList<Statement>();
        if (this.paramsField != null) {
            assignments.add(this.paramsField.putInstanceField(thisVar, paramsVar));
        }
        if (this.ijField != null) {
            assignments.add(this.ijField.putInstanceField(thisVar, ijVar));
        }
        for (TemplateParam param : this.templateNode.getAllParams()) {
            if (!TemplateCompiler.shouldResolveParamValueInConstructor(param)) continue;
            Expression paramProvider = TemplateCompiler.getParam(paramsVar, ijVar, param, param.hasDefault() ? this.getDefaultValueVarRef(param, constantCompiler) : null);
            assignments.add(((FieldRef)this.paramFields.get((Object)param.name())).putInstanceField(thisVar, paramProvider));
        }
        Statement constructorBody = new Statement(){

            @Override
            protected void doGen(CodeBuilder ga) {
                ga.mark(start);
                thisVar.gen(ga);
                ga.invokeConstructor(BytecodeUtils.OBJECT.type(), BytecodeUtils.NULLARY_INIT);
                for (Statement assignment : assignments) {
                    assignment.gen(ga);
                }
                ga.visitInsn(177);
                ga.visitLabel(end);
                thisVar.tableEntry(ga);
                paramsVar.tableEntry(ga);
                ijVar.tableEntry(ga);
            }
        };
        constructorBody.writeMethod(1, this.template.constructor().method(), this.writer);
    }

    private static Expression getParam(Expression paramsVar, Expression ijVar, TemplateParam param, @Nullable SoyExpression defaultValue) {
        Expression record;
        Expression fieldName = BytecodeUtils.constant(param.name());
        Expression expression = record = param.isInjected() ? ijVar : paramsVar;
        if (defaultValue == null) {
            return MethodRef.RUNTIME_GET_FIELD_PROVIDER.invoke(record, fieldName);
        }
        return MethodRef.RUNTIME_GET_FIELD_PROVIDER_DEFAULT.invoke(record, fieldName, defaultValue.box());
    }

    private final class TemplateVariables
    extends AbstractTemplateParameterLookup {
        private final TemplateVariableManager variableSet;
        private final Expression thisRef;
        private final RenderContextExpression renderContext;

        TemplateVariables(TemplateVariableManager variableSet, Expression thisRef, RenderContextExpression renderContext) {
            this.variableSet = variableSet;
            this.thisRef = thisRef;
            this.renderContext = renderContext;
        }

        @Override
        FieldRef getParamField(TemplateParam param) {
            return (FieldRef)TemplateCompiler.this.paramFields.get((Object)param.name());
        }

        @Override
        FieldRef getParamsRecordField() {
            if (TemplateCompiler.this.paramsField == null) {
                TemplateCompiler.this.paramsField = TemplateCompiler.this.fields.addFinalField("$params", BytecodeUtils.SOY_RECORD_TYPE).asNonNull();
            }
            return TemplateCompiler.this.paramsField;
        }

        @Override
        FieldRef getIjRecordField() {
            if (TemplateCompiler.this.ijField == null) {
                TemplateCompiler.this.ijField = TemplateCompiler.this.fields.addFinalField("$ij", BytecodeUtils.SOY_RECORD_TYPE).asNonNull();
            }
            return TemplateCompiler.this.ijField;
        }

        @Override
        public Expression getLocal(AbstractLocalVarDefn<?> local) {
            return this.variableSet.getVariable(local.name());
        }

        @Override
        public Expression getLocal(SyntheticVarName varName) {
            return this.variableSet.getVariable(varName);
        }

        @Override
        public RenderContextExpression getRenderContext() {
            return this.renderContext;
        }

        @Override
        Expression getCompiledTemplate() {
            return this.thisRef;
        }
    }
}

