/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.api;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.data.AbstractLoggingAdvisingAppendable;
import com.google.template.soy.data.LogStatement;
import com.google.template.soy.data.LoggingFunctionInvocation;
import com.google.template.soy.jbcsrc.api.AdvisingAppendable;
import com.google.template.soy.jbcsrc.api.AppendableAsAdvisingAppendable;
import com.google.template.soy.logging.SoyLogger;
import java.io.IOException;

public final class OutputAppendable
extends AbstractLoggingAdvisingAppendable {
    private final SoyLogger logger;
    private final AdvisingAppendable outputAppendable;

    public static OutputAppendable create(AdvisingAppendable outputAppendable, SoyLogger logger) {
        return new OutputAppendable(outputAppendable, logger);
    }

    public static OutputAppendable create(StringBuilder sb, SoyLogger logger) {
        return new OutputAppendable(AppendableAsAdvisingAppendable.asAdvisingAppendable(sb), logger);
    }

    private OutputAppendable(AdvisingAppendable outputAppendable, SoyLogger logger) {
        this.outputAppendable = (AdvisingAppendable)Preconditions.checkNotNull((Object)outputAppendable);
        this.logger = (SoyLogger)Preconditions.checkNotNull((Object)logger);
    }

    @Override
    public boolean softLimitReached() {
        return this.outputAppendable.softLimitReached();
    }

    @Override
    protected void doAppend(CharSequence csq) throws IOException {
        this.outputAppendable.append(csq);
    }

    @Override
    protected void doAppend(CharSequence csq, int start, int end) throws IOException {
        this.outputAppendable.append(csq, start, end);
    }

    @Override
    protected void doAppend(char c) throws IOException {
        this.outputAppendable.append(c);
    }

    @Override
    protected void doAppendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) throws IOException {
        String value = this.logger.evalLoggingFunction(funCall);
        for (Function directive : escapers) {
            value = (String)directive.apply((Object)value);
        }
        this.outputAppendable.append(value);
    }

    @Override
    protected void doEnterLoggableElement(LogStatement statement) {
        this.logger.enter(statement);
    }

    @Override
    protected void doExitLoggableElement() {
        this.logger.exit();
    }

    @Override
    public void flushBuffers(int depth) {
        throw new AssertionError((Object)"shouldn't be called");
    }
}

