/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.api;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.template.soy.jbcsrc.api.AutoValue_PluginRuntimeInstanceInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;

@AutoValue
public abstract class PluginRuntimeInstanceInfo {
    private static final char FIELD_DELIMITER = '|';
    private static final Splitter FIELD_SPLITTER = Splitter.on((char)'|');
    private static final char SOURCE_LOCATION_DELIMITER = ',';
    private static final Joiner SOURCE_LOCATION_JOINER = Joiner.on((char)',');
    private static final Splitter SOURCE_LOCATION_SPLITTER = Splitter.on((char)',');

    public abstract String pluginName();

    public abstract String instanceClassName();

    public abstract ImmutableSortedSet<String> sourceLocations();

    public static ByteSource serialize(Iterable<PluginRuntimeInstanceInfo> plugins) {
        StringBuilder builder = new StringBuilder();
        for (PluginRuntimeInstanceInfo plugin : plugins) {
            builder.append(plugin.toMetaInfEntry());
        }
        return CharSource.wrap((CharSequence)builder.toString()).asByteSource(StandardCharsets.UTF_8);
    }

    static ImmutableList<PluginRuntimeInstanceInfo> deserialize(ByteSource byteSource) throws IOException {
        LinkedHashMap<String, PluginRuntimeInstanceInfo> pluginNameToClassNameMap = new LinkedHashMap<String, PluginRuntimeInstanceInfo>();
        try (InputStream inputStream = byteSource.openStream();){
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            String line = reader.readLine();
            while (line != null) {
                PluginRuntimeInstanceInfo pluginRuntimeInstanceInfo = PluginRuntimeInstanceInfo.fromMetaInfEntry(line);
                pluginNameToClassNameMap.merge(pluginRuntimeInstanceInfo.pluginName(), pluginRuntimeInstanceInfo, PluginRuntimeInstanceInfo::merge);
                line = reader.readLine();
            }
        }
        return ImmutableList.copyOf(pluginNameToClassNameMap.values());
    }

    private String toMetaInfEntry() {
        return this.pluginName() + '|' + this.instanceClassName() + '|' + SOURCE_LOCATION_JOINER.join(this.sourceLocations()) + "\n";
    }

    private static PluginRuntimeInstanceInfo fromMetaInfEntry(String metaInfEntry) {
        List fields = FIELD_SPLITTER.splitToList((CharSequence)metaInfEntry.trim());
        Preconditions.checkState((fields.size() == 3 ? 1 : 0) != 0, (String)"Entry [%s] is expected to have exactly three fields but found %s fields (%s).", (Object)metaInfEntry, (Object)fields.size(), (Object)fields.toArray());
        return PluginRuntimeInstanceInfo.builder().setPluginName((String)fields.get(0)).setInstanceClassName((String)fields.get(1)).addAllSourceLocations(SOURCE_LOCATION_SPLITTER.splitToList((CharSequence)fields.get(2))).build();
    }

    @VisibleForTesting
    static PluginRuntimeInstanceInfo merge(PluginRuntimeInstanceInfo original, PluginRuntimeInstanceInfo other) {
        Preconditions.checkArgument((boolean)original.pluginName().equals(other.pluginName()));
        Preconditions.checkArgument((boolean)original.instanceClassName().equals(other.instanceClassName()));
        return PluginRuntimeInstanceInfo.builder().setPluginName(original.pluginName()).setInstanceClassName(original.instanceClassName()).addAllSourceLocations((Iterable<String>)original.sourceLocations()).addAllSourceLocations((Iterable<String>)other.sourceLocations()).build();
    }

    public static Builder builder() {
        return new AutoValue_PluginRuntimeInstanceInfo.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setPluginName(String var1);

        public abstract Builder setInstanceClassName(String var1);

        abstract ImmutableSortedSet.Builder<String> sourceLocationsBuilder();

        public Builder addAllSourceLocations(Iterable<String> sourceLocations) {
            this.sourceLocationsBuilder().addAll(sourceLocations);
            return this;
        }

        public Builder addSourceLocation(String sourceLocation) {
            this.sourceLocationsBuilder().add((Object)sourceLocation);
            return this;
        }

        public abstract PluginRuntimeInstanceInfo build();
    }
}

