/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.internal.AugmentedParamStore;
import com.google.template.soy.data.internal.BasicParamStore;
import com.google.template.soy.jbcsrc.restricted.AutoValue_ConstructorRef;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.runtime.JbcSrcRuntime;
import com.ibm.icu.util.ULocale;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

@AutoValue
public abstract class ConstructorRef {
    public static final ConstructorRef ARRAY_LIST = ConstructorRef.create(ArrayList.class, new Class[0]);
    public static final ConstructorRef ARRAY_LIST_SIZE = ConstructorRef.create(ArrayList.class, Integer.TYPE);
    public static final ConstructorRef HASH_MAP_CAPACITY = ConstructorRef.create(HashMap.class, Integer.TYPE);
    public static final ConstructorRef LINKED_HASH_MAP_CAPACITY = ConstructorRef.create(LinkedHashMap.class, Integer.TYPE);
    public static final ConstructorRef AUGMENTED_PARAM_STORE = ConstructorRef.create(AugmentedParamStore.class, SoyRecord.class, Integer.TYPE);
    public static final ConstructorRef BASIC_PARAM_STORE = ConstructorRef.create(BasicParamStore.class, Integer.TYPE);
    public static final ConstructorRef MSG_RENDERER = ConstructorRef.create(JbcSrcRuntime.MsgRenderer.class, Long.TYPE, ImmutableList.class, ULocale.class, Integer.TYPE, Boolean.TYPE);
    public static final ConstructorRef PLRSEL_MSG_RENDERER = ConstructorRef.create(JbcSrcRuntime.PlrSelMsgRenderer.class, Long.TYPE, ImmutableList.class, ULocale.class, Integer.TYPE, Boolean.TYPE);

    public static ConstructorRef create(TypeInfo type, Method init) {
        Preconditions.checkArgument((init.getName().equals("<init>") && init.getReturnType().equals((Object)Type.VOID_TYPE) ? 1 : 0) != 0, (String)"'%s' is not a valid constructor", (Object)init);
        return new AutoValue_ConstructorRef(type, init, (ImmutableList<Type>)ImmutableList.copyOf((Object[])init.getArgumentTypes()));
    }

    public static ConstructorRef create(TypeInfo type, Iterable<Type> argTypes) {
        return ConstructorRef.create(type, new Method("<init>", Type.VOID_TYPE, (Type[])Iterables.toArray(argTypes, Type.class)));
    }

    public static ConstructorRef create(Class<?> clazz, Class<?> ... argTypes) {
        Constructor<?> c;
        TypeInfo type = TypeInfo.create(clazz);
        try {
            c = clazz.getConstructor(argTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        Type constructorType = Type.getType(c);
        return new AutoValue_ConstructorRef(type, Method.getMethod(c), (ImmutableList<Type>)ImmutableList.copyOf((Object[])constructorType.getArgumentTypes()));
    }

    public abstract TypeInfo instanceClass();

    public abstract Method method();

    public abstract ImmutableList<Type> argTypes();

    public Expression construct(Expression ... args) {
        return this.construct(Arrays.asList(args));
    }

    public Expression construct(final Iterable<? extends Expression> args) {
        Expression.checkTypes(this.argTypes(), args);
        return new Expression(this.instanceClass().type(), Expression.Feature.NON_NULLABLE, new Expression.Feature[0]){

            @Override
            protected void doGen(CodeBuilder mv) {
                mv.newInstance(ConstructorRef.this.instanceClass().type());
                mv.dup();
                for (Expression arg : args) {
                    arg.gen(mv);
                }
                mv.invokeConstructor(ConstructorRef.this.instanceClass().type(), ConstructorRef.this.method());
            }
        };
    }

    public Handle toHandle() {
        return new Handle(8, this.instanceClass().type().getInternalName(), "<init>", this.method().getDescriptor(), false);
    }
}

