/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.internal.RuntimeMapTypeTracker;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyRuntimeType;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.LegacyObjectMapType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.UnknownType;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public final class SoyExpression
extends Expression {
    public static final SoyExpression NULL = new SoyExpression(SoyExpression.getUnboxedType(NullType.getInstance()), new Expression(BytecodeUtils.OBJECT.type(), Expression.Feature.CHEAP, new Expression.Feature[0]){

        @Override
        protected void doGen(CodeBuilder cb) {
            cb.pushNull();
        }
    });
    public static final SoyExpression NULL_BOXED = new SoyExpression(SoyRuntimeType.getBoxedType(NullType.getInstance()), new Expression(BytecodeUtils.SOY_VALUE_TYPE, Expression.Feature.CHEAP, new Expression.Feature[0]){

        @Override
        protected void doGen(CodeBuilder cb) {
            cb.pushNull();
        }
    });
    public static final SoyExpression TRUE = SoyExpression.forBool(BytecodeUtils.constant(true));
    public static final SoyExpression FALSE = SoyExpression.forBool(BytecodeUtils.constant(false));
    private final SoyRuntimeType soyRuntimeType;
    private final Expression delegate;

    public static SoyExpression forSoyValue(SoyType type, Expression delegate) {
        return new SoyExpression(SoyRuntimeType.getBoxedType(type), delegate);
    }

    public static SoyExpression forBool(Expression delegate) {
        return new SoyExpression(SoyExpression.getUnboxedType(BoolType.getInstance()), delegate);
    }

    public static SoyExpression forFloat(Expression delegate) {
        return new SoyExpression(SoyExpression.getUnboxedType(FloatType.getInstance()), delegate);
    }

    public static SoyExpression forInt(Expression delegate) {
        return new SoyExpression(SoyExpression.getUnboxedType(IntType.getInstance()), delegate);
    }

    public static SoyExpression forString(Expression delegate) {
        return new SoyExpression(SoyExpression.getUnboxedType(StringType.getInstance()), delegate);
    }

    public static SoyExpression forList(ListType listType, Expression delegate) {
        return new SoyExpression(SoyExpression.getUnboxedType(listType), delegate);
    }

    public static SoyExpression forBoxedList(ListType listType, Expression delegate) {
        return new SoyExpression(SoyRuntimeType.getBoxedType(listType), delegate);
    }

    public static SoyExpression forLegacyObjectMap(LegacyObjectMapType mapType, Expression delegate) {
        return new SoyExpression(SoyRuntimeType.getBoxedType(mapType), delegate);
    }

    public static SoyExpression forMap(MapType mapType, Expression delegate) {
        return new SoyExpression(SoyRuntimeType.getBoxedType(mapType), delegate);
    }

    public static SoyExpression forProto(SoyRuntimeType type, Expression delegate) {
        Preconditions.checkArgument((type.soyType().getKind() == SoyType.Kind.PROTO ? 1 : 0) != 0);
        return new SoyExpression(type, delegate);
    }

    public static SoyExpression forRuntimeType(SoyRuntimeType type, Expression delegate) {
        return new SoyExpression(type, delegate);
    }

    public static Expression asBoxedList(List<SoyExpression> items) {
        ArrayList<SoyExpression> childExprs = new ArrayList<SoyExpression>(items.size());
        for (SoyExpression child : items) {
            childExprs.add(child.box());
        }
        return BytecodeUtils.asList(childExprs);
    }

    public static Expression asBoxedValueProviderList(List<SoyExpression> items) {
        ArrayList<Expression> childExprs = new ArrayList<Expression>(items.size());
        for (SoyExpression child : items) {
            childExprs.add(child.boxAsSoyValueProvider());
        }
        return BytecodeUtils.asList(childExprs);
    }

    private static SoyRuntimeType getUnboxedType(SoyType soyType) {
        return SoyRuntimeType.getUnboxedType(soyType).get();
    }

    private SoyExpression(SoyRuntimeType soyRuntimeType, Expression delegate) {
        super(delegate.resultType(), delegate.features());
        Preconditions.checkArgument((boolean)BytecodeUtils.isPossiblyAssignableFrom(soyRuntimeType.runtimeType(), delegate.resultType()), (String)"Expecting SoyExpression type of %s for soy type %s, found delegate with type of %s", (Object)soyRuntimeType.runtimeType(), (Object)soyRuntimeType.soyType(), (Object)delegate.resultType());
        this.soyRuntimeType = soyRuntimeType;
        this.delegate = delegate;
    }

    public final SoyType soyType() {
        return this.soyRuntimeType.soyType();
    }

    public final SoyRuntimeType soyRuntimeType() {
        return this.soyRuntimeType;
    }

    @Override
    protected final void doGen(CodeBuilder adapter) {
        this.delegate.gen(adapter);
    }

    @Override
    public SoyExpression withSourceLocation(SourceLocation location) {
        return this.withSource(this.delegate.withSourceLocation(location));
    }

    public boolean assignableToNullableInt() {
        return this.soyRuntimeType.assignableToNullableInt();
    }

    public boolean assignableToNullableFloat() {
        return this.soyRuntimeType.assignableToNullableFloat();
    }

    public boolean assignableToNullableNumber() {
        return this.soyRuntimeType.assignableToNullableNumber();
    }

    public boolean assignableToNullableString() {
        return this.soyRuntimeType.assignableToNullableString();
    }

    public boolean isBoxed() {
        return this.soyRuntimeType.isBoxed();
    }

    public Expression boxAsSoyValueProvider() {
        if (this.soyType().equals(NullType.getInstance())) {
            if (this.delegate == NULL || this.delegate == NULL_BOXED) {
                return FieldRef.NULL_PROVIDER.accessor();
            }
            return this.toStatement().then(FieldRef.NULL_PROVIDER.accessor());
        }
        if (this.delegate.isNonNullable()) {
            return this.box();
        }
        if (this.isBoxed()) {
            return new Expression(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE, this.delegate.features().plus(Expression.Feature.NON_NULLABLE)){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    Label end = new Label();
                    SoyExpression.this.delegate.gen(adapter);
                    adapter.dup();
                    adapter.ifNonNull(end);
                    adapter.pop();
                    FieldRef.NULL_PROVIDER.accessStaticUnchecked(adapter);
                    adapter.mark(end);
                }
            };
        }
        return new Expression(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE, this.delegate.features().plus(Expression.Feature.NON_NULLABLE)){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Label end = new Label();
                SoyExpression.this.delegate.gen(adapter);
                adapter.dup();
                Label nonNull = new Label();
                adapter.ifNonNull(nonNull);
                adapter.pop();
                FieldRef.NULL_PROVIDER.accessStaticUnchecked(adapter);
                adapter.goTo(end);
                adapter.mark(nonNull);
                SoyExpression.doBox(adapter, SoyExpression.this.soyRuntimeType.asNonNullable());
                adapter.mark(end);
            }
        };
    }

    public SoyExpression box() {
        if (this.isBoxed()) {
            return this;
        }
        if (this.soyType().equals(NullType.getInstance())) {
            if (this.delegate == NULL) {
                return NULL_BOXED;
            }
            return this.asBoxed(this.toStatement().then(NULL_BOXED));
        }
        if (this.soyRuntimeType.isKnownBool()) {
            return this.asBoxed(MethodRef.BOOLEAN_DATA_FOR_VALUE.invoke(this.delegate));
        }
        if (this.soyRuntimeType.isKnownInt()) {
            return this.asBoxed(MethodRef.INTEGER_DATA_FOR_VALUE.invoke(this.delegate));
        }
        if (this.soyRuntimeType.isKnownFloat()) {
            return this.asBoxed(MethodRef.FLOAT_DATA_FOR_VALUE.invoke(this.delegate));
        }
        final boolean isNonNullable = this.delegate.isNonNullable();
        return this.asBoxed(new Expression(this.soyRuntimeType.box().runtimeType(), this.features()){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Label end = null;
                SoyExpression.this.delegate.gen(adapter);
                if (!isNonNullable) {
                    end = new Label();
                    BytecodeUtils.nullCoalesce(adapter, end);
                }
                SoyExpression.doBox(adapter, SoyExpression.this.soyRuntimeType.asNonNullable());
                if (end != null) {
                    adapter.mark(end);
                }
            }
        });
    }

    private static void doBox(CodeBuilder adapter, SoyRuntimeType type) {
        if (type.isKnownSanitizedContent()) {
            SanitizedContent.ContentKind kind = SanitizedContent.ContentKind.valueOf(((SanitizedType)type.soyType()).getContentKind().name());
            Preconditions.checkState((kind != SanitizedContent.ContentKind.TEXT ? 1 : 0) != 0);
            FieldRef.enumReference(kind).accessStaticUnchecked(adapter);
            MethodRef.ORDAIN_AS_SAFE.invokeUnchecked(adapter);
        } else if (type.isKnownString()) {
            MethodRef.STRING_DATA_FOR_VALUE.invokeUnchecked(adapter);
        } else if (type.isKnownListOrUnionOfLists()) {
            MethodRef.LIST_IMPL_FOR_PROVIDER_LIST.invokeUnchecked(adapter);
        } else if (type.isKnownLegacyObjectMapOrUnionOfMaps()) {
            FieldRef.enumReference(RuntimeMapTypeTracker.Type.LEGACY_OBJECT_MAP_OR_RECORD).putUnchecked(adapter);
            MethodRef.DICT_IMPL_FOR_PROVIDER_MAP.invokeUnchecked(adapter);
        } else if (type.isKnownMapOrUnionOfMaps()) {
            MethodRef.MAP_IMPL_FOR_PROVIDER_MAP.invokeUnchecked(adapter);
        } else if (type.isKnownProtoOrUnionOfProtos()) {
            MethodRef.SOY_PROTO_VALUE_CREATE.invokeUnchecked(adapter);
        } else {
            throw new IllegalStateException("Can't box soy expression of type " + type);
        }
    }

    private SoyExpression asBoxed(Expression expr) {
        return new SoyExpression(this.soyRuntimeType.box(), expr);
    }

    public SoyExpression coerceToBoolean() {
        if (BytecodeUtils.isPrimitive(this.resultType())) {
            return this.coercePrimitiveToBoolean();
        }
        if (this.soyType().equals(NullType.getInstance())) {
            return FALSE;
        }
        if (this.isBoxed()) {
            if (this.delegate.isNonNullable()) {
                return SoyExpression.forBool(this.delegate.invoke(MethodRef.SOY_VALUE_COERCE_TO_BOOLEAN, new Expression[0]));
            }
            return SoyExpression.forBool(MethodRef.RUNTIME_COERCE_TO_BOOLEAN.invoke(this.delegate));
        }
        if (this.resultType().equals((Object)BytecodeUtils.STRING_TYPE)) {
            return SoyExpression.forBool(this.delegate.invoke(MethodRef.RUNTIME_COERCE_STRING_TO_BOOLEAN, new Expression[0]));
        }
        return BytecodeUtils.isNonNull(this.delegate);
    }

    private SoyExpression coercePrimitiveToBoolean() {
        if (this.resultType().equals((Object)Type.BOOLEAN_TYPE)) {
            return this;
        }
        if (this.resultType().equals((Object)Type.DOUBLE_TYPE)) {
            return SoyExpression.forBool(MethodRef.RUNTIME_COERCE_DOUBLE_TO_BOOLEAN.invoke(this.delegate));
        }
        if (this.resultType().equals((Object)Type.LONG_TYPE)) {
            return SoyExpression.forBool(BytecodeUtils.compare(154, this.delegate, BytecodeUtils.constant(0L)));
        }
        throw new AssertionError((Object)("resultType(): " + this.resultType() + " is not a valid type for a SoyExpression"));
    }

    public SoyExpression coerceToString() {
        if (this.soyRuntimeType.isKnownString() && !this.isBoxed()) {
            if (this.isNonNullable()) {
                return this;
            }
            return SoyExpression.forString(MethodRef.STRING_VALUE_OF.invoke(this.delegate));
        }
        if (BytecodeUtils.isPrimitive(this.resultType())) {
            if (this.resultType().equals((Object)Type.BOOLEAN_TYPE)) {
                return SoyExpression.forString(MethodRef.BOOLEAN_TO_STRING.invoke(this.delegate));
            }
            if (this.resultType().equals((Object)Type.DOUBLE_TYPE)) {
                return SoyExpression.forString(MethodRef.DOUBLE_TO_STRING.invoke(this.delegate));
            }
            if (this.resultType().equals((Object)Type.LONG_TYPE)) {
                return SoyExpression.forString(MethodRef.LONG_TO_STRING.invoke(this.delegate));
            }
            throw new AssertionError((Object)("resultType(): " + this.resultType() + " is not a valid type for a SoyExpression"));
        }
        if (!this.isBoxed()) {
            return SoyExpression.forString(MethodRef.STRING_VALUE_OF.invoke(this.delegate));
        }
        return SoyExpression.forString(MethodRef.RUNTIME_COERCE_TO_STRING.invoke(this.delegate));
    }

    public SoyExpression coerceToDouble() {
        if (!this.isBoxed()) {
            if (this.soyRuntimeType.isKnownFloat()) {
                return this;
            }
            if (this.soyRuntimeType.isKnownInt()) {
                return SoyExpression.forFloat(BytecodeUtils.numericConversion(this.delegate, Type.DOUBLE_TYPE));
            }
            throw new UnsupportedOperationException("Can't convert " + this.resultType() + " to a double");
        }
        if (this.soyRuntimeType.isKnownFloat()) {
            return SoyExpression.forFloat(this.delegate.invoke(MethodRef.SOY_VALUE_FLOAT_VALUE, new Expression[0]));
        }
        return SoyExpression.forFloat(this.delegate.invoke(MethodRef.SOY_VALUE_NUMBER_VALUE, new Expression[0]));
    }

    public SoyExpression unboxAsBoolean() {
        if (this.alreadyUnboxed(Boolean.TYPE)) {
            return this;
        }
        this.assertBoxed(Boolean.TYPE);
        return SoyExpression.forBool(this.delegate.invoke(MethodRef.SOY_VALUE_BOOLEAN_VALUE, new Expression[0]));
    }

    public SoyExpression unboxAsLong() {
        if (this.alreadyUnboxed(Long.TYPE)) {
            return this;
        }
        this.assertBoxed(Long.TYPE);
        return SoyExpression.forInt(this.delegate.invoke(MethodRef.SOY_VALUE_LONG_VALUE, new Expression[0]));
    }

    public SoyExpression unboxAsDouble() {
        if (this.alreadyUnboxed(Double.TYPE)) {
            return this;
        }
        this.assertBoxed(Double.TYPE);
        return SoyExpression.forFloat(this.delegate.invoke(MethodRef.SOY_VALUE_FLOAT_VALUE, new Expression[0]));
    }

    public SoyExpression unboxAsString() {
        if (this.alreadyUnboxed(String.class)) {
            return this;
        }
        this.assertBoxed(String.class);
        Expression unboxedString = this.delegate.isNonNullable() ? this.delegate.invoke(MethodRef.SOY_VALUE_STRING_VALUE, new Expression[0]) : new Expression(BytecodeUtils.STRING_TYPE, this.features()){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Label end = new Label();
                SoyExpression.this.delegate.gen(adapter);
                BytecodeUtils.nullCoalesce(adapter, end);
                MethodRef.SOY_VALUE_STRING_VALUE.invokeUnchecked(adapter);
                adapter.mark(end);
            }
        };
        return SoyExpression.forString(unboxedString);
    }

    public SoyExpression unboxAsList() {
        ListType asListType;
        if (this.alreadyUnboxed(List.class)) {
            return this;
        }
        this.assertBoxed(List.class);
        Expression unboxedList = this.delegate.isNonNullable() ? this.delegate.checkedCast(BytecodeUtils.SOY_LIST_TYPE).invoke(MethodRef.SOY_LIST_AS_JAVA_LIST, new Expression[0]) : new Expression(BytecodeUtils.LIST_TYPE, this.features()){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Label end = new Label();
                SoyExpression.this.delegate.gen(adapter);
                BytecodeUtils.nullCoalesce(adapter, end);
                adapter.checkCast(BytecodeUtils.SOY_LIST_TYPE);
                MethodRef.SOY_LIST_AS_JAVA_LIST.invokeUnchecked(adapter);
                adapter.mark(end);
            }
        };
        if (this.soyType().getKind() != SoyType.Kind.NULL && this.soyRuntimeType.asNonNullable().isKnownListOrUnionOfLists()) {
            asListType = this.soyRuntimeType.asNonNullable().asListType();
        } else {
            SoyType.Kind kind = this.soyType().getKind();
            if (kind == SoyType.Kind.UNKNOWN || kind == SoyType.Kind.NULL) {
                asListType = ListType.of(UnknownType.getInstance());
            } else {
                throw new UnsupportedOperationException("Can't convert " + this.soyRuntimeType + " to List");
            }
        }
        return SoyExpression.forList(asListType, unboxedList);
    }

    public Expression unboxAsMessage() {
        if (this.soyType().getKind() == SoyType.Kind.NULL) {
            return BytecodeUtils.constantNull(BytecodeUtils.MESSAGE_TYPE);
        }
        if (this.soyRuntimeType.asNonNullable().isKnownProtoOrUnionOfProtos() && !this.isBoxed()) {
            return this;
        }
        final Expression protoDelegate = this.delegate.checkedCast(SoyProtoValue.class);
        if (this.delegate.isNonNullable()) {
            return protoDelegate.invoke(MethodRef.SOY_PROTO_VALUE_GET_PROTO, new Expression[0]);
        }
        return new Expression(BytecodeUtils.MESSAGE_TYPE, this.features()){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Label end = new Label();
                protoDelegate.gen(adapter);
                BytecodeUtils.nullCoalesce(adapter, end);
                MethodRef.SOY_PROTO_VALUE_GET_PROTO.invokeUnchecked(adapter);
                adapter.mark(end);
            }
        };
    }

    private boolean alreadyUnboxed(Class<?> asType) {
        return BytecodeUtils.isDefinitelyAssignableFrom(Type.getType(asType), this.soyRuntimeType.runtimeType());
    }

    private void assertBoxed(Class<?> asType) {
        if (!this.isBoxed()) {
            throw new IllegalStateException("Trying to unbox an unboxed value (" + this.soyRuntimeType + ") into " + asType + " doesn't make sense. Should you be using a type coercion? e.g. coerceToBoolean()");
        }
    }

    public SoyExpression withSource(Expression expr) {
        if (expr == this.delegate) {
            return this;
        }
        return new SoyExpression(this.soyRuntimeType, expr);
    }

    @Override
    public SoyExpression asCheap() {
        return this.withSource(this.delegate.asCheap());
    }

    @Override
    public SoyExpression asNonNullable() {
        return new SoyExpression(this.soyRuntimeType.asNonNullable(), this.delegate.asNonNullable());
    }

    @Override
    public SoyExpression asNullable() {
        return new SoyExpression(this.soyRuntimeType.asNullable(), this.delegate.asNullable());
    }

    @Override
    public SoyExpression labelStart(Label label) {
        return this.withSource(this.delegate.labelStart(label));
    }

    @Override
    public SoyExpression labelEnd(Label label) {
        return this.withSource(this.delegate.labelEnd(label));
    }
}

