/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.shared;

import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyVisualElement;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.logging.LoggableElementMetadata;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public final class ClassLoaderFallbackCallFactory {
    private static final MethodType SLOWPATH_TYPE = MethodType.methodType(CompiledTemplate.class, String.class, RenderContext.class, SoyRecord.class, SoyRecord.class);
    private static final MethodType SLOWPATH_FACTORY_VALUE_TYPE = MethodType.methodType(CompiledTemplate.FactoryValue.class, String.class, RenderContext.class);
    private static final MethodType NORMAL_CONSTRUCTOR = MethodType.methodType(Void.TYPE, SoyRecord.class, SoyRecord.class);
    private static final MethodType VE_METADATA_SLOW_PATH_TYPE = MethodType.methodType(LoggableElementMetadata.class, String.class, RenderContext.class, Long.TYPE);
    private static final MethodType CREATE_VE_TYPE = MethodType.methodType(SoyVisualElement.class, Long.TYPE, String.class, LoggableElementMetadata.class);

    private ClassLoaderFallbackCallFactory() {
    }

    public static CallSite bootstrapFactoryValueLookup(MethodHandles.Lookup lookup, String name, MethodType type, String templateName) {
        ClassLoader callerClassLoader = lookup.lookupClass().getClassLoader();
        String className = Names.javaClassNameFromSoyTemplateName(templateName);
        try {
            CompiledTemplate.Factory factory;
            Class<?> targetTemplateClass = callerClassLoader.loadClass(className);
            try {
                factory = lookup.findStatic(targetTemplateClass, "factory", MethodType.methodType(CompiledTemplate.Factory.class)).invokeExact();
            }
            catch (Throwable t) {
                throw new AssertionError((Object)t);
            }
            CompiledTemplate.FactoryValue value = CompiledTemplate.FactoryValue.create(templateName, factory);
            MethodHandle getter = MethodHandles.constant(CompiledTemplate.FactoryValue.class, value);
            getter = MethodHandles.dropArguments(getter, 0, new Class[]{RenderContext.class});
            return new ConstantCallSite(getter);
        }
        catch (ClassNotFoundException targetTemplateClass) {
            try {
                MethodHandle handle = lookup.findStatic(ClassLoaderFallbackCallFactory.class, "slowPathFactoryValue", SLOWPATH_FACTORY_VALUE_TYPE);
                handle = MethodHandles.insertArguments(handle, 0, templateName);
                return new ConstantCallSite(handle);
            }
            catch (ReflectiveOperationException roe) {
                throw new AssertionError("impossible, can't find our slowPathFactoryValue method", roe);
            }
        }
    }

    public static CallSite bootstrapConstruction(MethodHandles.Lookup lookup, String name, MethodType type, String templateName) {
        ClassLoader callerClassLoader = lookup.lookupClass().getClassLoader();
        String className = Names.javaClassNameFromSoyTemplateName(templateName);
        try {
            Class<?> templateClass = callerClassLoader.loadClass(className);
            MethodHandle handle = lookup.findConstructor(templateClass, NORMAL_CONSTRUCTOR);
            handle = MethodHandles.dropArguments(handle, 0, new Class[]{RenderContext.class});
            handle = handle.asType(type);
            return new ConstantCallSite(handle);
        }
        catch (IllegalAccessException | NoSuchMethodException nsme) {
            throw new AssertionError((Object)nsme);
        }
        catch (ClassNotFoundException nsme) {
            try {
                MethodHandle handle = lookup.findStatic(ClassLoaderFallbackCallFactory.class, "slowPath", SLOWPATH_TYPE);
                handle = MethodHandles.insertArguments(handle, 0, templateName);
                return new ConstantCallSite(handle);
            }
            catch (ReflectiveOperationException roe) {
                throw new AssertionError("impossible, can't find our slowPath method", roe);
            }
        }
    }

    public static CallSite bootstrapVeWithMetadata(MethodHandles.Lookup lookup, String name, MethodType type, String metadataClassName) {
        try {
            MethodHandle metadataGetter = ClassLoaderFallbackCallFactory.getMetadataGetter(lookup, metadataClassName);
            MethodHandle createVe = lookup.findStatic(SoyVisualElement.class, "create", CREATE_VE_TYPE);
            MethodHandle handle = MethodHandles.collectArguments(createVe, 2, metadataGetter);
            return new ConstantCallSite(handle);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static MethodHandle getMetadataGetter(MethodHandles.Lookup lookup, String metadataClassName) throws ReflectiveOperationException {
        ClassLoader callerClassLoader = lookup.lookupClass().getClassLoader();
        try {
            Class<?> metadataClass = callerClassLoader.loadClass(metadataClassName);
            MethodHandle handle = lookup.findStatic(metadataClass, "getMetadata", MethodType.methodType(LoggableElementMetadata.class, Long.TYPE));
            return MethodHandles.dropArguments(handle, 0, new Class[]{RenderContext.class});
        }
        catch (ClassNotFoundException metadataClass) {
            MethodHandle handle = lookup.findStatic(ClassLoaderFallbackCallFactory.class, "veMetadataSlowPath", VE_METADATA_SLOW_PATH_TYPE);
            return MethodHandles.insertArguments(handle, 0, metadataClassName);
        }
    }

    public static CompiledTemplate.FactoryValue slowPathFactoryValue(String templateName, RenderContext context) {
        return CompiledTemplate.FactoryValue.create(templateName, context.getTemplateFactory(templateName));
    }

    public static CompiledTemplate slowPath(String templateName, RenderContext context, SoyRecord params, SoyRecord ijParams) {
        return context.getTemplateFactory(templateName).create(params, ijParams);
    }

    public static LoggableElementMetadata veMetadataSlowPath(String metadataClassName, RenderContext renderContext, long veId) {
        return renderContext.getVeMetadata(metadataClassName, veId);
    }
}

