/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.base.internal.UniqueNameGenerator;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.VariableDeclaration;
import com.google.template.soy.jssrc.restricted.JsExpr;
import java.util.function.Consumer;

@Immutable
public abstract class CodeChunk {
    public abstract void collectRequires(Consumer<GoogRequire> var1);

    public final String getCode() {
        return this.getCode(0);
    }

    @ForOverride
    String getCode(int startingIndent) {
        FormattingContext initialStatements = new FormattingContext(startingIndent);
        initialStatements.appendInitialStatements(this);
        FormattingContext outputExprs = new FormattingContext(startingIndent);
        if (this instanceof Expression) {
            outputExprs.appendOutputExpression((Expression)this);
            outputExprs.append(';').endLine();
        }
        return initialStatements.concat(outputExprs).toString();
    }

    public final String getStatementsForInsertingIntoForeignCodeAtIndent(int startingIndent) {
        String code = this.getCode(startingIndent);
        return code.endsWith("\n") ? code : code + "\n";
    }

    public final JsExpr assertExpr() {
        ImmutableSet.Builder requiresBuilder = ImmutableSet.builder();
        JsExpr expr = this.assertExprAndCollectRequires(arg_0 -> ((ImmutableSet.Builder)requiresBuilder).add(arg_0));
        ImmutableSet requires = requiresBuilder.build();
        if (!requires.isEmpty()) {
            throw new IllegalStateException("calling assertExpr() would drop requires!: " + requires);
        }
        return expr;
    }

    public final JsExpr assertExprAndCollectRequires(Consumer<GoogRequire> collector) {
        Expression expression = (Expression)this;
        if (!expression.isRepresentableAsSingleExpression()) {
            throw new IllegalStateException(String.format("Not an expr:\n%s", this.getCode()));
        }
        this.collectRequires(collector);
        return expression.singleExprOrName();
    }

    abstract void doFormatInitialStatements(FormattingContext var1);

    CodeChunk() {
    }

    public static final class Generator {
        private final UniqueNameGenerator nameGenerator;

        private Generator(UniqueNameGenerator nameGenerator) {
            this.nameGenerator = nameGenerator;
        }

        public static Generator create(UniqueNameGenerator nameGenerator) {
            return new Generator(nameGenerator);
        }

        private String newVarName() {
            return this.nameGenerator.generateName("$tmp");
        }

        public VariableDeclaration.Builder declarationBuilder() {
            return VariableDeclaration.builder(this.newVarName());
        }

        public Expression conditionalExpression(Expression predicate, Expression consequent, Expression alternate) {
            return Expression.ifExpression(predicate, consequent).setElse(alternate).build(this);
        }
    }
}

