/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_JsDoc;
import com.google.template.soy.jssrc.dsl.AutoValue_JsDoc_Param;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;

@Immutable
@AutoValue
public abstract class JsDoc {
    public static Builder builder() {
        return new AutoValue_JsDoc.Builder();
    }

    abstract ImmutableList<GoogRequire> requires();

    abstract ImmutableList<Param> params();

    public void collectRequires(Consumer<GoogRequire> collector) {
        for (GoogRequire require : this.requires()) {
            collector.accept(require);
        }
    }

    public void doFormatJsDoc(FormattingContext ctx) {
        if (this.isSingleLine()) {
            ctx.append(this.toString());
            return;
        }
        ctx.append("/**");
        ctx.endLine();
        for (Param param : this.params()) {
            ctx.append(" * ");
            param.format(ctx);
            ctx.endLine();
        }
        ctx.append(" */");
    }

    public final String toString() {
        if (this.isSingleLine()) {
            return String.format("/** %s */", this.params().get(0));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n");
        for (Param param : this.params()) {
            sb.append(" * ").append(param).append("\n");
        }
        sb.append(" */");
        return sb.toString();
    }

    private boolean isSingleLine() {
        return this.params().size() == 1 && !"typedef".equals(((Param)this.params().get(0)).annotationType()) && ((Param)this.params().get(0)).recordLiteralType() == null;
    }

    @Immutable
    @AutoValue
    static abstract class Param {
        Param() {
        }

        abstract String annotationType();

        @Nullable
        abstract String field();

        @Nullable
        abstract String type();

        @Nullable
        abstract String paramTypeName();

        @Nullable
        abstract ImmutableMap<String, String> recordLiteralType();

        static Param createAnnotation(String annotationType, String field) {
            return new AutoValue_JsDoc_Param(annotationType, field, null, null, null);
        }

        static Param create(String annotationType, String type) {
            return new AutoValue_JsDoc_Param(annotationType, null, type, null, null);
        }

        static Param create(String annotationType, String type, String paramTypeName) {
            return new AutoValue_JsDoc_Param(annotationType, null, type, paramTypeName, null);
        }

        static Param create(String annotationType, String paramTypeName, ImmutableMap<String, String> recordLiteralType) {
            return new AutoValue_JsDoc_Param(annotationType, null, null, paramTypeName, recordLiteralType);
        }

        void format(FormattingContext ctx) {
            if (this.recordLiteralType() != null) {
                ctx.append(String.format("@%s {{", this.annotationType()));
                ctx.endLine();
                for (Map.Entry entry : this.recordLiteralType().entrySet()) {
                    ctx.append(" *   " + (String)entry.getKey() + ": " + (String)entry.getValue() + ",");
                    ctx.endLine();
                }
                ctx.append(String.format(" * }} %s", this.paramTypeName()));
            } else {
                ctx.append(this.toString());
            }
        }

        public final String toString() {
            if (this.type() == null && this.field() == null) {
                return String.format("@%s", this.annotationType());
            }
            if (this.field() != null) {
                return String.format("@%s %s", this.annotationType(), this.field());
            }
            if (this.paramTypeName() == null) {
                return String.format("@%s {%s}", this.annotationType(), this.type());
            }
            return String.format("@%s {%s} %s", this.annotationType(), this.type(), this.paramTypeName());
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract ImmutableList.Builder<Param> paramsBuilder();

        abstract ImmutableList.Builder<GoogRequire> requiresBuilder();

        public abstract JsDoc build();

        public Builder addGoogRequire(GoogRequire require) {
            this.requiresBuilder().add((Object)require);
            return this;
        }

        public Builder addParameterizedAnnotation(String name, String value) {
            this.paramsBuilder().add((Object)Param.create(name, value));
            return this;
        }

        public Builder addAnnotation(String type) {
            this.paramsBuilder().add((Object)Param.createAnnotation(type, null));
            return this;
        }

        public Builder addAnnotation(String type, String value) {
            this.paramsBuilder().add((Object)Param.createAnnotation(type, value));
            return this;
        }

        public Builder addParam(String name, String type) {
            this.paramsBuilder().add((Object)Param.create("param", type, name));
            return this;
        }

        public Builder addParam(String name, ImmutableMap<String, String> recordLiteralType) {
            this.paramsBuilder().add((Object)Param.create("param", name, recordLiteralType));
            return this;
        }
    }
}

