/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.jssrc.dsl.AutoValue_StringLiteral;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.restricted.JsExpr;
import java.util.Optional;
import java.util.function.Consumer;

@Immutable
@AutoValue
abstract class StringLiteral
extends Expression {
    StringLiteral() {
    }

    static Expression create(String literalValue) {
        return new AutoValue_StringLiteral((ImmutableList<Statement>)ImmutableList.of(), literalValue);
    }

    abstract String literalValue();

    @Override
    public boolean isCheap() {
        return true;
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.append(StringLiteral.quoteAndEscape(this.literalValue()));
    }

    @Override
    public JsExpr singleExprOrName() {
        return new JsExpr(StringLiteral.quoteAndEscape(this.literalValue()), Integer.MAX_VALUE);
    }

    private static String quoteAndEscape(String literal) {
        String escaped = BaseUtils.escapeToSoyString(literal, true, QuoteStyle.SINGLE);
        return escaped.replace("</script", "<\\/script");
    }

    @Override
    public Optional<String> asStringLiteral() {
        return Optional.of(this.literalValue());
    }

    @Override
    public void collectRequires(Consumer<GoogRequire> collector) {
    }
}

