/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.NullSafeAccessNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.ProtoEnumValueNode;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.exprtree.VeLiteralNode;
import com.google.template.soy.internal.proto.ProtoUtils;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.SoyJsPluginUtils;
import com.google.template.soy.jssrc.internal.JavaScriptValueFactoryImpl;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.JsType;
import com.google.template.soy.jssrc.internal.NullSafeAccumulator;
import com.google.template.soy.jssrc.internal.SoyToJsVariableMappings;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.logging.ValidatedLoggingConfig;
import com.google.template.soy.plugin.javascript.restricted.SoyJavaScriptSourceFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.internal.BuiltinMethod;
import com.google.template.soy.shared.restricted.SoyMethod;
import com.google.template.soy.shared.restricted.SoySourceFunctionMethod;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.defn.LocalVar;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.UnionType;
import com.google.template.soy.types.UnknownType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class TranslateExprNodeVisitor
extends AbstractReturningExprNodeVisitor<Expression> {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ");
    private static final SoyErrorKind UNION_ACCESSOR_MISMATCH = SoyErrorKind.of("Cannot access field ''{0}'' of type ''{1}'', because the different union member types have different access methods.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SOY_JS_SRC_FUNCTION_NOT_FOUND = SoyErrorKind.of("Function ''{0}'' implemented by ''{1}'' does not have a JavaScript implementation.", new SoyErrorKind.StyleAllowance[0]);
    private final SoyToJsVariableMappings variableMappings;
    private final JavaScriptValueFactoryImpl javascriptValueFactory;
    private final ErrorReporter errorReporter;
    private final CodeChunk.Generator codeGenerator;
    private final TemplateAliases templateAliases;

    public TranslateExprNodeVisitor(JavaScriptValueFactoryImpl javascriptValueFactory, TranslationContext translationContext, TemplateAliases templateAliases, ErrorReporter errorReporter) {
        this.javascriptValueFactory = javascriptValueFactory;
        this.errorReporter = errorReporter;
        this.variableMappings = translationContext.soyToJsVariableMappings();
        this.codeGenerator = translationContext.codeGenerator();
        this.templateAliases = templateAliases;
    }

    Expression genCodeForParamAccess(String paramName, VarDefn varDefn) {
        Expression source = JsRuntime.OPT_DATA;
        if (varDefn.isInjected()) {
            if (paramName.equals("csp_nonce")) {
                return JsRuntime.OPT_IJ_DATA.and(JsRuntime.OPT_IJ_DATA.dotAccess(paramName), this.codeGenerator);
            }
            source = JsRuntime.OPT_IJ_DATA;
        } else if (varDefn.kind() == VarDefn.Kind.STATE) {
            return this.genCodeForStateAccess(paramName, (TemplateStateVar)varDefn);
        }
        return source.dotAccess(paramName);
    }

    protected Expression genCodeForStateAccess(String paramName, TemplateStateVar stateVar) {
        return Expression.id(paramName);
    }

    @Override
    protected Expression visitExprRootNode(ExprRootNode node) {
        return (Expression)this.visit(node.getRoot());
    }

    @Override
    protected Expression visitBooleanNode(BooleanNode node) {
        return node.getValue() ? Expression.LITERAL_TRUE : Expression.LITERAL_FALSE;
    }

    @Override
    protected Expression visitFloatNode(FloatNode node) {
        return Expression.number(node.getValue());
    }

    @Override
    protected Expression visitIntegerNode(IntegerNode node) {
        return Expression.number(node.getValue());
    }

    @Override
    protected Expression visitNullNode(NullNode node) {
        return Expression.LITERAL_NULL;
    }

    @Override
    protected Expression visitStringNode(StringNode node) {
        return Expression.stringLiteral(node.getValue());
    }

    @Override
    protected Expression visitProtoEnumValueNode(ProtoEnumValueNode node) {
        return Expression.number(node.getValue());
    }

    @Override
    protected Expression visitListLiteralNode(ListLiteralNode node) {
        if (node.numChildren() == 0) {
            return Expression.arrayLiteral((Iterable<? extends Expression>)ImmutableList.of());
        }
        return JsRuntime.SOY_MAKE_ARRAY.call(this.visitChildren(node));
    }

    @Override
    protected Expression visitListComprehensionNode(ListComprehensionNode node) {
        VarRefNode transformNode;
        SoyType listType;
        String indexVarTranslation;
        Expression base = (Expression)this.visit(node.getListExpr());
        String listIterVarTranslation = "list_comp_" + node.getNodeId() + "_" + node.getListIterVar().name();
        this.variableMappings.put(node.getListIterVar(), Expression.id(listIterVarTranslation));
        String string = indexVarTranslation = node.getIndexVar() == null ? null : "list_comp_" + node.getNodeId() + "_" + node.getIndexVar().name();
        if (node.getIndexVar() != null) {
            this.variableMappings.put(node.getIndexVar(), Expression.id(indexVarTranslation));
        }
        SoyType elementType = (listType = SoyTypes.tryRemoveNull(node.getListExpr().getType())).getKind() == SoyType.Kind.LIST ? ((ListType)listType).getElementType() : null;
        elementType = elementType == null ? UnknownType.getInstance() : elementType;
        JsDoc doc = node.getIndexVar() == null ? JsDoc.builder().addParam(listIterVarTranslation, this.jsTypeFor(elementType).typeExpr()).build() : JsDoc.builder().addParam(listIterVarTranslation, this.jsTypeFor(elementType).typeExpr()).addParam(indexVarTranslation, "number").build();
        Expression filterAndIndexBase = null;
        if (node.getFilterExpr() != null && node.getIndexVar() != null) {
            filterAndIndexBase = JsRuntime.SOY_FILTER_AND_MAP.call(base, Expression.arrowFunction(doc, this.maybeCoerceToBoolean(node.getFilterExpr().getType(), (Expression)this.visit(node.getFilterExpr()), false)), Expression.arrowFunction(doc, (Expression)this.visit(node.getListItemTransformExpr())));
        }
        if (node.getFilterExpr() != null) {
            base = base.dotAccess("filter").call(Expression.arrowFunction(doc, this.maybeCoerceToBoolean(node.getFilterExpr().getType(), (Expression)this.visit(node.getFilterExpr()), false)));
        }
        if (node.getListItemTransformExpr().getKind() == ExprNode.Kind.VAR_REF_NODE && (transformNode = (VarRefNode)node.getListItemTransformExpr()).getName().equals(node.getListIterVar().refName())) {
            return base;
        }
        base = base.dotAccess("map").call(Expression.arrowFunction(doc, (Expression)this.visit(node.getListItemTransformExpr())));
        return filterAndIndexBase == null ? base : filterAndIndexBase;
    }

    @Override
    protected Expression visitRecordLiteralNode(RecordLiteralNode node) {
        LinkedHashMap<String, Expression> objLiteral = new LinkedHashMap<String, Expression>();
        for (int i = 0; i < node.numChildren(); ++i) {
            objLiteral.put(node.getKey(i).identifier(), (Expression)this.visit(node.getChild(i)));
        }
        return Expression.objectLiteral(objLiteral);
    }

    @Override
    protected Expression visitMapLiteralNode(MapLiteralNode node) {
        Expression map = Expression.constructMap();
        if (node.getType() != MapType.EMPTY_MAP) {
            map = map.castAs(JsType.forJsSrc(node.getType()).typeExpr());
        }
        for (int i = 0; i < node.numChildren(); i += 2) {
            ExprNode keyNode = node.getChild(i);
            Expression key = JsRuntime.SOY_CHECK_NOT_NULL.call(this.genMapKeyCode(keyNode));
            Expression value = (Expression)this.visit(node.getChild(i + 1));
            map = map.dotAccess("set").call(key, value);
        }
        return map;
    }

    private Expression genMapKeyCode(ExprNode keyNode) {
        return (Expression)this.visit(keyNode);
    }

    @Override
    protected Expression visitVarRefNode(VarRefNode node) {
        Expression translation = this.variableMappings.maybeGet(node.getName());
        if (translation != null) {
            return translation;
        }
        return this.genCodeForParamAccess(node.getNameWithoutLeadingDollar(), node.getDefnDecl());
    }

    @Override
    protected Expression visitDataAccessNode(DataAccessNode node) {
        Preconditions.checkArgument((!node.isNullSafe() ? 1 : 0) != 0);
        return this.accumulateDataAccess(node).result(this.codeGenerator);
    }

    @Override
    protected Expression visitNullSafeAccessNode(NullSafeAccessNode nullSafeAccessNode) {
        NullSafeAccumulator accumulator = new NullSafeAccumulator((Expression)this.visit(nullSafeAccessNode.getBase()));
        ExprNode dataAccess = nullSafeAccessNode.getDataAccess();
        while (dataAccess.getKind() == ExprNode.Kind.NULL_SAFE_ACCESS_NODE) {
            NullSafeAccessNode nullSafe = (NullSafeAccessNode)dataAccess;
            accumulator = this.accumulateNullSafeDataAccess((DataAccessNode)nullSafe.getBase(), accumulator, false);
            dataAccess = nullSafe.getDataAccess();
        }
        return this.accumulateNullSafeDataAccessTail((ExprNode.AccessChainComponentNode)dataAccess, accumulator).result(this.codeGenerator);
    }

    protected Expression sanitizedContentToProtoConverterFunction(Descriptors.Descriptor messageType) {
        return (Expression)JsRuntime.JS_TO_PROTO_PACK_FN.get((Object)messageType.getFullName());
    }

    private NullSafeAccumulator accumulateNullSafeDataAccessTail(ExprNode.AccessChainComponentNode dataAccess, NullSafeAccumulator accumulator) {
        boolean foundAssertNonNull = false;
        if (dataAccess.getKind() == ExprNode.Kind.ASSERT_NON_NULL_OP_NODE) {
            OperatorNodes.AssertNonNullOpNode assertNonNull = (OperatorNodes.AssertNonNullOpNode)dataAccess;
            dataAccess = (ExprNode.AccessChainComponentNode)assertNonNull.getChild(0);
            foundAssertNonNull = true;
        }
        return this.accumulateNullSafeDataAccess((DataAccessNode)dataAccess, accumulator, foundAssertNonNull);
    }

    private NullSafeAccumulator accumulateNullSafeDataAccess(DataAccessNode dataAccessNode, NullSafeAccumulator accumulator, boolean assertNonNull) {
        Preconditions.checkArgument((!dataAccessNode.isNullSafe() ? 1 : 0) != 0);
        boolean accessChain = false;
        if (dataAccessNode.getBaseExprChild() instanceof DataAccessNode) {
            accumulator = this.accumulateNullSafeDataAccess((DataAccessNode)dataAccessNode.getBaseExprChild(), accumulator, false);
            accessChain = true;
        }
        return this.accumulateDataAccess(dataAccessNode, accumulator, !accessChain, assertNonNull);
    }

    private NullSafeAccumulator accumulateDataAccess(DataAccessNode dataAccessNode) {
        Preconditions.checkArgument((!dataAccessNode.isNullSafe() ? 1 : 0) != 0);
        NullSafeAccumulator accumulator = dataAccessNode.getBaseExprChild() instanceof DataAccessNode ? this.accumulateDataAccess((DataAccessNode)dataAccessNode.getBaseExprChild()) : new NullSafeAccumulator((Expression)this.visit(dataAccessNode.getBaseExprChild()));
        return this.accumulateDataAccess(dataAccessNode, accumulator, false, false);
    }

    private NullSafeAccumulator accumulateDataAccess(DataAccessNode dataAccessNode, NullSafeAccumulator accumulator, boolean nullSafe, boolean assertNonNull) {
        switch (dataAccessNode.getKind()) {
            case FIELD_ACCESS_NODE: {
                FieldAccessNode fieldAccess = (FieldAccessNode)dataAccessNode;
                NullSafeAccumulator.FieldAccess access = this.genCodeForFieldAccess(fieldAccess.getBaseExprChild().getType(), fieldAccess.getAccessSourceLocation(), fieldAccess.getFieldName());
                return accumulator.dotAccess(access, nullSafe, assertNonNull);
            }
            case ITEM_ACCESS_NODE: {
                ItemAccessNode itemAccess = (ItemAccessNode)dataAccessNode;
                ExprNode keyNode = itemAccess.getKeyExprChild();
                SoyType baseType = itemAccess.getBaseExprChild().getType();
                return SoyTypes.isKindOrUnionOfKind(SoyTypes.removeNull(baseType), SoyType.Kind.MAP) ? accumulator.mapGetAccess(this.genMapKeyCode(keyNode), nullSafe, assertNonNull) : accumulator.bracketAccess(((Expression)this.visit(keyNode)).castAs("?"), nullSafe, assertNonNull);
            }
            case METHOD_CALL_NODE: {
                MethodCallNode methodCall = (MethodCallNode)dataAccessNode;
                return this.genCodeForMethodCall(accumulator, methodCall, nullSafe, assertNonNull);
            }
        }
        throw new AssertionError((Object)dataAccessNode.getKind());
    }

    private NullSafeAccumulator.FieldAccess genCodeForFieldAccess(SoyType baseType, SourceLocation sourceLocation, String fieldName) {
        Preconditions.checkNotNull((Object)baseType);
        if (baseType.getKind() == SoyType.Kind.UNION) {
            UnionType unionType = (UnionType)baseType;
            NullSafeAccumulator.FieldAccess fieldAccess = null;
            for (SoyType memberType : unionType.getMembers()) {
                if (memberType.getKind() == SoyType.Kind.NULL) continue;
                NullSafeAccumulator.FieldAccess fieldAccessForType = this.genCodeForFieldAccess(memberType, sourceLocation, fieldName);
                if (fieldAccess == null) {
                    fieldAccess = fieldAccessForType;
                    continue;
                }
                if (fieldAccess.equals(fieldAccessForType)) continue;
                this.errorReporter.report(sourceLocation, UNION_ACCESSOR_MISMATCH, fieldName, baseType);
            }
            return fieldAccess;
        }
        if (baseType.getKind() == SoyType.Kind.PROTO) {
            SoyProtoType protoType = (SoyProtoType)baseType;
            Descriptors.FieldDescriptor desc = protoType.getFieldDescriptor(fieldName);
            Preconditions.checkNotNull((Object)desc, (String)"Error in proto %s, field not found: %s", (Object)protoType.getDescriptor().getFullName(), (Object)fieldName);
            return NullSafeAccumulator.FieldAccess.protoCall(fieldName, desc);
        }
        return NullSafeAccumulator.FieldAccess.id(fieldName);
    }

    private NullSafeAccumulator genCodeForMethodCall(NullSafeAccumulator base, MethodCallNode methodCallNode, boolean nullSafe, boolean assertNonNull) {
        Preconditions.checkArgument((boolean)methodCallNode.isMethodResolved());
        SoyMethod soyMethod = methodCallNode.getSoyMethod();
        if (soyMethod instanceof BuiltinMethod) {
            BuiltinMethod builtinMethod = (BuiltinMethod)soyMethod;
            SoyType baseType = methodCallNode.getBaseType(nullSafe);
            switch (builtinMethod) {
                case GET_EXTENSION: {
                    String extName = BuiltinMethod.getProtoExtensionIdFromMethodCall(methodCallNode);
                    return base.dotAccess(NullSafeAccumulator.ProtoCall.getField(extName, ((SoyProtoType)baseType).getFieldDescriptor(extName)), nullSafe, assertNonNull);
                }
                case HAS_PROTO_FIELD: {
                    String fieldName = BuiltinMethod.getProtoFieldNameFromMethodCall(methodCallNode);
                    return base.dotAccess(NullSafeAccumulator.ProtoCall.hasField(fieldName, ((SoyProtoType)baseType).getFieldDescriptor(fieldName)), nullSafe, assertNonNull);
                }
                case BIND: {
                    return base.functionCall(nullSafe, assertNonNull, baseExpr -> this.genCodeForBind((Expression)baseExpr, (Expression)this.visit(methodCallNode.getParams().get(0)), baseType));
                }
            }
            throw new AssertionError(builtinMethod);
        }
        if (soyMethod instanceof SoySourceFunctionMethod) {
            SoySourceFunctionMethod sourceMethod = (SoySourceFunctionMethod)soyMethod;
            return base.functionCall(nullSafe, assertNonNull, baseExpr -> {
                ArrayList<Expression> args = new ArrayList<Expression>();
                args.add((Expression)baseExpr);
                methodCallNode.getParams().forEach(n -> args.add((Expression)this.visit((ExprNode)n)));
                return this.javascriptValueFactory.applyFunction(methodCallNode.getSourceLocation(), methodCallNode.getMethodName().identifier(), (SoyJavaScriptSourceFunction)sourceMethod.getImpl(), args, this.codeGenerator);
            });
        }
        throw new AssertionError(soyMethod.getClass());
    }

    protected Expression genCodeForBind(Expression template, Expression paramRecord, SoyType templateType) {
        return JsRuntime.BIND_TEMPLATE_PARAMS.call(template, paramRecord);
    }

    @Override
    protected Expression visitGlobalNode(GlobalNode node) {
        if (node.isResolved()) {
            return (Expression)this.visit(node.getValue());
        }
        return Expression.dottedIdNoRequire(node.getName());
    }

    @Override
    protected Expression visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
        List operands = this.visitChildren(node);
        Expression consequent = (Expression)operands.get(0);
        Expression alternate = (Expression)operands.get(1);
        if (!consequent.isCheap()) {
            consequent = this.codeGenerator.declarationBuilder().setRhs(consequent).build().ref();
        }
        return Expression.ifExpression(consequent.doubleNotEquals(Expression.LITERAL_NULL), consequent).setElse(alternate).build(this.codeGenerator);
    }

    @Override
    protected Expression visitAndOpNode(OperatorNodes.AndOpNode node) {
        Preconditions.checkArgument((node.numChildren() == 2 ? 1 : 0) != 0);
        ExprNode lhOperand = node.getChild(0);
        ExprNode rhOperand = node.getChild(1);
        Expression lhChunk = this.maybeCoerceToBoolean(lhOperand.getType(), (Expression)this.visit(lhOperand), true);
        Expression rhChunk = this.maybeCoerceToBoolean(rhOperand.getType(), (Expression)this.visit(rhOperand), true);
        return lhChunk.and(rhChunk, this.codeGenerator);
    }

    @Override
    protected Expression visitOrOpNode(OperatorNodes.OrOpNode node) {
        Preconditions.checkArgument((node.numChildren() == 2 ? 1 : 0) != 0);
        ExprNode lhOperand = node.getChild(0);
        ExprNode rhOperand = node.getChild(1);
        Expression lhChunk = this.maybeCoerceToBoolean(lhOperand.getType(), (Expression)this.visit(lhOperand), true);
        Expression rhChunk = this.maybeCoerceToBoolean(rhOperand.getType(), (Expression)this.visit(rhOperand), true);
        return lhChunk.or(rhChunk, this.codeGenerator);
    }

    @Override
    protected Expression visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        Preconditions.checkArgument((node.numChildren() == 3 ? 1 : 0) != 0);
        return this.codeGenerator.conditionalExpression(this.maybeCoerceToBoolean(node.getChild(0).getType(), (Expression)this.visit(node.getChild(0)), false), (Expression)this.visit(node.getChild(1)), (Expression)this.visit(node.getChild(2)));
    }

    @Override
    protected Expression visitNotOpNode(OperatorNodes.NotOpNode node) {
        Preconditions.checkArgument((node.numChildren() == 1 ? 1 : 0) != 0);
        ExprNode operand = node.getChild(0);
        return Expression.operation(node.getOperator(), Arrays.asList(this.maybeCoerceToBoolean(operand.getType(), (Expression)this.visit(operand), false)));
    }

    protected Expression maybeCoerceToBoolean(SoyType type, Expression chunk, boolean force) {
        if (force && type.getKind() != SoyType.Kind.BOOL) {
            return JsRuntime.SOY_COERCE_TO_BOOLEAN.call(chunk);
        }
        return chunk;
    }

    @Override
    protected Expression visitOperatorNode(ExprNode.OperatorNode node) {
        return Expression.operation(node.getOperator(), this.visitChildren(node));
    }

    private Expression visitEqualNodeHelper(ExprNode.OperatorNode node) {
        for (ExprNode c : node.getChildren()) {
            SoyType type = c.getType();
            if ((SoyTypes.isNumericPrimitive(type) || type.getKind() == SoyType.Kind.BOOL) && type.getKind() != SoyType.Kind.UNKNOWN && type.getKind() != SoyType.Kind.ANY) continue;
            return JsRuntime.SOY_EQUALS.call(this.visitChildren(node));
        }
        return Expression.operation(Operator.EQUAL, this.visitChildren(node));
    }

    @Override
    protected Expression visitEqualOpNode(OperatorNodes.EqualOpNode node) {
        return this.visitEqualNodeHelper(node);
    }

    @Override
    protected Expression visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
        return Expression.not(this.visitEqualNodeHelper(node));
    }

    @Override
    protected Expression visitAssertNonNullOpNode(OperatorNodes.AssertNonNullOpNode node) {
        return this.assertNonNull(node.getChild(0));
    }

    protected Expression visitProtoInitFunction(FunctionNode node) {
        SoyProtoType type = (SoyProtoType)node.getType();
        Expression proto = Expression.construct(JsRuntime.protoConstructor(type), new Expression[0]);
        for (int i = 0; i < node.numChildren(); ++i) {
            String fieldName = node.getParamName(i).identifier();
            Descriptors.FieldDescriptor fieldDesc = type.getFieldDescriptor(fieldName);
            Expression fieldValue = (Expression)this.visit(node.getChild(i));
            if (ProtoUtils.isSanitizedContentField(fieldDesc)) {
                Expression sanitizedContentPackFn = this.sanitizedContentToProtoConverterFunction(fieldDesc.getMessageType());
                Expression expression = fieldValue = fieldDesc.isRepeated() ? JsRuntime.GOOG_ARRAY_MAP.call(fieldValue, sanitizedContentPackFn) : sanitizedContentPackFn.call(fieldValue);
            }
            if (fieldDesc.getType() == Descriptors.FieldDescriptor.Type.ENUM && !fieldDesc.isRepeated()) {
                fieldValue = fieldValue.castAs((fieldDesc.getFile().getSyntax() == Descriptors.FileDescriptor.Syntax.PROTO3 ? "!" : "?") + ProtoUtils.calculateJsEnumName(fieldDesc.getEnumType()));
            }
            if (fieldDesc.isExtension()) {
                Expression extInfo = JsRuntime.extensionField(fieldDesc);
                proto = proto.dotAccess("setExtension").call(extInfo, fieldValue);
                continue;
            }
            if (fieldDesc.isMapField()) {
                String getFn = "get" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName);
                Expression protoVar = this.codeGenerator.declarationBuilder().setRhs(proto).build().ref();
                if (ProtoUtils.isSanitizedContentMap(fieldDesc)) {
                    Expression sanitizedContentPackFn = this.sanitizedContentToProtoConverterFunction(ProtoUtils.getMapValueMessageType(fieldDesc));
                    fieldValue = JsRuntime.SOY_NEWMAPS_TRANSFORM_VALUES.call(fieldValue, sanitizedContentPackFn);
                }
                proto = JsRuntime.SOY_MAP_POPULATE.call(protoVar, protoVar.dotAccess(getFn).call(new Expression[0]).castAs("!soy.map.Map<?,?>"), fieldValue.castAs("!soy.map.Map<?,?>"));
                continue;
            }
            String setFn = "set" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName);
            proto = proto.dotAccess(setFn).call(fieldValue);
        }
        return proto;
    }

    @Override
    protected Expression visitFunctionNode(FunctionNode node) {
        Object soyFunction = node.getSoyFunction();
        if (soyFunction instanceof BuiltinFunction) {
            switch ((BuiltinFunction)soyFunction) {
                case IS_PARAM_SET: {
                    return this.visitIsSetFunction(node);
                }
                case IS_FIRST: {
                    return this.visitIsFirstFunction(node);
                }
                case IS_LAST: {
                    return this.visitIsLastFunction(node);
                }
                case INDEX: {
                    return this.visitIndexFunction(node);
                }
                case CHECK_NOT_NULL: {
                    return this.visitCheckNotNullFunction(node);
                }
                case CSS: {
                    return this.visitCssFunction(node);
                }
                case XID: {
                    return this.visitXidFunction(node);
                }
                case SOY_SERVER_KEY: {
                    return this.visitSoyServerKeyFunction(node);
                }
                case PROTO_INIT: {
                    return this.visitProtoInitFunction(node);
                }
                case UNKNOWN_JS_GLOBAL: {
                    return this.visitUnknownJsGlobal(node);
                }
                case IS_PRIMARY_MSG_IN_USE: {
                    return this.visitIsPrimaryMsgInUseFunction(node);
                }
                case TO_FLOAT: {
                    return (Expression)this.visit(node.getChild(0));
                }
                case DEBUG_SOY_TEMPLATE_INFO: {
                    return JsRuntime.GOOG_DEBUG.and(JsRuntime.SOY_DEBUG_SOY_TEMPLATE_INFO, this.codeGenerator);
                }
                case VE_DATA: {
                    return this.visitVeDataFunction(node);
                }
                case LEGACY_DYNAMIC_TAG: 
                case REMAINDER: 
                case MSG_WITH_ID: 
                case TEMPLATE: {
                    throw new AssertionError();
                }
            }
            throw new AssertionError();
        }
        if (soyFunction instanceof LoggingFunction) {
            return Expression.stringLiteral(((LoggingFunction)soyFunction).getPlaceholder());
        }
        if (soyFunction instanceof SoyJavaScriptSourceFunction) {
            return this.javascriptValueFactory.applyFunction(node.getSourceLocation(), node.getStaticFunctionName(), (SoyJavaScriptSourceFunction)soyFunction, this.visitChildren(node), this.codeGenerator);
        }
        if (!(soyFunction instanceof SoyJsSrcFunction)) {
            this.errorReporter.report(node.getSourceLocation(), SOY_JS_SRC_FUNCTION_NOT_FOUND, node.getStaticFunctionName(), soyFunction == null ? "missing implementation" : soyFunction.getClass().getName());
            soyFunction = TranslateExprNodeVisitor.getUnknownFunction(node.getStaticFunctionName(), node.numChildren());
        }
        return SoyJsPluginUtils.applySoyFunction((SoyJsSrcFunction)soyFunction, this.visitChildren(node), node.getSourceLocation(), this.errorReporter);
    }

    protected JsType jsTypeFor(SoyType type) {
        return JsType.forJsSrcStrict(type);
    }

    private Expression visitCheckNotNullFunction(FunctionNode node) {
        return this.assertNonNull(node.getChild(0));
    }

    private Expression assertNonNull(ExprNode expr) {
        return JsRuntime.SOY_CHECK_NOT_NULL.call((Expression)this.visit(expr)).castAs(this.jsTypeFor(SoyTypes.tryRemoveNull(expr.getType())).typeExpr());
    }

    private Expression visitIsFirstFunction(FunctionNode node) {
        String varName = ((VarRefNode)node.getChild(0)).getName();
        return this.variableMappings.get(varName + "__isFirst");
    }

    private Expression visitIsSetFunction(FunctionNode node) {
        Expression expression = (Expression)this.visit(node.getChild(0));
        return expression.tripleNotEquals(Expression.LITERAL_UNDEFINED);
    }

    private Expression visitIsLastFunction(FunctionNode node) {
        String varName = ((VarRefNode)node.getChild(0)).getName();
        return this.variableMappings.get(varName + "__isLast");
    }

    private Expression visitIndexFunction(FunctionNode node) {
        String varName = ((VarRefNode)node.getChild(0)).getName();
        return this.variableMappings.get(varName + "__index");
    }

    private Expression visitCssFunction(FunctionNode node) {
        return JsRuntime.GOOG_GET_CSS_NAME.call(this.visitChildren(node));
    }

    private Expression visitXidFunction(FunctionNode node) {
        return JsRuntime.XID.call(this.visitChildren(node));
    }

    private Expression visitSoyServerKeyFunction(FunctionNode node) {
        return JsRuntime.SERIALIZE_KEY.call((Expression)this.visit(node.getChildren().get(0)));
    }

    private Expression visitIsPrimaryMsgInUseFunction(FunctionNode node) {
        MsgFallbackGroupNode msgNode = (MsgFallbackGroupNode)((LetContentNode)((LocalVar)((VarRefNode)node.getChild(0)).getDefnDecl()).declaringNode()).getChild(0);
        return this.variableMappings.isPrimaryMsgInUse(msgNode);
    }

    private Expression visitUnknownJsGlobal(FunctionNode node) {
        StringNode expr = (StringNode)node.getChild(0);
        return this.codeGenerator.declarationBuilder().setRhs(Expression.dottedIdNoRequire(expr.getValue())).setJsDoc(JsDoc.builder().addParameterizedAnnotation("suppress", "missingRequire").build()).build().ref();
    }

    private Expression visitVeDataFunction(FunctionNode node) {
        return Expression.construct(JsRuntime.SOY_VISUAL_ELEMENT_DATA, (Expression)this.visit(node.getChild(0)), (Expression)this.visit(node.getChild(1)));
    }

    private static SoyJsSrcFunction getUnknownFunction(final String name, final int argSize) {
        return new SoyJsSrcFunction(){

            @Override
            public JsExpr computeForJsSrc(List<JsExpr> args) {
                ArrayList<String> argStrings = new ArrayList<String>();
                for (JsExpr arg : args) {
                    argStrings.add(arg.getText());
                }
                return new JsExpr(name + "(" + COMMA_JOINER.join(argStrings) + ")", Integer.MAX_VALUE);
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Set<Integer> getValidArgsSizes() {
                return ImmutableSet.of((Object)argSize);
            }
        };
    }

    @Override
    protected Expression visitVeLiteralNode(VeLiteralNode node) {
        ValidatedLoggingConfig.ValidatedLoggableElement element = node.getLoggableElement();
        Expression metadata = element.hasMetadata() ? GoogRequire.create(element.getJsPackage()).googModuleGet().dotAccess(element.getClassName()).dotAccess(element.getGeneratedVeMetadataMethodName()).call(new Expression[0]) : Expression.LITERAL_UNDEFINED;
        return Expression.ifExpression(JsRuntime.GOOG_DEBUG, Expression.construct(JsRuntime.SOY_VISUAL_ELEMENT, Expression.number(node.getId()), metadata, Expression.stringLiteral(node.getName().identifier()))).setElse(Expression.construct(JsRuntime.SOY_VISUAL_ELEMENT, Expression.number(node.getId()), metadata)).build(this.codeGenerator);
    }

    @Override
    protected Expression visitTemplateLiteralNode(TemplateLiteralNode node) {
        Expression templateLiteral = Expression.dottedIdNoRequire(this.templateAliases.get(node.getResolvedName()));
        return node.isSynthetic() ? templateLiteral : JsRuntime.MARK_TEMPLATE.call(templateLiteral, Expression.stringLiteral(node.getResolvedName()));
    }
}

