/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgBundleImpl;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ExtractMsgsVisitor
extends AbstractSoyNodeVisitor<SoyMsgBundle> {
    private static final SoyErrorKind MISMATCHED_MSG_ATTRIBUTE = SoyErrorKind.of("This message has the same id as a message @{0}, but they have inconsistent ''{1}'' properties.", new SoyErrorKind.StyleAllowance[0]);
    private List<SoyMsg> msgs;
    private String currentTemplate;
    private final ErrorReporter errorReporter;
    private static final Pattern MESSAGE_ATTRIBUTE_PATTERN = Pattern.compile("\\[[^\\[\\]]*\\]");

    public ExtractMsgsVisitor(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public SoyMsgBundle exec(SoyNode node) {
        Preconditions.checkArgument((node instanceof SoyFileSetNode || node instanceof SoyFileNode ? 1 : 0) != 0);
        this.msgs = Lists.newArrayList();
        this.visit(node);
        Collections.sort(this.msgs, Comparator.comparing(m -> ((SoyMsg.SourceLocationAndTemplate)Iterables.getOnlyElement(m.getSourceLocations())).sourceLocation()));
        return new SoyMsgBundleImpl(null, this.msgs, this::merge);
    }

    private Optional<SoyMsg> merge(SoyMsg m1, SoyMsg m2) {
        if (m1.isHidden() != m2.isHidden()) {
            this.errorReporter.report(m1.getExampleSourceLocation(), MISMATCHED_MSG_ATTRIBUTE, m2.getExampleSourceLocation(), "hidden");
            return Optional.empty();
        }
        return Optional.of(m1.toBuilder().setHasFallback(m1.hasFallback() && m2.hasFallback()).setDesc(m1.getDesc() + ExtractMsgsVisitor.extractAttributes(m2)).addAllSourceLocations((Iterable<SoyMsg.SourceLocationAndTemplate>)m2.getSourceLocations()).build());
    }

    private static String extractAttributes(SoyMsg msg) {
        StringBuilder attributes = new StringBuilder();
        Matcher matcher = MESSAGE_ATTRIBUTE_PATTERN.matcher(msg.getDesc());
        while (matcher.find()) {
            attributes.append(matcher.group());
        }
        return attributes.toString();
    }

    @Override
    protected void visitMsgNode(MsgNode node) {
        MsgUtils.MsgPartsAndIds msgPartsAndIds = MsgUtils.buildMsgPartsAndComputeMsgIdForDualFormat(node);
        SoyMsg.Builder builder = SoyMsg.builder().setId(msgPartsAndIds.id);
        if (node.getMeaning() != null) {
            builder.setMeaning(node.getMeaning());
        }
        node.getAlternateId().ifPresent(builder::setAlternateId);
        SoyMsg msg = builder.setDesc(node.getDesc()).setIsHidden(node.isHidden()).setContentType(node.getContentType()).addSourceLocation(node.getSourceLocation(), this.currentTemplate).setIsPlrselMsg(node.isPlrselMsg()).setParts((Iterable<? extends SoyMsgPart>)msgPartsAndIds.parts).setHasFallback(node.getParent().numChildren() == 2 && node.getParent().getChildIndex(node) == 0).build();
        this.msgs.add(msg);
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        if (node instanceof TemplateDelegateNode) {
            this.currentTemplate = ((TemplateDelegateNode)node).getDelTemplateName();
        }
        this.currentTemplate = node.getTemplateName();
        super.visitTemplateNode(node);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }
}

