/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parseinfo;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;

@Immutable
public class SoyTemplateInfo {
    private final String name;
    private final ImmutableMap<String, ParamRequisiteness> paramMap;

    protected SoyTemplateInfo(String name, ImmutableMap<String, ParamRequisiteness> paramMap) {
        this.name = name;
        Preconditions.checkArgument((name.lastIndexOf(46) > 0 ? 1 : 0) != 0);
        this.paramMap = paramMap;
    }

    public String getName() {
        return this.name;
    }

    public String getPartialName() {
        String name = this.getName();
        return name.substring(name.lastIndexOf(46));
    }

    public final int getParamCount() {
        return this.paramMap.size();
    }

    public final ImmutableSet<String> getParamNames() {
        return this.paramMap.keySet();
    }

    public final ImmutableSet<String> getRequiredParamNames() {
        return (ImmutableSet)this.paramMap.keySet().stream().filter(n -> this.paramMap.get(n) == ParamRequisiteness.REQUIRED).collect(ImmutableSet.toImmutableSet());
    }

    public final boolean hasParam(String paramName) {
        return this.getParamNames().contains((Object)paramName);
    }

    public final ParamRequisiteness getParamRequisiteness(String paramName) {
        ParamRequisiteness pr = (ParamRequisiteness)((Object)this.paramMap.get((Object)paramName));
        Preconditions.checkArgument((pr != null ? 1 : 0) != 0);
        return pr;
    }

    public static enum ParamRequisiteness {
        REQUIRED,
        OPTIONAL;

    }
}

