/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.parsepasses.contextautoesc.ContextualAutoescaper;
import com.google.template.soy.parsepasses.contextautoesc.Inferences;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.SoyFileNode;

final class AutoescaperPass
implements CompilerFileSetPass {
    private final ContextualAutoescaper autoescaper;
    private final ErrorReporter errorReporter;
    private final boolean autoescaperEnabled;

    AutoescaperPass(ErrorReporter errorReporter, ImmutableList<? extends SoyPrintDirective> printDirectives, boolean autoescaperEnabled) {
        this.errorReporter = errorReporter;
        this.autoescaper = new ContextualAutoescaper(errorReporter, printDirectives);
        this.autoescaperEnabled = autoescaperEnabled;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        if (this.errorReporter.hasErrors()) {
            return CompilerFileSetPass.Result.STOP;
        }
        Inferences inferences = this.autoescaper.annotate(sourceFiles);
        if (inferences == null) {
            return CompilerFileSetPass.Result.STOP;
        }
        if (this.autoescaperEnabled) {
            this.autoescaper.rewrite(sourceFiles, idGenerator, inferences);
        }
        if (this.errorReporter.hasErrors()) {
            return CompilerFileSetPass.Result.STOP;
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }
}

