/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.PluginResolver;
import com.google.template.soy.passes.ResolvePluginsPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;

@RunAfter(value={ResolvePluginsPass.class})
final class CheckAllFunctionsResolvedPass
implements CompilerFilePass {
    private final PluginResolver resolver;

    CheckAllFunctionsResolvedPass(PluginResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        SoyTreeUtils.allNodesOfType(file, FunctionNode.class).filter(fct -> !fct.isResolved()).forEach(this.resolver::reportUnresolved);
    }
}

