/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.ast.GenericTypeNode;
import com.google.template.soy.types.ast.NamedTypeNode;
import com.google.template.soy.types.ast.RecordTypeNode;
import com.google.template.soy.types.ast.TemplateTypeNode;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.TypeNodeVisitor;
import com.google.template.soy.types.ast.UnionTypeNode;

final class CheckDeclaredTypesPass
implements CompilerFilePass {
    private static final SoyErrorKind VE_BAD_DATA_TYPE = SoyErrorKind.of("Illegal VE metadata type ''{0}''. The metadata must be a proto.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    CheckDeclaredTypesPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (TemplateNode templateNode : file.getTemplates()) {
            for (TemplateParam param : templateNode.getAllParams()) {
                TypeNode type = param.getTypeNode();
                if (type == null) continue;
                type.accept(new MapKeyTypeChecker());
            }
        }
    }

    private final class MapKeyTypeChecker
    implements TypeNodeVisitor<Void> {
        private MapKeyTypeChecker() {
        }

        @Override
        public Void visit(NamedTypeNode node) {
            return null;
        }

        @Override
        public Void visit(GenericTypeNode node) {
            if (!node.isTypeResolved()) {
                return null;
            }
            switch (node.getResolvedType().getKind()) {
                case MAP: {
                    Preconditions.checkArgument((node.arguments().size() == 2 ? 1 : 0) != 0);
                    TypeNode key = (TypeNode)node.arguments().get(0);
                    if (!MapType.isAllowedKeyType(key.getResolvedType())) {
                        CheckDeclaredTypesPass.this.errorReporter.report(key.sourceLocation(), MapType.BAD_MAP_KEY_TYPE, key.getResolvedType());
                    }
                    ((TypeNode)node.arguments().get(1)).accept(this);
                    break;
                }
                case LIST: {
                    Preconditions.checkArgument((node.arguments().size() == 1 ? 1 : 0) != 0);
                    ((TypeNode)node.arguments().get(0)).accept(this);
                    break;
                }
                case LEGACY_OBJECT_MAP: {
                    Preconditions.checkArgument((node.arguments().size() == 2 ? 1 : 0) != 0);
                    for (TypeNode child : node.arguments()) {
                        child.accept(this);
                    }
                    break;
                }
                case VE: {
                    Preconditions.checkArgument((node.arguments().size() == 1 ? 1 : 0) != 0);
                    TypeNode dataType = (TypeNode)node.arguments().get(0);
                    if (dataType.getResolvedType().getKind() != SoyType.Kind.PROTO && dataType.getResolvedType().getKind() != SoyType.Kind.NULL) {
                        CheckDeclaredTypesPass.this.errorReporter.report(dataType.sourceLocation(), VE_BAD_DATA_TYPE, dataType.getResolvedType());
                    }
                    ((TypeNode)node.arguments().get(0)).accept(this);
                    break;
                }
                case ELEMENT: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected generic type: " + (Object)((Object)node.getResolvedType().getKind())));
                }
            }
            return null;
        }

        @Override
        public Void visit(UnionTypeNode node) {
            for (TypeNode child : node.candidates()) {
                child.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(RecordTypeNode node) {
            for (RecordTypeNode.Property property : node.properties()) {
                property.type().accept(this);
            }
            return null;
        }

        @Override
        public Void visit(TemplateTypeNode node) {
            for (TemplateTypeNode.Parameter parameter : node.parameters()) {
                parameter.type().accept(this);
            }
            node.returnType().accept(this);
            return null;
        }
    }
}

