/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.IndirectParamsCalculator;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;

public final class CheckTemplateHeaderVarsPass
implements CompilerFileSetPass {
    private static final SoyErrorKind INJECTED_PARAM_COLLISION = SoyErrorKind.of("Injected param ''{0}'' conflicts with indirect param with the same name in template ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    CheckTemplateHeaderVarsPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        for (SoyFileNode fileNode : sourceFiles) {
            for (TemplateNode templateNode : fileNode.getTemplates()) {
                this.checkTemplate(templateNode, new IndirectParamsCalculator(fileNode.getTemplateRegistry()));
            }
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void checkTemplate(TemplateNode node, IndirectParamsCalculator calculator) {
        IndirectParamsCalculator.IndirectParamsInfo ipi = calculator.calculateIndirectParams(node);
        for (TemplateHeaderVarDefn param : node.getInjectedParams()) {
            for (TemplateMetadata template : ipi.paramKeyToCalleesMultimap.get((Object)param.name())) {
                this.errorReporter.report(param.getSourceLocation(), INJECTED_PARAM_COLLISION, param.name(), template.getTemplateName());
            }
        }
    }
}

