/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.defn.TemplateStateVar;

final class DesugarStateNodesPass
implements CompilerFileSetPass {
    DesugarStateNodesPass() {
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator, TemplateRegistry registry) {
        for (SoyFileNode file : sourceFiles) {
            this.run(file, idGenerator);
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (TemplateNode template : file.getTemplates()) {
            if (!(template instanceof TemplateElementNode)) continue;
            TemplateElementNode soyElement = (TemplateElementNode)template;
            ArrayListMultimap map = ArrayListMultimap.create();
            for (VarRefNode ref : SoyTreeUtils.getAllNodesOfType(template, VarRefNode.class)) {
                if (ref.getDefnDecl().kind() != VarDefn.Kind.STATE) continue;
                map.put((Object)ref.getDefnDecl(), (Object)ref);
            }
            int stateVarIndex = 0;
            for (TemplateStateVar stateVar : soyElement.getStateVars()) {
                LetValueNode node = new LetValueNode(nodeIdGen.genId(), stateVar.nameLocation(), "$" + stateVar.name(), stateVar.nameLocation(), stateVar.defaultValue().getRoot());
                node.getVar().setType(stateVar.type());
                soyElement.addChild(stateVarIndex, node);
                ++stateVarIndex;
                for (VarRefNode ref : map.get((Object)stateVar)) {
                    ref.setDefn(node.getVar());
                }
            }
            soyElement.clearStateVars();
        }
    }
}

