/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.TemplateContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.parsepasses.contextautoesc.ContextualAutoescaper;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.ElementAttributePass;
import com.google.template.soy.passes.ResolveExpressionTypesCrossTemplatePass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.passes.SoyElementCompositionPass;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.AttrParam;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import java.util.Optional;
import java.util.stream.Stream;

@RunAfter(value={ResolveExpressionTypesCrossTemplatePass.class})
public final class ElementCheckCrossTemplatePass
implements CompilerFileSetPass {
    private static final SoyErrorKind BAD_CONTENT_IN_ROOT_ELM = SoyErrorKind.of("Only attributes are allowed inside the root element.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind WRONG_ATTRIBUTE_TYPE = SoyErrorKind.of("Expected type of attribute to be {0}.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    ElementCheckCrossTemplatePass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        sourceFiles.stream().flatMap(file -> SoyTreeUtils.allNodesOfType(file, TemplateNode.class)).filter(t -> t.getTemplateContentKind() instanceof TemplateContentKind.ElementContentKind).forEach(this::processTemplate);
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void validateAttributeTypes(HtmlOpenTagNode node, Stream<AttrParam> attributes) {
        attributes.forEach(attr -> {
            Optional<SoyType> maybeType = ContextualAutoescaper.getRequiredTypeFromAttributeName(attr.getAttrName(), node);
            if (!maybeType.isPresent()) {
                return;
            }
            SoyType type = maybeType.get();
            if (!type.isAssignableFromStrict(SoyTypes.removeNull(attr.type()))) {
                this.errorReporter.report(attr.getSourceLocation(), WRONG_ATTRIBUTE_TYPE, type.toString());
            }
        });
    }

    private void processTemplate(TemplateNode template) {
        Optional<HtmlOpenTagNode> elmOpen = ElementAttributePass.getElementOpen(template);
        if (!elmOpen.isPresent()) {
            return;
        }
        HtmlOpenTagNode openTagNode = elmOpen.get();
        this.validateAttributeTypes(openTagNode, template.getHeaderParams().stream().filter(p -> p instanceof AttrParam).map(AttrParam.class::cast));
        openTagNode.getChildren().stream().filter(p -> p.getKind() == SoyNode.Kind.HTML_ATTRIBUTE_NODE).map(HtmlAttributeNode.class::cast).filter(attr -> attr.getStaticKey() == null).forEach(attr -> {
            if (!this.filterNonAttribute((HtmlAttributeNode)attr)) {
                this.errorReporter.report(attr.getSourceLocation(), BAD_CONTENT_IN_ROOT_ELM, new Object[0]);
            }
        });
    }

    private boolean filterNonAttribute(HtmlAttributeNode attr) {
        return SoyElementCompositionPass.isOkToPutInElement(attr);
    }
}

