/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;

final class EnforceExperimentalFeaturesPass
implements CompilerFilePass {
    private static final SoyErrorKind NON_NULL_ASSERTION_BANNED = SoyErrorKind.of("Non-null assertion operator not supported, use the ''checkNotNull'' function instead.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CONSTANT_NOT_GA = SoyErrorKind.of("'{'const'}' is not available for general use.", new SoyErrorKind.StyleAllowance[0]);
    private final ImmutableSet<String> features;
    private final ErrorReporter reporter;

    EnforceExperimentalFeaturesPass(ImmutableSet<String> features, ErrorReporter reporter) {
        this.features = (ImmutableSet)Preconditions.checkNotNull(features);
        this.reporter = (ErrorReporter)Preconditions.checkNotNull((Object)reporter);
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        if (!this.features.contains((Object)"enableNonNullAssertionOperator")) {
            for (OperatorNodes.AssertNonNullOpNode assertNonNullOpNode : SoyTreeUtils.getAllNodesOfType(file, OperatorNodes.AssertNonNullOpNode.class)) {
                this.reporter.report(assertNonNullOpNode.getSourceLocation(), NON_NULL_ASSERTION_BANNED, new Object[0]);
            }
        }
        if (!this.features.contains((Object)"enableConstants")) {
            SoyTreeUtils.allNodesOfType(file, ConstNode.class).forEach(closeTagNode -> this.reporter.report(closeTagNode.getSourceLocation(), CONSTANT_NOT_GA, new Object[0]));
        }
    }
}

