/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateDelegateNodeBuilder;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.ImportedVar;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class LocalVariablesNodeVisitor {
    private final NodeVisitor nodeVisitor;

    public LocalVariablesNodeVisitor(NodeVisitor nodeVisitor) {
        this.nodeVisitor = nodeVisitor;
    }

    public void exec(SoyFileNode file) {
        this.nodeVisitor.exec(file);
    }

    private static boolean shouldSkipError(VarDefn defn, VarDefn preexisting) {
        return defn.kind() == VarDefn.Kind.TEMPLATE && preexisting.kind() == VarDefn.Kind.TEMPLATE && TemplateDelegateNodeBuilder.isDeltemplateTemplateName(defn.name()) && TemplateDelegateNodeBuilder.isDeltemplateTemplateName(preexisting.name());
    }

    private static String englishName(VarDefn varDefn) {
        switch (varDefn.kind()) {
            case PARAM: {
                return "Parameter";
            }
            case STATE: {
                return "State parameter";
            }
            case IMPORT_VAR: {
                return "Imported symbol";
            }
            case LOCAL_VAR: 
            case COMPREHENSION_VAR: {
                return "Local variable";
            }
            case TEMPLATE: {
                return "Template name";
            }
            case UNDECLARED: 
            case CONST: {
                return "Symbol";
            }
        }
        throw new AssertionError((Object)varDefn.kind());
    }

    static abstract class ExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        private LocalVariables localVariables;

        ExprVisitor() {
        }

        public final Void exec(ExprNode node, LocalVariables localVariables) {
            this.localVariables = localVariables;
            this.exec(node);
            this.localVariables = null;
            return null;
        }

        protected LocalVariables getLocalVariables() {
            return (LocalVariables)Preconditions.checkNotNull((Object)this.localVariables);
        }

        @Override
        public Void exec(ExprNode node) {
            Preconditions.checkArgument((boolean)(node instanceof ExprRootNode));
            this.visit(node);
            return null;
        }

        @Override
        protected void visitExprRootNode(ExprRootNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)node);
            }
        }

        @Override
        protected void visitListComprehensionNode(ListComprehensionNode node) {
            this.visit(node.getListExpr());
            this.localVariables.enterScope();
            this.localVariables.define(node.getListIterVar(), node);
            if (node.getIndexVar() != null) {
                this.localVariables.define(node.getIndexVar(), node);
            }
            if (node.getFilterExpr() != null) {
                this.visit(node.getFilterExpr());
            }
            this.visit(node.getListItemTransformExpr());
            this.localVariables.exitScope();
        }
    }

    static abstract class NodeVisitor
    extends AbstractSoyNodeVisitor<Void> {
        private LocalVariables localVariables;

        NodeVisitor() {
        }

        protected abstract ExprVisitor getExprVisitor();

        @Nullable
        protected ErrorReporter getErrorReporter() {
            return null;
        }

        protected LocalVariables getLocalVariables() {
            return (LocalVariables)Preconditions.checkNotNull((Object)this.localVariables);
        }

        @Override
        protected void visitSoyFileNode(SoyFileNode node) {
            this.localVariables = new LocalVariables();
            this.localVariables.errorReporter = this.getErrorReporter();
            this.localVariables.enterScope();
            for (TemplateNode template : node.getTemplates()) {
                this.localVariables.define(template.asVarDefn(), template);
            }
            super.visitSoyFileNode(node);
            this.localVariables.exitScope();
            this.localVariables = null;
        }

        @Override
        protected void visitImportNode(ImportNode node) {
            super.visitImportNode(node);
            for (ImportedVar var : node.getIdentifiers()) {
                this.localVariables.define(var, node);
            }
        }

        @Override
        protected void visitConstNode(ConstNode node) {
            super.visitConstNode(node);
            this.localVariables.define(node.getVar(), node);
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            this.localVariables.enterScope();
            for (TemplateHeaderVarDefn param : node.getHeaderParams()) {
                if (param.defaultValue() != null) {
                    this.getExprVisitor().exec(param.defaultValue(), this.localVariables);
                }
                this.localVariables.define(param, node);
            }
            super.visitTemplateNode(node);
            this.localVariables.exitScope();
        }

        @Override
        protected void visitPrintNode(PrintNode node) {
            this.visitSoyNode(node);
        }

        @Override
        protected void visitLetValueNode(LetValueNode node) {
            this.visitExpressions(node);
            this.localVariables.define(node.getVar(), node);
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            this.localVariables.enterScope();
            this.visitChildren(node);
            this.localVariables.exitScope();
            this.localVariables.define(node.getVar(), node);
        }

        @Override
        protected void visitForNonemptyNode(ForNonemptyNode node) {
            this.visitExpressions(node.getParent());
            this.localVariables.enterScope();
            this.localVariables.define(node.getVar(), node);
            if (node.getIndexVar() != null) {
                this.localVariables.define(node.getIndexVar(), node);
            }
            this.visitChildren(node);
            this.localVariables.exitScope();
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ExprHolderNode) {
                this.visitExpressions((SoyNode.ExprHolderNode)node);
            }
            if (node instanceof SoyNode.ParentSoyNode) {
                if (node instanceof SoyNode.BlockNode) {
                    this.localVariables.enterScope();
                    this.visitChildren((SoyNode.BlockNode)node);
                    this.localVariables.exitScope();
                } else {
                    this.visitChildren((SoyNode.ParentSoyNode)node);
                }
            }
        }

        private void visitExpressions(SoyNode.ExprHolderNode node) {
            for (ExprRootNode expr : node.getExprList()) {
                this.getExprVisitor().exec(expr, this.localVariables);
            }
        }
    }

    static final class LocalVariables {
        private static final SoyErrorKind VARIABLE_ALREADY_DEFINED = SoyErrorKind.of("{0} ''{1}'' conflicts with symbol defined at {2}.", new SoyErrorKind.StyleAllowance[0]);
        private ErrorReporter errorReporter;
        private final Deque<Map<String, VarDefn>> currentScope = new ArrayDeque<Map<String, VarDefn>>();

        LocalVariables() {
        }

        void enterScope() {
            this.currentScope.push(new LinkedHashMap());
        }

        void exitScope() {
            this.currentScope.pop();
        }

        VarDefn lookup(String name) {
            return this.currentScope.stream().map(scope -> (VarDefn)scope.get(name)).filter(Objects::nonNull).findFirst().orElse(null);
        }

        private boolean check(VarDefn defn, Node definingNode) {
            String refName = defn.refName();
            VarDefn preexisting = this.lookup(refName);
            if (preexisting != null) {
                if (this.errorReporter != null && !LocalVariablesNodeVisitor.shouldSkipError(defn, preexisting)) {
                    SourceLocation defnSourceLocation = defn.nameLocation() == null ? definingNode.getSourceLocation() : defn.nameLocation();
                    this.errorReporter.report(defnSourceLocation, VARIABLE_ALREADY_DEFINED, LocalVariablesNodeVisitor.englishName(defn), refName, preexisting.nameLocation().toLineColumnString());
                }
                return false;
            }
            return true;
        }

        void define(VarDefn defn, Node definingNode) {
            if (this.check(defn, definingNode)) {
                this.currentScope.peek().put(defn.refName(), defn);
            }
        }

        List<String> allVariablesInScope() {
            return this.currentScope.stream().flatMap(map -> map.keySet().stream()).collect(Collectors.toList());
        }
    }
}

