/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.TriState;
import com.google.template.soy.conformance.ValidatedConformanceConfig;
import com.google.template.soy.css.CssRegistry;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.logging.ValidatedLoggingConfig;
import com.google.template.soy.passes.AddDebugAttributesPass;
import com.google.template.soy.passes.AutoescaperPass;
import com.google.template.soy.passes.BasicHtmlValidationPass;
import com.google.template.soy.passes.CalculateMsgSubstitutionInfoPass;
import com.google.template.soy.passes.CallAnnotationPass;
import com.google.template.soy.passes.CheckAllFunctionsResolvedPass;
import com.google.template.soy.passes.CheckBadContextualUsagePass;
import com.google.template.soy.passes.CheckDeclaredTypesPass;
import com.google.template.soy.passes.CheckDelegatesPass;
import com.google.template.soy.passes.CheckEscapingSanityFilePass;
import com.google.template.soy.passes.CheckGlobalsPass;
import com.google.template.soy.passes.CheckNonEmptyMsgNodesPass;
import com.google.template.soy.passes.CheckTemplateCallsPass;
import com.google.template.soy.passes.CheckTemplateHeaderVarsPass;
import com.google.template.soy.passes.CheckTemplateVisibilityPass;
import com.google.template.soy.passes.CombineConsecutiveRawTextNodesPass;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.CompilerFilePassToFileSetPassShim;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.CompilerPass;
import com.google.template.soy.passes.ContentSecurityPolicyNonceInjectionPass;
import com.google.template.soy.passes.DesugarGroupNodesPass;
import com.google.template.soy.passes.DesugarHtmlNodesPass;
import com.google.template.soy.passes.DesugarStateNodesPass;
import com.google.template.soy.passes.ElementAttributePass;
import com.google.template.soy.passes.ElementCheckCrossTemplatePass;
import com.google.template.soy.passes.EnforceExperimentalFeaturesPass;
import com.google.template.soy.passes.GetExtensionRewriteParamPass;
import com.google.template.soy.passes.InsertMsgPlaceholderNodesPass;
import com.google.template.soy.passes.KeyCommandPass;
import com.google.template.soy.passes.MsgWithIdFunctionPass;
import com.google.template.soy.passes.NullSafeAccessPass;
import com.google.template.soy.passes.OptimizationPass;
import com.google.template.soy.passes.PluginResolver;
import com.google.template.soy.passes.ResolveDottedImportsPass;
import com.google.template.soy.passes.ResolveExpressionTypesCrossTemplatePass;
import com.google.template.soy.passes.ResolveExpressionTypesPass;
import com.google.template.soy.passes.ResolveNamesPass;
import com.google.template.soy.passes.ResolvePackageRelativeCssNamesPass;
import com.google.template.soy.passes.ResolvePluginsPass;
import com.google.template.soy.passes.ResolveProtoImportsPass;
import com.google.template.soy.passes.ResolveTemplateFunctionsPass;
import com.google.template.soy.passes.ResolveTemplateImportsPass;
import com.google.template.soy.passes.ResolveTemplateNamesPass;
import com.google.template.soy.passes.ResolveTemplateParamTypesPass;
import com.google.template.soy.passes.RestoreCompilerChecksPass;
import com.google.template.soy.passes.RestoreGlobalsPass;
import com.google.template.soy.passes.RewriteDirectivesCallableAsFunctionsPass;
import com.google.template.soy.passes.RewriteGenderMsgsPass;
import com.google.template.soy.passes.RewriteGlobalsPass;
import com.google.template.soy.passes.RewriteRemaindersPass;
import com.google.template.soy.passes.SimplifyAssertNonNullPass;
import com.google.template.soy.passes.SoyConformancePass;
import com.google.template.soy.passes.SoyElementCompositionPass;
import com.google.template.soy.passes.SoyElementPass;
import com.google.template.soy.passes.StrictDepsPass;
import com.google.template.soy.passes.StrictHtmlValidationPass;
import com.google.template.soy.passes.UnknownJsGlobalPass;
import com.google.template.soy.passes.ValidateAliasesPass;
import com.google.template.soy.passes.ValidateSkipNodesPass;
import com.google.template.soy.passes.ValidateVariantExpressionsPass;
import com.google.template.soy.passes.VeLogRewritePass;
import com.google.template.soy.passes.VeLogValidationPass;
import com.google.template.soy.passes.VeRewritePass;
import com.google.template.soy.passes.XidPass;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateNameRegistry;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class PassManager {
    @VisibleForTesting
    final ImmutableList<CompilerFilePass> parsePasses;
    @VisibleForTesting
    final ImmutableList<CompilerFileSetPass> partialTemplateRegistryPasses;
    @VisibleForTesting
    final ImmutableList<CompilerFileSetPass> crossTemplateCheckingPasses;

    private PassManager(ImmutableList<CompilerFilePass> parsePasses, ImmutableList<CompilerFileSetPass> partialTemplateRegistryPasses, ImmutableList<CompilerFileSetPass> crossTemplateCheckingPasses) {
        this.parsePasses = parsePasses;
        this.partialTemplateRegistryPasses = partialTemplateRegistryPasses;
        this.crossTemplateCheckingPasses = crossTemplateCheckingPasses;
        this.checkOrdering();
    }

    public void runParsePasses(SoyFileNode file, IdGenerator nodeIdGen) {
        for (CompilerFilePass pass : this.parsePasses) {
            pass.run(file, nodeIdGen);
        }
    }

    public CompilerFileSetPass.Result runPartialTemplateRegistryPasses(SoyFileSetNode soyTree, TemplateNameRegistry templateNameRegistry, TemplateRegistry partialTemplateRegistryWithJustDeps) {
        ImmutableList sourceFiles = ImmutableList.copyOf(soyTree.getChildren());
        IdGenerator idGenerator = soyTree.getNodeIdGenerator();
        for (CompilerFileSetPass pass : this.partialTemplateRegistryPasses) {
            CompilerFileSetPass.Result result = pass.run((ImmutableList<SoyFileNode>)sourceFiles, idGenerator, templateNameRegistry, partialTemplateRegistryWithJustDeps);
            if (result.equals((Object)CompilerFileSetPass.Result.CONTINUE)) continue;
            return result;
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    public void runWholeFilesetPasses(SoyFileSetNode soyTree, TemplateRegistry templateRegistry) {
        CompilerFileSetPass pass;
        CompilerFileSetPass.Result result;
        ImmutableList sourceFiles = ImmutableList.copyOf(soyTree.getChildren());
        IdGenerator idGenerator = soyTree.getNodeIdGenerator();
        UnmodifiableIterator unmodifiableIterator = this.crossTemplateCheckingPasses.iterator();
        while (unmodifiableIterator.hasNext() && (result = (pass = (CompilerFileSetPass)unmodifiableIterator.next()).run((ImmutableList<SoyFileNode>)sourceFiles, idGenerator, templateRegistry)) != CompilerFileSetPass.Result.STOP) {
        }
    }

    private void checkOrdering() {
        LinkedHashSet<Class<? extends CompilerPass>> executed = new LinkedHashSet<Class<? extends CompilerPass>>();
        for (CompilerPass pass : Iterables.concat(this.parsePasses, this.partialTemplateRegistryPasses, this.crossTemplateCheckingPasses)) {
            PassManager.prepareToRun(executed, pass);
        }
    }

    private static void prepareToRun(Set<Class<? extends CompilerPass>> executed, CompilerPass pass) {
        ImmutableList<Class<? extends CompilerPass>> shouldHaveAlreadyRun = pass.runAfter();
        if (!executed.containsAll((Collection<?>)shouldHaveAlreadyRun)) {
            throw new IllegalStateException("Attempted to executed pass " + pass.name() + " but its dependencies (" + shouldHaveAlreadyRun.stream().filter(dep -> !executed.contains(dep)).map(Class::getSimpleName).collect(Collectors.joining(", ")) + ") haven't run yet.\n Passes executed so far: " + executed.stream().map(Class::getSimpleName).collect(Collectors.joining(", ")));
        }
        ImmutableList<Class<? extends CompilerPass>> shouldNotHaveAlreadyRun = pass.runBefore();
        Sets.SetView ranButShouldntHave = Sets.intersection(new HashSet<Class<? extends CompilerPass>>((Collection<Class<? extends CompilerPass>>)shouldNotHaveAlreadyRun), executed);
        if (!ranButShouldntHave.isEmpty()) {
            throw new IllegalStateException("Attempted to execute pass " + pass.name() + " but it should always run before (" + ranButShouldntHave.stream().map(Class::getSimpleName).collect(Collectors.joining(", ")) + ").\n Passes executed so far: " + executed.stream().map(Class::getSimpleName).collect(Collectors.joining(", ")));
        }
        executed.add(PassManager.getPassClass(pass));
    }

    private static ImmutableList<CompilerFilePass> createParsePasses(ErrorReporter reporter) {
        return ImmutableList.of((Object)new DesugarGroupNodesPass(), (Object)new BasicHtmlValidationPass(reporter), (Object)new InsertMsgPlaceholderNodesPass(reporter));
    }

    private static Class<? extends CompilerPass> getPassClass(CompilerPass pass) {
        return pass instanceof CompilerFilePassToFileSetPassShim ? ((CompilerFilePassToFileSetPassShim)pass).getDelegateClass() : pass.getClass();
    }

    public static final class Builder {
        private SoyTypeRegistry registry;
        private PluginResolver pluginResolver;
        private ImmutableList<? extends SoyPrintDirective> soyPrintDirectives;
        private ErrorReporter errorReporter;
        private SoyGeneralOptions options;
        private Optional<CssRegistry> cssRegistry;
        private boolean allowUnknownGlobals;
        private boolean allowUnknownJsGlobals;
        private boolean disableAllTypeChecking;
        private boolean desugarHtmlAndStateNodes = true;
        private boolean optimize = true;
        private ValidatedConformanceConfig conformanceConfig = ValidatedConformanceConfig.EMPTY;
        private ValidatedLoggingConfig loggingConfig = ValidatedLoggingConfig.EMPTY;
        private boolean insertEscapingDirectives = true;
        private boolean addHtmlAttributesForDebugging = true;
        private AstRewrites astRewrites = AstRewrites.ALL;
        private final Map<Class<? extends CompilerPass>, PassContinuationRule> passContinuationRegistry = Maps.newHashMap();
        private boolean building;

        public Builder setErrorReporter(ErrorReporter errorReporter) {
            this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
            return this;
        }

        public Builder setSoyPrintDirectives(ImmutableList<? extends SoyPrintDirective> printDirectives) {
            this.soyPrintDirectives = (ImmutableList)Preconditions.checkNotNull(printDirectives);
            return this;
        }

        public Builder setTypeRegistry(SoyTypeRegistry registry) {
            this.registry = (SoyTypeRegistry)Preconditions.checkNotNull((Object)registry);
            return this;
        }

        public Builder setCssRegistry(Optional<CssRegistry> registry) {
            this.cssRegistry = registry;
            return this;
        }

        public Builder setPluginResolver(PluginResolver pluginResolver) {
            this.pluginResolver = pluginResolver;
            return this;
        }

        public Builder setGeneralOptions(SoyGeneralOptions options) {
            this.options = options;
            return this;
        }

        public Builder disableAllTypeChecking() {
            this.disableAllTypeChecking = true;
            return this;
        }

        public Builder allowUnknownGlobals() {
            this.allowUnknownGlobals = true;
            return this;
        }

        public Builder astRewrites(AstRewrites astRewrites) {
            this.astRewrites = astRewrites;
            return this;
        }

        public Builder allowUnknownJsGlobals() {
            this.allowUnknownJsGlobals = true;
            return this;
        }

        public Builder desugarHtmlAndStateNodes(boolean desugarHtmlAndStateNodes) {
            this.desugarHtmlAndStateNodes = desugarHtmlAndStateNodes;
            return this;
        }

        public Builder optimize(boolean optimize) {
            this.optimize = optimize;
            return this;
        }

        public Builder addHtmlAttributesForDebugging(boolean addHtmlAttributesForDebugging) {
            this.addHtmlAttributesForDebugging = addHtmlAttributesForDebugging;
            return this;
        }

        public Builder setConformanceConfig(ValidatedConformanceConfig conformanceConfig) {
            this.conformanceConfig = (ValidatedConformanceConfig)Preconditions.checkNotNull((Object)conformanceConfig);
            return this;
        }

        public Builder setLoggingConfig(ValidatedLoggingConfig loggingConfig) {
            this.loggingConfig = (ValidatedLoggingConfig)Preconditions.checkNotNull((Object)loggingConfig);
            return this;
        }

        public Builder insertEscapingDirectives(boolean insertEscapingDirectives) {
            this.insertEscapingDirectives = insertEscapingDirectives;
            return this;
        }

        public Builder addPassContinuationRule(Class<? extends CompilerPass> pass, PassContinuationRule rule) {
            Preconditions.checkNotNull((Object)((Object)rule));
            this.passContinuationRegistry.put(pass, rule);
            return this;
        }

        public PassManager build() {
            this.building = true;
            ImmutableList.Builder partialTemplateRegistryPassesBuilder = ImmutableList.builder();
            if (this.astRewrites.atLeast(AstRewrites.ALL)) {
                this.addPass((CompilerPass)new ContentSecurityPolicyNonceInjectionPass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
                this.addPass((CompilerPass)new CheckEscapingSanityFilePass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            }
            this.addPass((CompilerPass)new ResolveProtoImportsPass(this.registry, this.options, this.errorReporter, this.disableAllTypeChecking), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            this.addPass(new ResolveTemplateImportsPass(this.options, this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            this.addPass((CompilerPass)new RestoreGlobalsPass(), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            this.addPass((CompilerPass)new RestoreCompilerChecksPass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            this.addPass((CompilerPass)new ResolveTemplateParamTypesPass(this.errorReporter, this.disableAllTypeChecking), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            this.addPass((CompilerPass)new ResolvePluginsPass(this.pluginResolver), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            if (this.astRewrites.atLeast(AstRewrites.ALL)) {
                this.addPass((CompilerPass)new RewriteDirectivesCallableAsFunctionsPass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
                this.addPass((CompilerPass)new RewriteRemaindersPass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
                this.addPass((CompilerPass)new RewriteGenderMsgsPass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
                this.addPass((CompilerPass)new CalculateMsgSubstitutionInfoPass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            }
            this.addPass((CompilerPass)new CheckNonEmptyMsgNodesPass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            this.addPass((CompilerPass)new VeRewritePass(), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            this.addPass((CompilerPass)new RewriteGlobalsPass(this.options.getCompileTimeGlobals()), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            this.addPass((CompilerPass)new XidPass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            this.addPass((CompilerPass)new UnknownJsGlobalPass(this.allowUnknownJsGlobals, this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            this.addPass((CompilerPass)new ResolveNamesPass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            this.addPass((CompilerPass)new ResolveDottedImportsPass(this.errorReporter, this.registry), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            if (this.astRewrites.atLeast(AstRewrites.KYTHE)) {
                this.addPass((CompilerPass)new ResolveTemplateFunctionsPass(), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            }
            this.addPass(new ResolveTemplateNamesPass(this.errorReporter, this.options.getRequireTemplateImports()), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            if (!this.disableAllTypeChecking) {
                this.addPass((CompilerPass)new ValidateVariantExpressionsPass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            }
            if (this.astRewrites.atLeast(AstRewrites.ALL)) {
                this.addPass((CompilerPass)new MsgWithIdFunctionPass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            }
            this.addPass((CompilerPass)new StrictHtmlValidationPass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            this.addPass(new SoyElementPass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            if (this.addHtmlAttributesForDebugging) {
                this.addPass((CompilerPass)new AddDebugAttributesPass(), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            }
            this.addPass((CompilerPass)new CheckAllFunctionsResolvedPass(this.pluginResolver), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            if (!this.disableAllTypeChecking) {
                this.addPass((CompilerPass)new CheckDeclaredTypesPass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
                this.addPass((CompilerPass)new NullSafeAccessPass(), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
                this.addPass((CompilerPass)new ResolveExpressionTypesPass(this.errorReporter, this.loggingConfig, this.pluginResolver), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
                this.addPass((CompilerPass)new SimplifyAssertNonNullPass(), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
                this.addPass((CompilerPass)new VeLogRewritePass(), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
                if (!this.allowUnknownGlobals) {
                    this.addPass((CompilerPass)new GetExtensionRewriteParamPass(), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
                }
            }
            this.addPass((CompilerPass)new ResolvePackageRelativeCssNamesPass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            if (!this.allowUnknownGlobals) {
                this.addPass((CompilerPass)new CheckGlobalsPass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            }
            this.addPass((CompilerPass)new ValidateAliasesPass(this.errorReporter, this.options, this.loggingConfig), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            this.addPass((CompilerPass)new KeyCommandPass(this.errorReporter, this.disableAllTypeChecking), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            this.addPass((CompilerPass)new ValidateSkipNodesPass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            if (!this.disableAllTypeChecking) {
                this.addPass(new VeLogValidationPass(this.errorReporter, this.registry), (ImmutableList.Builder<CompilerFileSetPass>)partialTemplateRegistryPassesBuilder);
            }
            ImmutableList.Builder crossTemplateCheckingPassesBuilder = ImmutableList.builder();
            if (this.astRewrites.atLeast(AstRewrites.ALL)) {
                this.addPass(new ElementAttributePass(this.errorReporter, this.pluginResolver), (ImmutableList.Builder<CompilerFileSetPass>)crossTemplateCheckingPassesBuilder);
            }
            this.addPass((CompilerPass)new SoyConformancePass(this.conformanceConfig, this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)crossTemplateCheckingPassesBuilder);
            if (!this.disableAllTypeChecking) {
                this.addPass(new ResolveExpressionTypesCrossTemplatePass(this.registry, this.errorReporter, this.astRewrites.atLeast(AstRewrites.ALL)), (ImmutableList.Builder<CompilerFileSetPass>)crossTemplateCheckingPassesBuilder);
            }
            this.addPass(new CheckTemplateHeaderVarsPass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)crossTemplateCheckingPassesBuilder);
            if (!this.disableAllTypeChecking) {
                this.addPass((CompilerPass)new EnforceExperimentalFeaturesPass(this.options.getExperimentalFeatures(), this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)crossTemplateCheckingPassesBuilder);
                this.addPass(new CheckTemplateCallsPass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)crossTemplateCheckingPassesBuilder);
                this.addPass(new ElementCheckCrossTemplatePass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)crossTemplateCheckingPassesBuilder);
                if (this.astRewrites.atLeast(AstRewrites.ALL)) {
                    this.addPass(new SoyElementCompositionPass(this.errorReporter, this.soyPrintDirectives), (ImmutableList.Builder<CompilerFileSetPass>)crossTemplateCheckingPassesBuilder);
                }
            }
            this.addPass(new CallAnnotationPass(), (ImmutableList.Builder<CompilerFileSetPass>)crossTemplateCheckingPassesBuilder);
            this.addPass(new CheckTemplateVisibilityPass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)crossTemplateCheckingPassesBuilder);
            this.addPass(new CheckDelegatesPass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)crossTemplateCheckingPassesBuilder);
            if (this.options.allowExternalCalls() == TriState.DISABLED) {
                this.addPass(new StrictDepsPass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)crossTemplateCheckingPassesBuilder);
            }
            this.addPass((CompilerPass)new CombineConsecutiveRawTextNodesPass(), (ImmutableList.Builder<CompilerFileSetPass>)crossTemplateCheckingPassesBuilder);
            this.addPass(new AutoescaperPass(this.errorReporter, this.soyPrintDirectives, this.insertEscapingDirectives), (ImmutableList.Builder<CompilerFileSetPass>)crossTemplateCheckingPassesBuilder);
            if (!this.disableAllTypeChecking && this.insertEscapingDirectives) {
                this.addPass(new CheckBadContextualUsagePass(this.errorReporter), (ImmutableList.Builder<CompilerFileSetPass>)crossTemplateCheckingPassesBuilder);
            }
            if (this.desugarHtmlAndStateNodes) {
                this.addPass(new DesugarHtmlNodesPass(), (ImmutableList.Builder<CompilerFileSetPass>)crossTemplateCheckingPassesBuilder);
                this.addPass(new DesugarStateNodesPass(), (ImmutableList.Builder<CompilerFileSetPass>)crossTemplateCheckingPassesBuilder);
            }
            if (this.optimize) {
                this.addPass(new OptimizationPass(), (ImmutableList.Builder<CompilerFileSetPass>)crossTemplateCheckingPassesBuilder);
            }
            this.addPass((CompilerPass)new CombineConsecutiveRawTextNodesPass(), (ImmutableList.Builder<CompilerFileSetPass>)crossTemplateCheckingPassesBuilder);
            this.building = false;
            if (!this.passContinuationRegistry.isEmpty()) {
                throw new IllegalStateException("The following continuation rules don't match any pass: " + this.passContinuationRegistry);
            }
            return new PassManager(PassManager.createParsePasses(this.errorReporter), partialTemplateRegistryPassesBuilder.build(), crossTemplateCheckingPassesBuilder.build());
        }

        void addPass(CompilerPass pass, ImmutableList.Builder<CompilerFileSetPass> passBuilder) {
            if (pass instanceof CompilerFileSetPass) {
                this.addPassInternal((CompilerFileSetPass)pass, passBuilder);
                return;
            }
            this.addPassInternal(CompilerFilePassToFileSetPassShim.filePassAsFileSetPass((CompilerFilePass)pass), passBuilder);
        }

        void addPass(CompilerFilePass pass, ImmutableList.Builder<CompilerFilePass> passBuilder) {
            this.addPassInternal(pass, passBuilder);
        }

        private <T extends CompilerPass> void addPassInternal(T pass, ImmutableList.Builder<T> builder) {
            Class passClass = PassManager.getPassClass(pass);
            PassContinuationRule rule = this.passContinuationRegistry.remove(passClass);
            if (!this.building) {
                return;
            }
            if (rule == null) {
                builder.add(pass);
                return;
            }
            switch (rule) {
                case STOP_AFTER_PASS: {
                    builder.add(pass);
                }
                case STOP_BEFORE_PASS: {
                    this.building = false;
                    return;
                }
            }
            throw new AssertionError((Object)("unhandled rule: " + (Object)((Object)rule)));
        }
    }

    public static enum AstRewrites {
        NONE,
        KYTHE,
        TRICORDER,
        ALL;


        boolean atLeast(AstRewrites v) {
            return this.ordinal() >= v.ordinal();
        }
    }

    public static enum PassContinuationRule {
        STOP_BEFORE_PASS,
        STOP_AFTER_PASS;

    }
}

