/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.plugin.java.internal.PluginAnalyzer;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyDeprecated;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.SoyMethodSignature;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.shared.restricted.SoySourceFunctionMethod;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public final class PluginResolver {
    private static final SoyErrorKind UNKNOWN_PLUGIN = SoyErrorKind.of("Unknown {0} ''{1}''.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind DEPRECATED_PLUGIN = SoyErrorKind.of("{0} is deprecated: {1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION, SoyErrorKind.StyleAllowance.NO_CAPS);
    private static final SoyErrorKind INCORRECT_NUM_ARGS = SoyErrorKind.of("{0} called with {1} arguments (expected {2}).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PLUGIN_NAME_NOT_ALLOWED = SoyErrorKind.of("Plugin ''{0}'' is named ''{1}'' which is not allowed because it conflicts with Soy''s {1}() literal syntax.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DIFFERENT_IMPLS_REGISTERED = SoyErrorKind.of("Plugin named ''{0}'' has two different implementations registered: ''{1}'' and ''{2}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MISSING_FUNCTION_SIGNATURE = SoyErrorKind.of("Plugin class ''{0}'' has no @SoyFunctionSignature annotation. Classes implementing SoySourceFunction must be annotated with @SoyFunctionSignature.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MISSING_METHOD_SIGNATURE = SoyErrorKind.of("Plugin class ''{0}'' has no @SoyMethodSignature annotation. Method classes implementing SoySourceFunction must be annotated with @SoyMethodSignature.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DIFFERENT_METHOD_IMPLS_REGISTERED = SoyErrorKind.of("Plugin method named ''{0}'' with base type ''{1}'' has two different implementations registered: ''{2}'' and ''{3}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MULTIPLE_PLUGIN_INSTANCES = SoyErrorKind.of("Plugin class ''{0}'' uses callInstanceMethod for methods on multiple classes {1}. SoyJavaSourceFunctions must only use a single class for callInstanceMethod.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind FUNCTION_PRINT_DIRECTIVE_COLLISION = SoyErrorKind.of("Plugin ''{0}'' named ''{1}'' collides with print directive ''{2}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind FUNCTION_NOT_CALLABLE = SoyErrorKind.of("Function ''{0}'' cannot be called as a print directive.", new SoyErrorKind.StyleAllowance[0]);
    private static final ImmutableSet<String> COLLISION_WHITELIST = ImmutableSet.builder().build();
    private static final SoySourceFunction ERROR_PLACEHOLDER_FUNCTION = new SoySourceFunction(){};
    private final Mode mode;
    private final ImmutableMap<String, SoyPrintDirective> printDirectives;
    private final ImmutableMap<String, Object> functions;
    private final ImmutableMap<String, ImmutableMap<String, SoySourceFunction>> methods;
    private final ErrorReporter reporter;

    public static PluginResolver nullResolver(Mode mode, ErrorReporter reporter) {
        return new PluginResolver(mode, (List<SoyPrintDirective>)ImmutableList.of(), (List<SoyFunction>)ImmutableList.of(), (List<SoySourceFunction>)ImmutableList.of(), (List<SoySourceFunction>)ImmutableList.of(), reporter);
    }

    public PluginResolver(Mode mode, List<SoyPrintDirective> soyPrintDirectives, List<SoyFunction> soyFunctions, List<SoySourceFunction> sourceFunctions, List<SoySourceFunction> soyMethods, ErrorReporter reporter) {
        Object old;
        this.mode = (Mode)((Object)Preconditions.checkNotNull((Object)((Object)mode)));
        this.reporter = (ErrorReporter)Preconditions.checkNotNull((Object)reporter);
        LinkedHashMap mergedFunctions = Maps.newLinkedHashMapWithExpectedSize((int)(soyFunctions.size() + sourceFunctions.size()));
        for (Object function : Iterables.concat(soyFunctions, sourceFunctions)) {
            String name;
            if (function instanceof SoySourceFunction) {
                ImmutableSet<String> instances;
                SoyFunctionSignature sig = function.getClass().getAnnotation(SoyFunctionSignature.class);
                if (sig == null) {
                    reporter.report(SourceLocation.UNKNOWN, MISSING_FUNCTION_SIGNATURE, function.getClass().getName());
                    continue;
                }
                name = sig.name();
                if (function instanceof SoyJavaSourceFunction && (instances = PluginAnalyzer.analyze((SoyJavaSourceFunction)function).pluginInstanceNames()).size() > 1) {
                    reporter.report(SourceLocation.UNKNOWN, MULTIPLE_PLUGIN_INSTANCES, function.getClass().getName(), instances);
                }
            } else {
                SoyFunction legacyFunction = (SoyFunction)function;
                name = legacyFunction.getName();
            }
            old = mergedFunctions.put(name, function);
            if (old != null) {
                reporter.report(SourceLocation.UNKNOWN, DIFFERENT_IMPLS_REGISTERED, name, old, function);
            }
            if (!BaseUtils.ILLEGAL_PLUGIN_NAMES.contains((Object)name)) continue;
            reporter.report(SourceLocation.UNKNOWN, PLUGIN_NAME_NOT_ALLOWED, function.getClass().getName(), name);
        }
        this.functions = ImmutableMap.copyOf((Map)mergedFunctions);
        LinkedHashMap indexedDirectives = Maps.newLinkedHashMapWithExpectedSize((int)soyPrintDirectives.size());
        for (SoyPrintDirective directive : soyPrintDirectives) {
            String functionName;
            old = indexedDirectives.put(directive.getName(), directive);
            if (old != null) {
                reporter.report(SourceLocation.UNKNOWN, DIFFERENT_IMPLS_REGISTERED, directive.getName(), directive, old);
            }
            if (BaseUtils.ILLEGAL_PLUGIN_NAMES.contains((Object)(functionName = PluginResolver.getFunctionNameEquivalentToPrintDirectiveName(directive.getName())))) {
                reporter.report(SourceLocation.UNKNOWN, PLUGIN_NAME_NOT_ALLOWED, directive.getClass().getName(), functionName);
            }
            if (COLLISION_WHITELIST.contains((Object)functionName) || !this.functions.containsKey((Object)functionName)) continue;
            reporter.report(SourceLocation.UNKNOWN, FUNCTION_PRINT_DIRECTIVE_COLLISION, this.functions.get((Object)functionName).getClass().getName(), functionName, directive.getClass().getName());
        }
        this.printDirectives = ImmutableMap.copyOf((Map)indexedDirectives);
        LinkedHashMap methods = Maps.newLinkedHashMapWithExpectedSize((int)soyMethods.size());
        for (SoySourceFunction method : soyMethods) {
            SoyMethodSignature sig = method.getClass().getAnnotation(SoyMethodSignature.class);
            if (sig == null) {
                reporter.report(SourceLocation.UNKNOWN, MISSING_METHOD_SIGNATURE, method.getClass().getName());
                continue;
            }
            String methodName = sig.name();
            String baseType = sig.baseType();
            Map baseTypeToSourceFnMap = methods.containsKey(methodName) ? (Map)methods.get(methodName) : new LinkedHashMap();
            SoySourceFunction old2 = baseTypeToSourceFnMap.put(sig.baseType(), method);
            if (old2 != null) {
                reporter.report(SourceLocation.UNKNOWN, DIFFERENT_METHOD_IMPLS_REGISTERED, methodName, baseType, old2.getClass().getCanonicalName(), method.getClass().getCanonicalName());
            }
            methods.put(methodName, baseTypeToSourceFnMap);
        }
        this.methods = (ImmutableMap)methods.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ImmutableMap.copyOf((Map)((Map)e.getValue()))));
    }

    public Mode getPluginResolutionMode() {
        return this.mode;
    }

    public SoyPrintDirective lookupPrintDirective(String name, int numArgs, SourceLocation location) {
        SoyPrintDirective soyPrintDirective = (SoyPrintDirective)this.printDirectives.get((Object)name);
        if (soyPrintDirective == null) {
            this.reportMissing(location, "print directive", name, (Set<String>)this.printDirectives.keySet());
            soyPrintDirective = PluginResolver.createPlaceholderPrintDirective(name, numArgs);
        }
        this.checkNumArgs("print directive", soyPrintDirective.getValidArgsSizes(), numArgs, location);
        this.warnIfDeprecated(name, soyPrintDirective, location);
        return soyPrintDirective;
    }

    Optional<SoySourceFunction> getFunctionCallableAsPrintDirective(String directiveName, SourceLocation sourceLocation) {
        SoyFunctionSignature signature;
        if (this.printDirectives.containsKey((Object)directiveName)) {
            return Optional.empty();
        }
        String functionName = PluginResolver.getFunctionNameEquivalentToPrintDirectiveName(directiveName);
        if (COLLISION_WHITELIST.contains((Object)functionName)) {
            return Optional.empty();
        }
        Object function = this.functions.get((Object)functionName);
        if (function == null) {
            return Optional.empty();
        }
        if (function instanceof SoySourceFunction && (signature = function.getClass().getAnnotation(SoyFunctionSignature.class)).callableAsDeprecatedPrintDirective()) {
            return Optional.of((SoySourceFunction)function);
        }
        this.reporter.report(sourceLocation, FUNCTION_NOT_CALLABLE, functionName);
        return Optional.empty();
    }

    @Nullable
    public Object lookupSoyFunction(String name, int numArgs, SourceLocation location) {
        Object soyFunction = this.functions.get((Object)name);
        if (soyFunction == null) {
            return null;
        }
        Set<Integer> validArgsSize = PluginResolver.getValidArgsSizes(soyFunction);
        this.checkNumArgs("function", validArgsSize, numArgs, location);
        this.warnIfDeprecated(name, soyFunction, location);
        return soyFunction;
    }

    public ImmutableList<SoySourceFunction> lookupSoyMethods(String methodName) {
        ImmutableMap methodBaseTypeToFunctionMap = (ImmutableMap)this.methods.get((Object)methodName);
        if (methodBaseTypeToFunctionMap == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)methodBaseTypeToFunctionMap.values());
    }

    public ImmutableSet<String> getAllMethodNames() {
        return this.methods.keySet();
    }

    public void reportUnresolved(FunctionNode fct) {
        Preconditions.checkArgument((!fct.isResolved() ? 1 : 0) != 0);
        if (fct.hasStaticName()) {
            this.reportMissing(fct.getFunctionNameLocation(), "function", fct.getStaticFunctionName(), (Set<String>)this.functions.keySet());
        } else {
            this.reportMissing(fct.getNameExpr().getSourceLocation(), "function", fct.getNameExpr().toSourceString(), "");
        }
        fct.setSoyFunction(ERROR_PLACEHOLDER_FUNCTION);
    }

    private void reportMissing(SourceLocation location, String type, String name, Set<String> alternatives) {
        String didYouMean = SoyErrors.getDidYouMeanMessage(alternatives, name);
        this.reportMissing(location, type, name, didYouMean);
    }

    private void reportMissing(SourceLocation location, String type, String name, String didYouMean) {
        switch (this.mode) {
            case REQUIRE_DEFINITIONS: {
                this.reporter.report(location, UNKNOWN_PLUGIN, type, name, didYouMean);
                break;
            }
            case ALLOW_UNDEFINED_AND_WARN: {
                this.reporter.warn(location, UNKNOWN_PLUGIN, type, name, didYouMean);
                break;
            }
        }
    }

    private static Set<Integer> getValidArgsSizes(Object soyFunction) {
        if (soyFunction instanceof SoyFunction) {
            return ((SoyFunction)soyFunction).getValidArgsSizes();
        }
        SoyFunctionSignature signature = soyFunction.getClass().getAnnotation(SoyFunctionSignature.class);
        Preconditions.checkArgument((signature != null ? 1 : 0) != 0);
        return PluginResolver.getValidArgsSizes(signature.value());
    }

    static Set<Integer> getValidArgsSizes(Signature[] signatures) {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (Signature signature : signatures) {
            builder.add((Object)signature.parameterTypes().length);
        }
        return builder.build();
    }

    private void checkNumArgs(String pluginKind, Set<Integer> arities, int actualNumArgs, SourceLocation location) {
        if (!arities.contains(actualNumArgs)) {
            this.reporter.report(location, INCORRECT_NUM_ARGS, pluginKind, actualNumArgs, Joiner.on((String)" or ").join(arities));
        }
    }

    private void warnIfDeprecated(String name, Object plugin, SourceLocation location) {
        PluginResolver.warnIfDeprecated(this.reporter, name, plugin, location);
    }

    static void warnIfDeprecated(ErrorReporter reporter, String name, Object plugin, SourceLocation location) {
        SoyFunctionSignature sig;
        if (plugin instanceof SoySourceFunctionMethod) {
            SoySourceFunction function = ((SoySourceFunctionMethod)plugin).getImpl();
            if (PluginResolver.warnIfSoyDeprecated(reporter, name, function, location)) {
                return;
            }
            SoyMethodSignature sig2 = function.getClass().getAnnotation(SoyMethodSignature.class);
            if (sig2 != null && !sig2.deprecatedWarning().isEmpty()) {
                reporter.warn(location, DEPRECATED_PLUGIN, name, sig2.deprecatedWarning());
            }
            return;
        }
        if (PluginResolver.warnIfSoyDeprecated(reporter, name, plugin, location)) {
            return;
        }
        if (plugin instanceof SoySourceFunction && (sig = plugin.getClass().getAnnotation(SoyFunctionSignature.class)) != null && !sig.deprecatedWarning().isEmpty()) {
            reporter.warn(location, DEPRECATED_PLUGIN, name, sig.deprecatedWarning());
            return;
        }
    }

    private static boolean warnIfSoyDeprecated(ErrorReporter reporter, String name, Object anything, SourceLocation location) {
        SoyDeprecated deprecatedNotice = anything.getClass().getAnnotation(SoyDeprecated.class);
        if (deprecatedNotice == null) {
            return false;
        }
        reporter.warn(location, DEPRECATED_PLUGIN, name, deprecatedNotice.value());
        return true;
    }

    private static SoyPrintDirective createPlaceholderPrintDirective(final String name, int arity) {
        final ImmutableSet validArgSizes = ImmutableSet.of((Object)arity);
        return new SoyPrintDirective(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Set<Integer> getValidArgsSizes() {
                return validArgSizes;
            }
        };
    }

    static String getFunctionNameEquivalentToPrintDirectiveName(String printDirectiveName) {
        Preconditions.checkArgument((boolean)printDirectiveName.startsWith("|"), (String)"Expected print directive name '%s' to start with '|'", (Object)printDirectiveName);
        return printDirectiveName.substring(1);
    }

    public static enum Mode {
        ALLOW_UNDEFINED,
        ALLOW_UNDEFINED_AND_WARN,
        REQUIRE_DEFINITIONS;

    }
}

