/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.protobuf.Descriptors;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.CallableExprBuilder;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.ProtoEnumValueNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.ResolveExpressionTypesPass;
import com.google.template.soy.passes.ResolveNamesPass;
import com.google.template.soy.passes.ResolvePluginsPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.defn.ImportedVar;
import com.google.template.soy.types.ImportType;
import com.google.template.soy.types.ProtoEnumImportType;
import com.google.template.soy.types.ProtoImportType;
import com.google.template.soy.types.ProtoModuleImportType;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.TemplateImportType;
import com.google.template.soy.types.TemplateModuleImportType;
import com.google.template.soy.types.TypeInterner;
import com.google.template.soy.types.UnknownType;
import javax.annotation.Nullable;

@RunAfter(value={ResolveNamesPass.class})
@RunBefore(value={ResolveExpressionTypesPass.class})
public final class ResolveDottedImportsPass
implements CompilerFilePass {
    private static final SoyErrorKind NO_SUCH_NESTED_TYPE = SoyErrorKind.of("Nested type ''{0}'' does not exist on type {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ENUM_MEMBERSHIP_ERROR = SoyErrorKind.of("''{0}'' is not a member of enum ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;
    private final TypeInterner typeRegistry;

    public ResolveDottedImportsPass(ErrorReporter errorReporter, TypeInterner typeRegistry) {
        this.errorReporter = errorReporter;
        this.typeRegistry = typeRegistry;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        SoyTreeUtils.allNodesOfType(file, VarRefNode.class).filter(v -> {
            if (!v.hasType()) {
                return false;
            }
            return v.getDefnDecl().type() instanceof ImportType;
        }).forEach(v -> {
            while (v != null) {
                v = this.inlineNode((VarRefNode)v);
            }
        });
    }

    private VarRefNode inlineNode(VarRefNode v) {
        ExprNode.ParentExprNode parent = v.getParent();
        ExprNode inlined = null;
        if (parent.getKind() == ExprNode.Kind.FIELD_ACCESS_NODE) {
            SourceLocation fullLocation = v.getSourceLocation().extend(parent.getSourceLocation());
            inlined = this.resolveField(v, parent.getKind(), ((FieldAccessNode)parent).getFieldName(), fullLocation);
        } else if (parent.getKind() == ExprNode.Kind.METHOD_CALL_NODE && parent.getChildIndex(v) == 0) {
            SourceLocation fullLocation = v.getSourceLocation().extend(((MethodCallNode)parent).getMethodName().location());
            ExprNode target = this.resolveField(v, parent.getKind(), ((MethodCallNode)parent).getMethodName().identifier(), fullLocation);
            if (target == null) {
                return null;
            }
            FunctionNode function = CallableExprBuilder.builder((MethodCallNode)parent).setSourceLocation(v.getSourceLocation().extend(parent.getSourceLocation())).setTarget(null).setIdentifier(null).setFunctionExpr(target).buildFunction();
            ResolvePluginsPass.setSoyFunctionForNameExpr(function);
            inlined = function;
        }
        if (inlined != null) {
            parent.getParent().replaceChild(parent, inlined);
            if (inlined instanceof VarRefNode) {
                return (VarRefNode)inlined;
            }
        }
        return null;
    }

    @Nullable
    private ExprNode resolveField(VarRefNode refn, ExprNode.Kind kind, String fieldName, SourceLocation fullLocation) {
        TemplateModuleImportType moduleType;
        VarDefn defn = refn.getDefnDecl();
        SoyType type = defn.type();
        if (type.getKind() == SoyType.Kind.PROTO_ENUM_TYPE) {
            Descriptors.EnumDescriptor enumDescriptor = ((ProtoEnumImportType)type).getDescriptor();
            Descriptors.EnumValueDescriptor val = enumDescriptor.findValueByName(fieldName);
            Identifier id = Identifier.create(refn.getName() + "." + fieldName, fullLocation);
            SoyProtoEnumType soyType = this.typeRegistry.getOrCreateProtoEnumType(enumDescriptor);
            if (val != null) {
                return new ProtoEnumValueNode(id, soyType, val.getNumber());
            }
            this.errorReporter.report(fullLocation, ENUM_MEMBERSHIP_ERROR, fieldName, refn.getName());
            return new ProtoEnumValueNode(id, soyType, 0);
        }
        SoyType nestedType = UnknownType.getInstance();
        if (type.getKind() == SoyType.Kind.PROTO_MODULE) {
            nestedType = this.typeRegistry.getProtoImportType(((ProtoModuleImportType)type).getDescriptor(), fieldName);
        } else if (type.getKind() == SoyType.Kind.PROTO_TYPE) {
            nestedType = this.typeRegistry.getProtoImportType(((ProtoImportType)type).getDescriptor(), fieldName);
        } else if (type.getKind() == SoyType.Kind.TEMPLATE_MODULE && (moduleType = (TemplateModuleImportType)type).getTemplateNames().contains((Object)fieldName)) {
            nestedType = this.typeRegistry.intern(TemplateImportType.create(moduleType, fieldName));
        }
        if (nestedType == UnknownType.getInstance()) {
            if (kind != ExprNode.Kind.METHOD_CALL_NODE) {
                this.errorReporter.report(fullLocation, NO_SUCH_NESTED_TYPE, fieldName, type);
            }
            return null;
        }
        VarDefn newDefn = ImportedVar.nested(defn, nestedType);
        return new VarRefNode(refn.getName() + "." + fieldName, fullLocation, newDefn);
    }
}

