/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.ResolveExpressionTypesPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.internal.BuiltinMethod;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.ImportsContext;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TagName;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.types.ImportType;
import com.google.template.soy.types.LegacyObjectMapType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.MessageType;
import com.google.template.soy.types.NamedTemplateType;
import com.google.template.soy.types.PrimitiveType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypeVisitor;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.TemplateBindingUtil;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.UnionType;
import com.google.template.soy.types.UnknownType;
import com.google.template.soy.types.VeType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

@RunAfter(value={ResolveExpressionTypesPass.class})
final class ResolveExpressionTypesCrossTemplatePass
implements CompilerFileSetPass {
    private static final SoyErrorKind ELEMENT_CALL_TO_HTML_TEMPLATE = SoyErrorKind.of("Expected a template with kind 'html<?>' that is completely bound or only has html parameters, but found `{0}`.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ONLY_STRICT_HTML_TEMPLATES_ALLOWED = SoyErrorKind.of("Only strict HTML templates are allowed in expressions, but template `{0}` was not strict HTML.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DECLARED_DEFAULT_TYPE_MISMATCH = SoyErrorKind.of("The initializer for ''{0}'' has type ''{1}'' which is not assignable to type ''{2}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ILLEGAL_USE = SoyErrorKind.of("''legacyDynamicTag'' may only be used to name an HTML tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NEED_WRAP = SoyErrorKind.of("A dynamic tag name should be wrapped in the ''legacyDynamicTag'' function.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ONLY_ONE_CLOSE_TAG = SoyErrorKind.of("Element calls require exactly one close tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NON_STATIC_ATTRIBUTE_NAME = SoyErrorKind.of("Element call attribute names must be static.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NEGATIVE_ATTRIBUTE = SoyErrorKind.of("Callee template does not allow attribute ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PARAM_AS_ATTRIBUTE = SoyErrorKind.of("Param ''{0}'' may not be set as an attribute.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NO_SUCH_ATTRIBUTE = SoyErrorKind.of("Unrecognized attribute.{0}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind BAD_ATTRIBUTE_NAME = SoyErrorKind.of("Element attribute names must be lower hyphen case.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NO_ATTRIBUTE_VALUE = SoyErrorKind.of("Element call attributes must have values.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NO_ATTRIBUTES_ON_SLOT = SoyErrorKind.of("<parameter> elements cannot have attributes except slot, which must have a static value.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SLOTS_ONLY_ONE_CLOSE_TAG = SoyErrorKind.of("<parameter> elements cannot have more than one close tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SLOTS_ONLY_DIRECT_DESCENDENTS_OF_TEMPLATE_CALL = SoyErrorKind.of("<parameter> elements can only be direct descendents of template calls.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_PARAM = SoyErrorKind.of("Duplicate param ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PASSES_UNUSED_PARAM = SoyErrorKind.of("''{0}'' is not a declared parameter of {1} or any indirect callee.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind MISSING_PARAM = SoyErrorKind.of("Call missing required param ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MISSING_ATTRIBUTE = SoyErrorKind.of("Call missing required attribute ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ONLY_SLOTS_ALLOWED = SoyErrorKind.of("Element calls require all children to be <parameter> elements.", new SoyErrorKind.StyleAllowance[0]);
    private final SoyTypeRegistry typeRegistry;
    private final ErrorReporter errorReporter;
    private final boolean astRewrites;
    private final Set<String> invalidTemplateNames = new HashSet<String>();
    private final Set<String> reportedInvalidTemplateNames = new HashSet<String>();

    ResolveExpressionTypesCrossTemplatePass(SoyTypeRegistry typeRegistry, ErrorReporter errorReporter, boolean astRewrites) {
        this.typeRegistry = typeRegistry;
        this.errorReporter = errorReporter;
        this.astRewrites = astRewrites;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        for (SoyFileNode file : sourceFiles) {
            this.updateTemplateTypes(file);
            this.checkInitializerValues(file);
            this.checkForNamedTemplateTypes(file);
            if (!this.astRewrites) continue;
            this.handleDynamicTagAndCheckForLegacyDynamicTags(file);
        }
        this.checkReportedAllInvalidNames();
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void updateTemplateTypes(SoyFileNode file) {
        ImportsContext.ImportsTemplateRegistry templateRegistry = file.getTemplateRegistry();
        block5: for (ExprNode exprNode : SoyTreeUtils.getAllNodesOfType(file, ExprNode.class)) {
            if (!SoyTypes.transitivelyContainsKind(exprNode.getType(), SoyType.Kind.NAMED_TEMPLATE)) continue;
            boolean isTemplateLiteral = exprNode.getKind() == ExprNode.Kind.TEMPLATE_LITERAL_NODE;
            boolean isSynthetic = isTemplateLiteral && ((TemplateLiteralNode)exprNode).isSynthetic() || exprNode.getKind() == ExprNode.Kind.EXPR_ROOT_NODE && ((ExprRootNode)exprNode).getRoot().getKind() == ExprNode.Kind.TEMPLATE_LITERAL_NODE && ((TemplateLiteralNode)((ExprRootNode)exprNode).getRoot()).isSynthetic();
            SoyType resolvedType = exprNode.getType().accept(new TemplateTypeUpgrader(this.errorReporter.bindIgnoringUnknown(exprNode.getSourceLocation()), templateRegistry, isTemplateLiteral, isSynthetic));
            switch (exprNode.getKind()) {
                case TEMPLATE_LITERAL_NODE: {
                    ((TemplateLiteralNode)exprNode).setType(resolvedType);
                    continue block5;
                }
                case VAR_REF_NODE: {
                    ((VarRefNode)exprNode).setSubstituteType(resolvedType);
                    continue block5;
                }
                case GLOBAL_NODE: {
                    Preconditions.checkState((boolean)((GlobalNode)exprNode).getName().equals("DO_NOT_USE__NULL_SAFE_ACCESS"));
                    ((GlobalNode)exprNode).upgradeTemplateType(resolvedType);
                    continue block5;
                }
            }
            if (exprNode instanceof AbstractParentExprNode) {
                ((AbstractParentExprNode)exprNode).setType(resolvedType);
                continue;
            }
            throw new AssertionError((Object)("Unhandled type: " + exprNode));
        }
    }

    private void checkInitializerValues(SoyFileNode file) {
        for (TemplateNode templateNode : SoyTreeUtils.getAllNodesOfType(file, TemplateNode.class)) {
            for (TemplateHeaderVarDefn headerVar : templateNode.getHeaderParams()) {
                SoyType actualType;
                SoyType declaredType;
                if (!SoyTypes.transitivelyContainsKind(headerVar.type(), SoyType.Kind.TEMPLATE) || headerVar.defaultValue() == null || (declaredType = headerVar.type()).isAssignableFromStrict(actualType = headerVar.defaultValue().getType())) continue;
                this.errorReporter.report(headerVar.defaultValue().getSourceLocation(), DECLARED_DEFAULT_TYPE_MISMATCH, headerVar.name(), actualType, declaredType);
            }
        }
    }

    private void checkForNamedTemplateTypes(SoyFileNode file) {
        for (ExprNode exprNode : SoyTreeUtils.getAllNodesOfType(file, ExprNode.class)) {
            if (!SoyTypes.transitivelyContainsKind(exprNode.getType(), SoyType.Kind.NAMED_TEMPLATE)) continue;
            throw new IllegalStateException("Found non-upgraded Named Template type after they should have all been removed. This is most likely a parsing error; please file a go/soy-bug. Problem expression: " + exprNode + " at " + exprNode.getSourceLocation());
        }
    }

    private void handleDynamicTagAndCheckForLegacyDynamicTags(SoyFileNode file) {
        HashSet correctlyPlaced = new HashSet();
        HashSet allowedSlots = new HashSet();
        SoyTreeUtils.allNodesOfType(file, HtmlTagNode.class).filter(tag -> !tag.getTagName().isStatic()).forEach(tagNode -> {
            SoyType type = tagNode.getTagName().getDynamicTagName().getExpr().getType();
            if (type.isAssignableFromStrict(StringType.getInstance())) {
                this.handleDynamicTag((HtmlTagNode)tagNode, correctlyPlaced);
            } else if (!tagNode.getTagName().isTemplateCall() && !type.isAssignableFromStrict(UnknownType.getInstance())) {
                this.errorReporter.report(tagNode.getSourceLocation(), ELEMENT_CALL_TO_HTML_TEMPLATE, tagNode.getTagName().getDynamicTagName().getExpr().getType());
            } else {
                this.validateTemplateCall((HtmlOpenTagNode)tagNode, allowedSlots::add);
            }
        });
        SoyTreeUtils.allFunctionInvocations(file, BuiltinFunction.LEGACY_DYNAMIC_TAG).filter(fn -> !correctlyPlaced.contains(fn)).forEach(fn -> this.errorReporter.report(fn.getSourceLocation(), ILLEGAL_USE, new Object[0]));
        SoyTreeUtils.allNodesOfType(file, HtmlOpenTagNode.class).filter(tag -> tag.isSlot() && !allowedSlots.contains(tag)).forEach(tagNode -> this.errorReporter.report(tagNode.getSourceLocation(), SLOTS_ONLY_DIRECT_DESCENDENTS_OF_TEMPLATE_CALL, new Object[0]));
    }

    private void validateTemplateCall(HtmlOpenTagNode openTagNode, Consumer<HtmlTagNode> consumer) {
        boolean defaultSlotFulfilled;
        if (openTagNode.getTaggedPairs().size() > 1) {
            this.errorReporter.report(openTagNode.getSourceLocation(), ONLY_ONE_CLOSE_TAG, new Object[0]);
        }
        HashSet seenSlots = new HashSet();
        HashSet seenAttributes = new HashSet();
        TemplateType templateType = (TemplateType)openTagNode.getTagName().getDynamicTagName().getExpr().getType();
        boolean hasAllAttributes = templateType.getAllowExtraAttributes();
        ImmutableSet<String> reservedAttributes = templateType.getReservedAttributes();
        ImmutableMap allParamsByAttrName = (ImmutableMap)templateType.getParameters().stream().collect(ImmutableMap.toImmutableMap(p -> TemplateType.Parameter.paramToAttrName(p.getName()), p -> p));
        SoyTreeUtils.getAllNodesOfType(openTagNode, HtmlAttributeNode.class).forEach(a -> this.validateAttribute((HtmlAttributeNode)a, seenAttributes::add, (ImmutableMap<String, TemplateType.Parameter>)allParamsByAttrName, hasAllAttributes, reservedAttributes));
        HtmlTagNode closeTag = (HtmlTagNode)Iterables.getFirst(openTagNode.getTaggedPairs(), (Object)openTagNode);
        SoyNode next = SoyTreeUtils.nextSibling(openTagNode);
        boolean bl = defaultSlotFulfilled = !openTagNode.isSelfClosing() && templateType.getParameters().stream().filter(p -> SoyTypes.makeNullable(SanitizedType.HtmlType.getInstance()).isAssignableFromStrict(p.getType())).count() == 1L && (!(next instanceof HtmlOpenTagNode) || !((HtmlOpenTagNode)next).isSlot());
        while (!defaultSlotFulfilled && next != closeTag && !openTagNode.isSelfClosing() && next != null) {
            next = this.consumeSlot(next, openTagNode.getTagName().getDynamicTagName().getExpr(), openTagNode.getSourceLocation(), seenSlots::add, consumer);
        }
        templateType.getParameters().stream().filter(TemplateType.Parameter::isRequired).forEach(p -> {
            if (!hasAllAttributes && p.getKind() == TemplateType.ParameterKind.ATTRIBUTE) {
                if (!seenAttributes.contains(p.getName())) {
                    this.errorReporter.report(openTagNode.getSourceLocation(), MISSING_ATTRIBUTE, TemplateType.Parameter.paramToAttrName(p.getName()));
                }
            } else if (!seenSlots.contains(p.getName()) && !defaultSlotFulfilled) {
                this.errorReporter.report(openTagNode.getSourceLocation(), MISSING_PARAM, p.getName());
            }
        });
    }

    private void validateAttribute(HtmlAttributeNode attr, Function<String, Boolean> addAttr, ImmutableMap<String, TemplateType.Parameter> allParamsByAttrName, boolean hasAllAttributes, ImmutableSet<String> reservedAttributes) {
        String name = attr.getStaticKey();
        SourceLocation loc = ((SoyNode.StandaloneNode)attr.getChild(0)).getSourceLocation();
        if (name == null) {
            if (attr.numChildren() != 1) {
                this.errorReporter.report(loc, NON_STATIC_ATTRIBUTE_NAME, new Object[0]);
            }
            return;
        }
        boolean isSoyAttr = name.startsWith("@");
        if (isSoyAttr) {
            name = name.substring(1);
        }
        if (TemplateType.Parameter.isValidAttrName(name)) {
            String paramName = TemplateType.Parameter.attrToParamName(name);
            if (attr.getParent() instanceof HtmlOpenTagNode && !addAttr.apply(paramName).booleanValue()) {
                this.errorReporter.report(loc, DUPLICATE_PARAM, name);
                return;
            }
            if (!hasAllAttributes) {
                TemplateType.Parameter param = (TemplateType.Parameter)allParamsByAttrName.get((Object)name);
                if (param == null) {
                    String didYouMeanMessage = SoyErrors.getDidYouMeanMessage(allParamsByAttrName.entrySet().stream().filter(e -> ((TemplateType.Parameter)e.getValue()).getKind() == TemplateType.ParameterKind.ATTRIBUTE).map(Map.Entry::getKey).collect(Collectors.toList()), name);
                    this.errorReporter.report(loc, NO_SUCH_ATTRIBUTE, didYouMeanMessage);
                    return;
                }
                if (param.getKind() != TemplateType.ParameterKind.ATTRIBUTE) {
                    this.errorReporter.report(loc, PARAM_AS_ATTRIBUTE, param.getName());
                    return;
                }
            } else if (reservedAttributes.contains((Object)name)) {
                this.errorReporter.report(loc, NEGATIVE_ATTRIBUTE, name);
                return;
            }
        } else {
            this.errorReporter.report(loc, BAD_ATTRIBUTE_NAME, new Object[0]);
            return;
        }
        if (!attr.hasValue() && !isSoyAttr && allParamsByAttrName.containsKey((Object)name)) {
            this.errorReporter.report(attr.getSourceLocation(), NO_ATTRIBUTE_VALUE, new Object[0]);
            return;
        }
    }

    private SoyNode consumeSlot(SoyNode startNode, ExprNode template, SourceLocation templateLocation, Function<String, Boolean> addParam, Consumer<HtmlTagNode> consumer) {
        if (!(startNode instanceof HtmlOpenTagNode) || !((HtmlOpenTagNode)startNode).isSlot()) {
            this.errorReporter.report(startNode.getSourceLocation(), ONLY_SLOTS_ALLOWED, new Object[0]);
            return null;
        }
        HtmlOpenTagNode nextOpenTag = (HtmlOpenTagNode)startNode;
        if (nextOpenTag.numChildren() != 2) {
            this.errorReporter.report(nextOpenTag.getSourceLocation(), NO_ATTRIBUTES_ON_SLOT, new Object[0]);
            return null;
        }
        if (nextOpenTag.getTaggedPairs().size() > 1) {
            this.errorReporter.report(nextOpenTag.getSourceLocation(), SLOTS_ONLY_ONE_CLOSE_TAG, new Object[0]);
            return null;
        }
        HtmlAttributeNode attributeNode = (HtmlAttributeNode)nextOpenTag.getChild(1);
        if (!attributeNode.hasValue() || attributeNode.getStaticKey() == null || !attributeNode.getStaticKey().equals("slot") || attributeNode.getStaticContent() == null) {
            this.errorReporter.report(attributeNode.getSourceLocation(), NO_ATTRIBUTES_ON_SLOT, new Object[0]);
            return null;
        }
        TemplateType templateType = (TemplateType)template.getType();
        boolean containsParam = templateType.getParameters().stream().anyMatch(p -> p.getName().equals(attributeNode.getStaticContent()));
        if (!containsParam) {
            this.errorReporter.report(templateLocation, PASSES_UNUSED_PARAM, attributeNode.getStaticContent(), template.toSourceString(), SoyErrors.getDidYouMeanMessage((Iterable)templateType.getParameters().stream().map(TemplateType.Parameter::getName).collect(ImmutableList.toImmutableList()), attributeNode.getStaticContent()));
        }
        if (!addParam.apply(attributeNode.getStaticContent()).booleanValue()) {
            this.errorReporter.report(templateLocation, DUPLICATE_PARAM, attributeNode.getStaticContent());
        }
        HtmlTagNode closeTag = nextOpenTag.getTaggedPairs().get(0);
        consumer.accept(nextOpenTag);
        return SoyTreeUtils.nextSibling(closeTag);
    }

    private void handleDynamicTag(HtmlTagNode tagNode, Set<FunctionNode> correctlyPlaced) {
        TagName name = tagNode.getTagName();
        PrintNode printNode = name.getDynamicTagName();
        ExprNode exprNode = printNode.getExpr().getRoot();
        boolean needsWrap = true;
        if (exprNode.getKind() == ExprNode.Kind.FUNCTION_NODE) {
            needsWrap = false;
            if (((FunctionNode)exprNode).getSoyFunction() == BuiltinFunction.LEGACY_DYNAMIC_TAG) {
                FunctionNode functionNode = (FunctionNode)exprNode;
                if (functionNode.numChildren() == 1) {
                    printNode.getExpr().clearChildren();
                    printNode.getExpr().addChild(functionNode.getChild(0));
                }
                correctlyPlaced.add(functionNode);
            }
        } else if (!tagNode.getTagName().isTemplateCall()) {
            if (printNode.getExpr().getType() == UnknownType.getInstance()) {
                if (exprNode instanceof MethodCallNode && ((MethodCallNode)exprNode).isMethodResolved() && ((MethodCallNode)exprNode).getSoyMethod() == BuiltinMethod.BIND) {
                    return;
                }
                if (exprNode instanceof TemplateLiteralNode) {
                    return;
                }
            }
            if (needsWrap) {
                this.errorReporter.report(printNode.getExpr().getSourceLocation(), NEED_WRAP, new Object[0]);
            }
        }
    }

    private void checkReportedAllInvalidNames() {
        Preconditions.checkState((boolean)this.invalidTemplateNames.equals(this.reportedInvalidTemplateNames), (String)"Expected: %s; found: %s", this.invalidTemplateNames, this.reportedInvalidTemplateNames);
    }

    private class TemplateTypeUpgrader
    implements SoyTypeVisitor<SoyType> {
        private final ErrorReporter.LocationBound errorReporter;
        private final TemplateRegistry templateRegistry;
        private final boolean isTemplateLiteral;
        private final boolean isSynthetic;

        private TemplateTypeUpgrader(ErrorReporter.LocationBound errorReporter, TemplateRegistry templateRegistry, boolean isTemplateLiteral, boolean isSynthetic) {
            this.errorReporter = errorReporter;
            this.templateRegistry = templateRegistry;
            this.isTemplateLiteral = isTemplateLiteral;
            this.isSynthetic = isSynthetic;
        }

        @Override
        public SoyType visit(LegacyObjectMapType type) {
            if (type.getKeyType() == null && type.getValueType() == null) {
                return type;
            }
            SoyType key = type.getKeyType().accept(this);
            SoyType value = type.getValueType().accept(this);
            return ResolveExpressionTypesCrossTemplatePass.this.typeRegistry.getOrCreateLegacyObjectMapType(key, value);
        }

        @Override
        public SoyType visit(ListType type) {
            if (type.getElementType() == null) {
                return type;
            }
            SoyType element = type.getElementType().accept(this);
            return ResolveExpressionTypesCrossTemplatePass.this.typeRegistry.getOrCreateListType(element);
        }

        @Override
        public SoyType visit(MapType type) {
            if (type.getKeyType() == null && type.getValueType() == null) {
                return type;
            }
            SoyType key = type.getKeyType().accept(this);
            SoyType value = type.getValueType().accept(this);
            return ResolveExpressionTypesCrossTemplatePass.this.typeRegistry.getOrCreateMapType(key, value);
        }

        @Override
        public SoyType visit(NamedTemplateType type) {
            TemplateMetadata basicTemplateOrElement = this.templateRegistry.getBasicTemplateOrElement(type.getTemplateName());
            if (basicTemplateOrElement == null) {
                return UnknownType.getInstance();
            }
            TemplateType templateType = basicTemplateOrElement.getTemplateType();
            if (templateType.getContentKind().getSanitizedContentKind().isHtml() && !templateType.isStrictHtml() && !this.isSynthetic) {
                ResolveExpressionTypesCrossTemplatePass.this.invalidTemplateNames.add(type.getTemplateName());
                if (this.isTemplateLiteral) {
                    this.errorReporter.report(ONLY_STRICT_HTML_TEMPLATES_ALLOWED, basicTemplateOrElement.getTemplateName());
                    ResolveExpressionTypesCrossTemplatePass.this.reportedInvalidTemplateNames.add(type.getTemplateName());
                }
                return UnknownType.getInstance();
            }
            TemplateType internTemplateType = ResolveExpressionTypesCrossTemplatePass.this.typeRegistry.internTemplateType(templateType);
            if (type.getBoundParameters().isPresent()) {
                return TemplateBindingUtil.bindParameters(internTemplateType, (RecordType)type.getBoundParameters().get().accept(this), ResolveExpressionTypesCrossTemplatePass.this.typeRegistry, this.errorReporter);
            }
            return internTemplateType;
        }

        @Override
        public SoyType visit(PrimitiveType type) {
            return type;
        }

        @Override
        public SoyType visit(RecordType type) {
            ArrayList<RecordType.Member> memberTypes = new ArrayList<RecordType.Member>();
            for (RecordType.Member member : type.getMembers()) {
                memberTypes.add(RecordType.memberOf(member.name(), member.type().accept(this)));
            }
            return ResolveExpressionTypesCrossTemplatePass.this.typeRegistry.getOrCreateRecordType(memberTypes);
        }

        @Override
        public SoyType visit(SoyProtoEnumType type) {
            return type;
        }

        @Override
        public SoyType visit(SoyProtoType type) {
            return type;
        }

        @Override
        public SoyType visit(TemplateType type) {
            Preconditions.checkState((!SoyTypes.transitivelyContainsKind(type, SoyType.Kind.NAMED_TEMPLATE) ? 1 : 0) != 0);
            return type;
        }

        @Override
        public SoyType visit(UnionType type) {
            ArrayList<SoyType> memberTypes = new ArrayList<SoyType>();
            for (SoyType memberType : type.getMembers()) {
                memberTypes.add(memberType.accept(this));
            }
            return SoyTypes.computeLowestCommonType(ResolveExpressionTypesCrossTemplatePass.this.typeRegistry, memberTypes);
        }

        @Override
        public SoyType visit(VeType type) {
            return type;
        }

        @Override
        public SoyType visit(MessageType type) {
            return type;
        }

        @Override
        public SoyType visit(ImportType type) {
            return type;
        }
    }
}

