/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basicfunctions.ConcatListsFunction;
import com.google.template.soy.basicfunctions.ConcatMapsMethod;
import com.google.template.soy.basicfunctions.KeysFunction;
import com.google.template.soy.basicfunctions.LegacyObjectMapToMapFunction;
import com.google.template.soy.basicfunctions.ListSliceMethod;
import com.google.template.soy.basicfunctions.MapEntriesMethod;
import com.google.template.soy.basicfunctions.MapKeysFunction;
import com.google.template.soy.basicfunctions.MapToLegacyObjectMapFunction;
import com.google.template.soy.basicfunctions.MapValuesMethod;
import com.google.template.soy.basicfunctions.MaxFunction;
import com.google.template.soy.basicfunctions.MinFunction;
import com.google.template.soy.basicfunctions.NumberListSortMethod;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.AbstractExprNode;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.AbstractOperatorNode;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.AbstractVarDefn;
import com.google.template.soy.exprtree.CallableExprBuilder;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.NullSafeAccessNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.exprtree.VeLiteralNode;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.logging.ValidatedLoggingConfig;
import com.google.template.soy.passes.CheckTemplateCallsPass;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.PluginResolver;
import com.google.template.soy.passes.RuntimeTypeCoercion;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.internal.BuiltinMethod;
import com.google.template.soy.shared.internal.ResolvedSignature;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.SoyMethod;
import com.google.template.soy.shared.restricted.SoyMethodSignature;
import com.google.template.soy.shared.restricted.SoySourceFunctionMethod;
import com.google.template.soy.shared.restricted.TypedSoyFunction;
import com.google.template.soy.soyparse.SoyFileParser;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.ImportedVar;
import com.google.template.soy.soytree.defn.LocalVar;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.AbstractMapType;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.LegacyObjectMapType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.ProtoImportType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.UnionType;
import com.google.template.soy.types.UnknownType;
import com.google.template.soy.types.VeDataType;
import com.google.template.soy.types.VeType;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.TypeNodeConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class ResolveExpressionTypesPass
implements CompilerFilePass {
    private static final SoyErrorKind BAD_FOREACH_TYPE = SoyErrorKind.of("Cannot iterate over {0} of type {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_INDEX_TYPE = SoyErrorKind.of("Bad index type {0} for {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_KEY_TYPE = SoyErrorKind.of("Bad key type {0} for {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_LIST_COMP_TYPE = SoyErrorKind.of("Bad list comprehension type. {0} has type: {1}, but should be a list.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BRACKET_ACCESS_NOT_SUPPORTED = SoyErrorKind.of("Type {0} does not support bracket access.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BRACKET_ACCESS_NULLABLE_UNION = SoyErrorKind.of("Union type that is nullable cannot use bracket access. To access this value, first check for null or use null-safe (\"?[\") operations.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CHECK_NOT_NULL_ON_COMPILE_TIME_NULL = SoyErrorKind.of("Cannot {0} on a value with a static type of ''null''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind REDUNDANT_NON_NULL_ASSERTION_OPERATOR = SoyErrorKind.of("Found redundant non-null assertion operators (''!'').", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DOT_ACCESS_NOT_SUPPORTED = SoyErrorKind.of("Type {0} does not support dot access.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DOT_ACCESS_NOT_SUPPORTED_CONSIDER_RECORD = SoyErrorKind.of("Type {0} does not support dot access (consider record instead of map).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNNECESSARY_NULL_SAFE_ACCESS = SoyErrorKind.of("This null safe access is unnecessary, it is on a value that is non-null.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_KEY_IN_MAP_LITERAL = SoyErrorKind.of("Map literals with duplicate keys are not allowed.  Duplicate key: ''{0}''", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind KEYS_PASSED_MAP = SoyErrorKind.of("Use the ''mapKeys'' function instead of ''keys'' for objects of type ''map''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ILLEGAL_MAP_RESOLVED_KEY_TYPE = SoyErrorKind.of("A map''s keys must all be the same type. This map has keys of multiple types (''{0}'').", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EMPTY_LIST_ACCESS = SoyErrorKind.of("Accessing item in empty list.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EMPTY_LIST_FOREACH = SoyErrorKind.of("Cannot iterate over empty list.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EMPTY_MAP_ACCESS = SoyErrorKind.of("Accessing item in empty map.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_TYPE_SUBSTITUTION = SoyErrorKind.of("Expected expression of type ''{0}'', found ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind LIST_LENGTH_ERROR = SoyErrorKind.of("Soy lists do not have a ''length'' field. Use function length(...) instead.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MISSING_SOY_TYPE = SoyErrorKind.of("Missing Soy type for node {0}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NOT_PROTO_INIT = SoyErrorKind.of("Expected a protocol buffer for the second argument.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind OR_OPERATOR_HAS_CONSTANT_OPERAND = SoyErrorKind.of("Constant operand ''{0}'' used with ''or'' operator. Consider simplifying or using the ?: operator, see go/soy/reference/expressions.md#logical-operators", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind STRING_LENGTH_ERROR = SoyErrorKind.of("Soy strings do not have a ''length'' field. Use function strLen(...) instead.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNDEFINED_FIELD_FOR_PROTO_TYPE = SoyErrorKind.of("Undefined field ''{0}'' for proto type {1}.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind UNDEFINED_FIELD_FOR_RECORD_TYPE = SoyErrorKind.of("Undefined field ''{0}'' for record type {1}.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind PROTO_FIELD_DOES_NOT_EXIST = SoyErrorKind.of("Proto field ''{0}'' does not exist on {1}.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind PROTO_MISSING_REQUIRED_FIELD = SoyErrorKind.of("Missing required proto field ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PROTO_NULL_ARG_TYPE = SoyErrorKind.of("Cannot assign static type ''null'' to proto field ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PROTO_FIELD_NAME_ALIAS_CONFLICT = SoyErrorKind.of("Alias ''{0}'' conflicts with a field with the same name in proto ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind TYPE_MISMATCH = SoyErrorKind.of("Soy types ''{0}'' and ''{1}'' are not comparable.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DECLARED_DEFAULT_TYPE_MISMATCH = SoyErrorKind.of("The initializer for ''{0}'' has type ''{1}'' which is not assignable to type ''{2}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind STATE_MUST_BE_CONSTANT = SoyErrorKind.of("The initializer for ''{0}'' must be a constant value.  {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INCOMPATIBLE_ARITHMETIC_OP = SoyErrorKind.of("Using arithmetic operators on Soy types ''{0}'' and ''{1}'' is illegal.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INCOMPATIBLE_ARITHMETIC_OP_UNARY = SoyErrorKind.of("Using arithmetic operators on the Soy type ''{0}'' is illegal.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INCORRECT_ARG_TYPE = SoyErrorKind.of("Function ''{0}'' called with incorrect arg type {1} (expected {2}).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INCORRECT_ARG_STYLE = SoyErrorKind.of("Function called with incorrect arg style (positional or named).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind LOOP_VARIABLE_NOT_IN_SCOPE = SoyErrorKind.of("Function ''{0}'' must have a loop variable as its argument.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind STRING_LITERAL_REQUIRED = SoyErrorKind.of("Argument to function ''{0}'' must be a string literal.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_METHOD_BASE = SoyErrorKind.of("Method ''{0}'' does not exist on type ''{1}''.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind MULTIPLE_METHODS_MATCH = SoyErrorKind.of("Method ''{0}'' with {1} arg(s) for type ''{2}'' matches multiple method implementations.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind METHOD_INVALID_PARAM_NUM = SoyErrorKind.of("Method ''{0}'' called with {1} parameter(s) but expected {2}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind METHOD_INVALID_PARAM_TYPES = SoyErrorKind.of("Method ''{0}'' called with parameter types ({1}) but expected ({2}).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind METHOD_BASE_TYPE_NULL_SAFE_REQUIRED = SoyErrorKind.of("Method calls are not allowed on objects with nullable types (''{0}''). Either ensure the type is non-nullable or perform a null safe access (''?.'').", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EXPLICIT_NULL = SoyErrorKind.of("Explicit use of the ''null'' type is not allowed.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind AMBIGUOUS_INFERRED_TYPE = SoyErrorKind.of("Using {0} in the initializer for a parameter with an inferred type is ambiguous. Add an explicit type declaration.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind VE_NO_CONFIG_FOR_ELEMENT = SoyErrorKind.of("Could not find logging configuration for this element.{0}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind VE_CONFLICTS_WITH_TYPE = SoyErrorKind.of("VE name conflicts with import on line {0}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind TEMPLATE_TYPE_PARAMETERS_CANNOT_USE_INFERRED_TYPES = SoyErrorKind.of("Template type parameters cannot be inferred. Instead, explicitly declare the type.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PROTO_EXT_FQN = SoyErrorKind.of("Extensions fields in proto init functions must be imported symbols. Fully qualified names are not allowed.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NOT_PROTO_MESSAGE = SoyErrorKind.of("Only proto messages may be instantiated.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;
    private final ValidatedLoggingConfig loggingConfig;
    private final SoyMethod.Registry methodRegistry;
    private final Map<Signature, ResolvedSignature> signatureMap = new HashMap<Signature, ResolvedSignature>();
    private TypeSubstitution substitutions;
    private ExprEquivalence exprEquivalence;
    private SoyTypeRegistry typeRegistry;
    private TypeNodeConverter pluginTypeConverter;
    private final PluginResolver.Mode pluginResolutionMode;
    private ImmutableMap<String, ImportedVar> importIndex;

    ResolveExpressionTypesPass(ErrorReporter errorReporter, ValidatedLoggingConfig loggingConfig, PluginResolver pluginResolver) {
        this.errorReporter = errorReporter;
        this.loggingConfig = loggingConfig;
        this.pluginResolutionMode = pluginResolver == null ? PluginResolver.Mode.REQUIRE_DEFINITIONS : pluginResolver.getPluginResolutionMode();
        this.methodRegistry = new CompositeMethodRegistry((List<SoyMethod.Registry>)ImmutableList.of((Object)BuiltinMethod.REGISTRY, (Object)new PluginMethodRegistry(pluginResolver)));
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        this.substitutions = null;
        this.exprEquivalence = new ExprEquivalence();
        this.typeRegistry = file.getSoyTypeRegistry();
        this.importIndex = (ImmutableMap)file.getImports().stream().flatMap(i -> i.getIdentifiers().stream()).collect(ImmutableMap.toImmutableMap(AbstractVarDefn::name, Function.identity(), (e1, e2) -> e1));
        this.pluginTypeConverter = TypeNodeConverter.builder(this.errorReporter).setTypeRegistry(this.typeRegistry).setSystemExternal(true).build();
        new TypeAssignmentSoyVisitor().exec(file);
    }

    private void addTypeSubstitutions(Map<ExprEquivalence.Wrapper, SoyType> substitutionsToAdd) {
        for (Map.Entry<ExprEquivalence.Wrapper, SoyType> entry : substitutionsToAdd.entrySet()) {
            ExprNode expr = entry.getKey().get();
            SoyType previousType = expr.getType();
            TypeSubstitution subst = this.substitutions;
            while (subst != null) {
                if (this.exprEquivalence.equivalent(subst.expression, expr)) {
                    previousType = subst.type;
                    break;
                }
                subst = subst.parent;
            }
            if (entry.getValue().equals(previousType)) continue;
            this.substitutions = new TypeSubstitution(this.substitutions, expr, entry.getValue());
        }
    }

    private void visitExpressions(SoyNode.ExprHolderNode node) {
        ResolveTypesExprVisitor exprVisitor = new ResolveTypesExprVisitor(false, node);
        for (ExprRootNode expr : node.getExprList()) {
            exprVisitor.exec(expr);
        }
    }

    private SoyType getElementType(SoyType collectionType, ForNonemptyNode node) {
        Preconditions.checkNotNull((Object)collectionType);
        switch (collectionType.getKind()) {
            case UNKNOWN: {
                return UnknownType.getInstance();
            }
            case LIST: {
                if (collectionType == ListType.EMPTY_LIST) {
                    this.errorReporter.report(node.getExpr().getSourceLocation(), EMPTY_LIST_FOREACH, new Object[0]);
                    return UnknownType.getInstance();
                }
                return ((ListType)collectionType).getElementType();
            }
            case UNION: {
                ErrorReporter.Checkpoint cp = this.errorReporter.checkpoint();
                UnionType unionType = (UnionType)collectionType;
                ArrayList<SoyType> fieldTypes = new ArrayList<SoyType>(unionType.getMembers().size());
                for (SoyType unionMember : unionType.getMembers()) {
                    SoyType elementType = this.getElementType(unionMember, node);
                    if (this.errorReporter.errorsSince(cp)) {
                        return elementType;
                    }
                    fieldTypes.add(elementType);
                }
                return SoyTypes.computeLowestCommonType(this.typeRegistry, fieldTypes);
            }
        }
        this.errorReporter.report(node.getParent().getSourceLocation(), BAD_FOREACH_TYPE, node.getExpr().toSourceString(), node.getExpr().getType());
        return UnknownType.getInstance();
    }

    private final class PluginMethodRegistry
    implements SoyMethod.Registry {
        private final PluginResolver plugins;
        private final LoadingCache<String, ImmutableList<SoySourceFunctionMethod>> methodCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, ImmutableList<SoySourceFunctionMethod>>(){

            public ImmutableList<SoySourceFunctionMethod> load(String methodName) {
                ImmutableList.Builder methods = ImmutableList.builder();
                ImmutableList<SoySourceFunction> functions = PluginMethodRegistry.this.plugins.lookupSoyMethods(methodName);
                for (SoySourceFunction function : functions) {
                    SoyMethodSignature methodSig = function.getClass().getAnnotation(SoyMethodSignature.class);
                    SourceFilePath fakeFunctionPath = SourceFilePath.create(function.getClass().getName());
                    SoyType baseType = this.parseType(methodSig.baseType(), fakeFunctionPath);
                    for (Signature signature : methodSig.value()) {
                        SoyType returnType = this.parseType(signature.returnType(), fakeFunctionPath);
                        ImmutableList argTypes = (ImmutableList)Arrays.stream(signature.parameterTypes()).map(s -> this.parseType((String)s, fakeFunctionPath)).collect(ImmutableList.toImmutableList());
                        methods.add((Object)new SoySourceFunctionMethod(function, baseType, returnType, (ImmutableList<SoyType>)argTypes, methodSig.name()));
                    }
                }
                return methods.build();
            }

            private SoyType parseType(String t, SourceFilePath path) {
                TypeNode typeNode = SoyFileParser.parseType(t, path, ResolveExpressionTypesPass.this.errorReporter);
                return typeNode != null ? ResolveExpressionTypesPass.this.pluginTypeConverter.getOrCreateType(typeNode) : UnknownType.getInstance();
            }
        });

        PluginMethodRegistry(PluginResolver plugins) {
            this.plugins = plugins;
        }

        public ImmutableList<SoySourceFunctionMethod> matchForNameAndBase(String methodName, SoyType baseType) {
            Preconditions.checkArgument((!SoyTypes.isNullable(baseType) ? 1 : 0) != 0);
            return (ImmutableList)((ImmutableList)this.methodCache.getUnchecked((Object)methodName)).stream().filter(m -> m.appliesToBase(baseType)).collect(ImmutableList.toImmutableList());
        }

        @Override
        public ImmutableMultimap<SoyMethod, String> matchForBaseAndArgs(SoyType baseType, List<SoyType> argTypes) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            this.plugins.getAllMethodNames().forEach(methodName -> {
                for (SoySourceFunctionMethod m : (ImmutableList)this.methodCache.getUnchecked(methodName)) {
                    if (!m.appliesToBase(baseType) || m.getNumArgs() != argTypes.size()) continue;
                    builder.put((Object)m, methodName);
                }
            });
            return builder.build();
        }
    }

    private static final class CompositeMethodRegistry
    implements SoyMethod.Registry {
        private final List<SoyMethod.Registry> registries;

        public CompositeMethodRegistry(List<SoyMethod.Registry> registries) {
            this.registries = registries;
        }

        @Override
        public ImmutableList<? extends SoyMethod> matchForNameAndBase(String methodName, SoyType baseType) {
            return (ImmutableList)this.registries.stream().flatMap(r -> r.matchForNameAndBase(methodName, baseType).stream()).collect(ImmutableList.toImmutableList());
        }

        @Override
        public ImmutableMultimap<SoyMethod, String> matchForBaseAndArgs(SoyType baseType, List<SoyType> argTypes) {
            ImmutableListMultimap.Builder combined = ImmutableListMultimap.builder();
            this.registries.forEach(r -> combined.putAll(r.matchForBaseAndArgs(baseType, argTypes)));
            return combined.build();
        }
    }

    private static final class TypeSubstitution {
        @Nullable
        final TypeSubstitution parent;
        final ExprNode expression;
        final SoyType type;

        TypeSubstitution(@Nullable TypeSubstitution parent, ExprNode expression, SoyType type) {
            this.parent = parent;
            this.expression = expression;
            this.type = type;
        }
    }

    private static enum UnknownPolicy {
        ALLOWED,
        DISALLOWED;

    }

    private final class TypeNarrowingConditionVisitor
    extends AbstractExprNodeVisitor<Void> {
        Map<ExprEquivalence.Wrapper, SoyType> positiveTypeConstraints = new LinkedHashMap<ExprEquivalence.Wrapper, SoyType>();
        Map<ExprEquivalence.Wrapper, SoyType> negativeTypeConstraints = new LinkedHashMap<ExprEquivalence.Wrapper, SoyType>();

        private TypeNarrowingConditionVisitor() {
        }

        @Override
        public Void exec(ExprNode node) {
            this.visit(node);
            return null;
        }

        @Override
        protected void visitExprRootNode(ExprRootNode node) {
            this.visitAndImplicitlyCastToBoolean(node.getRoot());
        }

        void visitAndImplicitlyCastToBoolean(ExprNode node) {
            this.visit(node);
            ExprEquivalence.Wrapper wrapped = ResolveExpressionTypesPass.this.exprEquivalence.wrap(node);
            this.positiveTypeConstraints.put(wrapped, SoyTypes.tryRemoveNull(node.getType()));
            this.negativeTypeConstraints.put(wrapped, node.getType());
        }

        @Override
        protected void visitAndOpNode(OperatorNodes.AndOpNode node) {
            Preconditions.checkArgument((node.numChildren() == 2 ? 1 : 0) != 0);
            TypeNarrowingConditionVisitor leftVisitor = new TypeNarrowingConditionVisitor();
            TypeNarrowingConditionVisitor rightVisitor = new TypeNarrowingConditionVisitor();
            leftVisitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            rightVisitor.visitAndImplicitlyCastToBoolean(node.getChild(1));
            this.computeConstraintUnionInto(leftVisitor.positiveTypeConstraints, rightVisitor.positiveTypeConstraints, this.positiveTypeConstraints);
            this.computeConstraintIntersectionInto(leftVisitor.negativeTypeConstraints, rightVisitor.negativeTypeConstraints, this.negativeTypeConstraints);
        }

        @Override
        protected void visitOrOpNode(OperatorNodes.OrOpNode node) {
            Preconditions.checkArgument((node.numChildren() == 2 ? 1 : 0) != 0);
            TypeNarrowingConditionVisitor leftVisitor = new TypeNarrowingConditionVisitor();
            TypeNarrowingConditionVisitor rightVisitor = new TypeNarrowingConditionVisitor();
            leftVisitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            rightVisitor.visitAndImplicitlyCastToBoolean(node.getChild(1));
            this.computeConstraintIntersectionInto(leftVisitor.positiveTypeConstraints, rightVisitor.positiveTypeConstraints, this.positiveTypeConstraints);
            this.computeConstraintUnionInto(leftVisitor.negativeTypeConstraints, rightVisitor.negativeTypeConstraints, this.negativeTypeConstraints);
        }

        @Override
        protected void visitNotOpNode(OperatorNodes.NotOpNode node) {
            TypeNarrowingConditionVisitor childVisitor = new TypeNarrowingConditionVisitor();
            childVisitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            this.positiveTypeConstraints.putAll(childVisitor.negativeTypeConstraints);
            this.negativeTypeConstraints.putAll(childVisitor.positiveTypeConstraints);
        }

        @Override
        protected void visitEqualOpNode(OperatorNodes.EqualOpNode node) {
            if (node.getChild(1).getKind() == ExprNode.Kind.NULL_NODE) {
                ExprEquivalence.Wrapper wrappedExpr = ResolveExpressionTypesPass.this.exprEquivalence.wrap(node.getChild(0));
                this.positiveTypeConstraints.put(wrappedExpr, NullType.getInstance());
                this.negativeTypeConstraints.put(wrappedExpr, SoyTypes.tryRemoveNull(wrappedExpr.get().getType()));
            } else if (node.getChild(0).getKind() == ExprNode.Kind.NULL_NODE) {
                ExprEquivalence.Wrapper wrappedExpr = ResolveExpressionTypesPass.this.exprEquivalence.wrap(node.getChild(1));
                this.positiveTypeConstraints.put(wrappedExpr, NullType.getInstance());
                this.negativeTypeConstraints.put(wrappedExpr, SoyTypes.tryRemoveNull(wrappedExpr.get().getType()));
            }
        }

        @Override
        protected void visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
            if (node.getChild(1).getKind() == ExprNode.Kind.NULL_NODE) {
                ExprEquivalence.Wrapper wrappedExpr = ResolveExpressionTypesPass.this.exprEquivalence.wrap(node.getChild(0));
                this.positiveTypeConstraints.put(wrappedExpr, SoyTypes.tryRemoveNull(wrappedExpr.get().getType()));
                this.negativeTypeConstraints.put(wrappedExpr, NullType.getInstance());
            } else if (node.getChild(0).getKind() == ExprNode.Kind.NULL_NODE) {
                ExprEquivalence.Wrapper wrappedExpr = ResolveExpressionTypesPass.this.exprEquivalence.wrap(node.getChild(1));
                this.positiveTypeConstraints.put(wrappedExpr, SoyTypes.tryRemoveNull(wrappedExpr.get().getType()));
                this.negativeTypeConstraints.put(wrappedExpr, NullType.getInstance());
            }
        }

        @Override
        protected void visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
        }

        @Override
        protected void visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        }

        @Override
        protected void visitFunctionNode(FunctionNode node) {
            if (node.numChildren() != 1) {
                return;
            }
            if ("isNonnull".equals(node.getFunctionName())) {
                ExprEquivalence.Wrapper wrappedExpr = ResolveExpressionTypesPass.this.exprEquivalence.wrap(node.getChild(0));
                this.positiveTypeConstraints.put(wrappedExpr, SoyTypes.tryRemoveNull(wrappedExpr.get().getType()));
                this.negativeTypeConstraints.put(wrappedExpr, NullType.getInstance());
            } else if ("isNull".equals(node.getFunctionName())) {
                ExprEquivalence.Wrapper wrappedExpr = ResolveExpressionTypesPass.this.exprEquivalence.wrap(node.getChild(0));
                this.positiveTypeConstraints.put(wrappedExpr, NullType.getInstance());
                this.negativeTypeConstraints.put(wrappedExpr, SoyTypes.tryRemoveNull(wrappedExpr.get().getType()));
            }
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)node);
            }
        }

        private <T> void computeConstraintUnionInto(Map<T, SoyType> left, Map<T, SoyType> right, Map<T, SoyType> into) {
            if (left.isEmpty()) {
                return;
            }
            if (right.isEmpty()) {
                return;
            }
            into.putAll(left);
            for (Map.Entry<T, SoyType> entry : right.entrySet()) {
                into.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }

        private <T> void computeConstraintIntersectionInto(Map<T, SoyType> left, Map<T, SoyType> right, Map<T, SoyType> into) {
            if (left.isEmpty()) {
                return;
            }
            if (right.isEmpty()) {
                return;
            }
            for (Map.Entry<T, SoyType> entry : left.entrySet()) {
                SoyType rightSideType = right.get(entry.getKey());
                if (rightSideType == null) continue;
                into.put(entry.getKey(), SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, entry.getValue(), rightSideType));
            }
        }
    }

    private final class ResolveTypesExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        final boolean isDefaultInitializerForInferredParam;
        final SoyNode exprHolderNode;
        private final AbstractExprNodeVisitor<Void> checkAllTypesAssignedVisitor = new AbstractExprNodeVisitor<Void>(){

            @Override
            protected void visitExprNode(ExprNode node) {
                if (node instanceof ExprNode.ParentExprNode) {
                    this.visitChildren((ExprNode.ParentExprNode)node);
                }
                ResolveTypesExprVisitor.this.requireNodeType(node);
            }
        };

        ResolveTypesExprVisitor(boolean isDefaultInitializerForInferredParam, SoyNode exprHolderNode) {
            this.isDefaultInitializerForInferredParam = isDefaultInitializerForInferredParam;
            this.exprHolderNode = exprHolderNode;
        }

        @Override
        public Void exec(ExprNode node) {
            Preconditions.checkArgument((boolean)(node instanceof ExprRootNode));
            this.visit(node);
            this.checkAllTypesAssignedVisitor.exec(node);
            return null;
        }

        @Override
        protected void visitExprRootNode(ExprRootNode node) {
            this.visitChildren(node);
            ExprNode expr = node.getRoot();
            node.setType(expr.getType());
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitAssertNonNullOpNode(OperatorNodes.AssertNonNullOpNode node) {
            this.visitChildren(node);
            this.finishAssertNonNullOpNode(node);
        }

        private void finishAssertNonNullOpNode(OperatorNodes.AssertNonNullOpNode node) {
            ExprNode child = node.getChild(0);
            SoyType type = child.getType();
            if (type.getKind() == SoyType.Kind.NULL) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), CHECK_NOT_NULL_ON_COMPILE_TIME_NULL, "use the non-null assertion operator ('!')");
                node.setType(UnknownType.getInstance());
            } else if (node.getChild(0).getKind() == ExprNode.Kind.ASSERT_NON_NULL_OP_NODE) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), REDUNDANT_NON_NULL_ASSERTION_OPERATOR, new Object[0]);
                node.setType(UnknownType.getInstance());
            } else {
                node.setType(SoyTypes.removeNull(type));
            }
        }

        @Override
        protected void visitPrimitiveNode(ExprNode.PrimitiveNode node) {
            if (this.isDefaultInitializerForInferredParam && node.getKind() == ExprNode.Kind.NULL_NODE) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), AMBIGUOUS_INFERRED_TYPE, "a 'null' literal");
            }
        }

        @Override
        protected void visitListLiteralNode(ListLiteralNode node) {
            this.visitChildren(node);
            ArrayList<SoyType> elementTypes = new ArrayList<SoyType>(node.numChildren());
            for (ExprNode child : node.getChildren()) {
                this.requireNodeType(child);
                elementTypes.add(child.getType());
            }
            if (elementTypes.isEmpty()) {
                if (this.isDefaultInitializerForInferredParam) {
                    ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), AMBIGUOUS_INFERRED_TYPE, "an empty list");
                }
                node.setType(ListType.EMPTY_LIST);
            } else {
                node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateListType(SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, elementTypes)));
            }
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitListComprehensionNode(ListComprehensionNode node) {
            this.visit(node.getListExpr());
            if (!(node.getListExpr().getType() instanceof ListType)) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getListExpr().getSourceLocation(), BAD_LIST_COMP_TYPE, node.getListExpr().toSourceString(), node.getListExpr().getType());
                node.getListIterVar().setType(UnknownType.getInstance());
            } else {
                node.getListIterVar().setType(((ListType)node.getListExpr().getType()).getElementType());
            }
            if (node.getIndexVar() != null) {
                node.getIndexVar().setType(IntType.getInstance());
            }
            if (node.getFilterExpr() != null) {
                this.visit(node.getFilterExpr());
            }
            this.visit(node.getListItemTransformExpr());
            node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateListType(node.getListItemTransformExpr().getType()));
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitRecordLiteralNode(RecordLiteralNode node) {
            this.visitChildren(node);
            int numChildren = node.numChildren();
            Preconditions.checkState((numChildren == node.getKeys().size() ? 1 : 0) != 0);
            ArrayList<RecordType.Member> members = new ArrayList<RecordType.Member>();
            for (int i = 0; i < numChildren; ++i) {
                members.add(RecordType.memberOf(node.getKey(i).identifier(), node.getChild(i).getType()));
            }
            node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateRecordType(members));
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitMapLiteralNode(MapLiteralNode node) {
            this.visitChildren(node);
            int numChildren = node.numChildren();
            Preconditions.checkState((numChildren % 2 == 0 ? 1 : 0) != 0);
            if (numChildren == 0) {
                node.setType(MapType.EMPTY_MAP);
                if (this.isDefaultInitializerForInferredParam) {
                    ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), AMBIGUOUS_INFERRED_TYPE, "an empty map");
                }
                return;
            }
            HashSet<String> duplicateKeyErrors = new HashSet<String>();
            LinkedHashMap<String, SoyType> recordFieldTypes = new LinkedHashMap<String, SoyType>();
            ArrayList<SoyType> keyTypes = new ArrayList<SoyType>(numChildren / 2);
            ArrayList<SoyType> valueTypes = new ArrayList<SoyType>(numChildren / 2);
            ErrorReporter.Checkpoint checkpoint = ResolveExpressionTypesPass.this.errorReporter.checkpoint();
            for (int i = 0; i < numChildren; i += 2) {
                String fieldName;
                SoyType prev;
                ExprNode key = node.getChild(i);
                ExprNode value = node.getChild(i + 1);
                if (key.getKind() == ExprNode.Kind.STRING_NODE && (prev = recordFieldTypes.put(fieldName = ((StringNode)key).getValue(), value.getType())) != null && duplicateKeyErrors.add(fieldName)) {
                    ResolveExpressionTypesPass.this.errorReporter.report(key.getSourceLocation(), DUPLICATE_KEY_IN_MAP_LITERAL, fieldName);
                }
                keyTypes.add(key.getType());
                if (!MapType.isAllowedKeyType(key.getType())) {
                    ResolveExpressionTypesPass.this.errorReporter.report(key.getSourceLocation(), MapType.BAD_MAP_KEY_TYPE, key.getType());
                }
                valueTypes.add(value.getType());
            }
            SoyType commonKeyType = SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, keyTypes);
            if (!ResolveExpressionTypesPass.this.errorReporter.errorsSince(checkpoint) && !MapType.isAllowedKeyType(commonKeyType)) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), ILLEGAL_MAP_RESOLVED_KEY_TYPE, commonKeyType);
            }
            SoyType commonValueType = SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, valueTypes);
            node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateMapType(commonKeyType, commonValueType));
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitVarRefNode(VarRefNode varRef) {
            SoyType newType = this.getTypeSubstitution(varRef);
            if (newType != null) {
                varRef.setSubstituteType(newType);
            } else if (varRef.getType() == null) {
                throw new IllegalStateException("VarRefNode @" + varRef.getSourceLocation() + " doesn't have a type!");
            }
        }

        @Override
        protected void visitNullSafeAccessNode(NullSafeAccessNode nullSafeAccessNode) {
            this.visit(nullSafeAccessNode.getBase());
            this.visitNullSafeAccessNodeRecurse(nullSafeAccessNode);
        }

        private void visitNullSafeAccessNodeRecurse(NullSafeAccessNode nullSafeAccessNode) {
            if (nullSafeAccessNode.getBase().getKind() == ExprNode.Kind.ASSERT_NON_NULL_OP_NODE) {
                ResolveExpressionTypesPass.this.errorReporter.report(nullSafeAccessNode.getSourceLocation(), UNNECESSARY_NULL_SAFE_ACCESS, new Object[0]);
            }
            if (nullSafeAccessNode.getDataAccess().getKind() == ExprNode.Kind.NULL_SAFE_ACCESS_NODE) {
                NullSafeAccessNode dataAccess = (NullSafeAccessNode)nullSafeAccessNode.getDataAccess();
                this.calculateAccessChainTypes(nullSafeAccessNode.getBase().getType(), (DataAccessNode)dataAccess.getBase());
                this.visitNullSafeAccessNodeRecurse(dataAccess);
            } else {
                ExprNode.AccessChainComponentNode dataAccess = (ExprNode.AccessChainComponentNode)nullSafeAccessNode.getDataAccess();
                DataAccessNode childDataAccess = this.getDataAccessChild(dataAccess);
                this.calculateAccessChainTypes(nullSafeAccessNode.getBase().getType(), childDataAccess);
                this.finishAssertNonNullOpNodeChain(dataAccess);
            }
            nullSafeAccessNode.setType(nullSafeAccessNode.getDataAccess().getType());
            this.tryApplySubstitution(nullSafeAccessNode);
        }

        private DataAccessNode getDataAccessChild(ExprNode.AccessChainComponentNode expr) {
            ExprNode.AccessChainComponentNode child = expr;
            while (child.getKind() == ExprNode.Kind.ASSERT_NON_NULL_OP_NODE) {
                child = (ExprNode.AccessChainComponentNode)((OperatorNodes.AssertNonNullOpNode)child).getChild(0);
            }
            return (DataAccessNode)child;
        }

        private void finishAssertNonNullOpNodeChain(ExprNode.AccessChainComponentNode node) {
            if (node.getKind() == ExprNode.Kind.ASSERT_NON_NULL_OP_NODE) {
                OperatorNodes.AssertNonNullOpNode nonNullNode = (OperatorNodes.AssertNonNullOpNode)node;
                this.finishAssertNonNullOpNodeChain((ExprNode.AccessChainComponentNode)nonNullNode.getChild(0));
                this.finishAssertNonNullOpNode(nonNullNode);
            }
        }

        private void calculateAccessChainTypes(SoyType baseType, DataAccessNode dataAccess) {
            GlobalNode global;
            boolean nullSafe = true;
            if (dataAccess.getBaseExprChild() instanceof DataAccessNode) {
                this.calculateAccessChainTypes(baseType, (DataAccessNode)dataAccess.getBaseExprChild());
                nullSafe = false;
                baseType = dataAccess.getBaseExprChild().getType();
            } else if (dataAccess.getBaseExprChild().getKind() == ExprNode.Kind.ASSERT_NON_NULL_OP_NODE) {
                OperatorNodes.AssertNonNullOpNode baseExpr = (OperatorNodes.AssertNonNullOpNode)dataAccess.getBaseExprChild();
                DataAccessNode childDataAccess = this.getDataAccessChild(baseExpr);
                this.calculateAccessChainTypes(baseType, childDataAccess);
                this.finishAssertNonNullOpNodeChain(baseExpr);
                nullSafe = false;
                baseType = dataAccess.getBaseExprChild().getType();
            }
            ExprNode base = dataAccess.getBaseExprChild();
            if (base.getKind() == ExprNode.Kind.GLOBAL_NODE && !(global = (GlobalNode)base).isResolved()) {
                global.resolve(baseType, new NullNode(base.getSourceLocation()));
            }
            switch (dataAccess.getKind()) {
                case FIELD_ACCESS_NODE: {
                    this.finishFieldAccessNode((FieldAccessNode)dataAccess);
                    break;
                }
                case ITEM_ACCESS_NODE: {
                    this.finishItemAccessNode((ItemAccessNode)dataAccess, nullSafe);
                    break;
                }
                case METHOD_CALL_NODE: {
                    this.finishMethodCallNode((MethodCallNode)dataAccess, nullSafe);
                    break;
                }
                default: {
                    throw new AssertionError((Object)dataAccess.getKind());
                }
            }
        }

        @Override
        protected void visitFieldAccessNode(FieldAccessNode node) {
            Preconditions.checkState((!node.isNullSafe() ? 1 : 0) != 0);
            this.visit(node.getBaseExprChild());
            this.finishFieldAccessNode(node);
        }

        private void finishFieldAccessNode(FieldAccessNode node) {
            node.setType(this.getFieldType(node.getBaseExprChild().getType(), node.getFieldName(), node.getAccessSourceLocation()));
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitItemAccessNode(ItemAccessNode node) {
            Preconditions.checkState((!node.isNullSafe() ? 1 : 0) != 0);
            this.visit(node.getBaseExprChild());
            this.finishItemAccessNode(node, false);
        }

        private void finishItemAccessNode(ItemAccessNode node, boolean nullSafe) {
            this.visit(node.getKeyExprChild());
            SoyType itemType = this.getItemType(node.getBaseExprChild().getType(), node.getKeyExprChild().getType(), nullSafe, node.getAccessSourceLocation(), node.getKeyExprChild().getSourceLocation());
            node.setType(itemType);
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitMethodCallNode(MethodCallNode node) {
            Preconditions.checkState((!node.isNullSafe() ? 1 : 0) != 0);
            this.visit(node.getBaseExprChild());
            this.finishMethodCallNode(node, false);
        }

        private void finishMethodCallNode(MethodCallNode node, boolean nullSafe) {
            for (ExprNode child : node.getParams()) {
                this.visit(child);
            }
            SoyType baseType = node.getBaseType(nullSafe);
            SoyMethod method = this.resolveMethodFromBaseType(node, baseType);
            if (method == null) {
                node.setType(UnknownType.getInstance());
                return;
            }
            node.setSoyMethod(method);
            if (method instanceof BuiltinMethod) {
                node.setType(((BuiltinMethod)method).getReturnType(node, ResolveExpressionTypesPass.this.typeRegistry, ResolveExpressionTypesPass.this.errorReporter));
            } else if (method instanceof SoySourceFunctionMethod) {
                SoySourceFunctionMethod sourceMethod = (SoySourceFunctionMethod)method;
                SoySourceFunction sourceFunction = sourceMethod.getImpl();
                if (sourceFunction instanceof ConcatListsFunction) {
                    node.setType(this.getGenericListType(node.getChildren()));
                } else if (sourceFunction instanceof ConcatMapsMethod) {
                    node.setType(this.getGenericMapType(node.getChildren()));
                } else if (sourceFunction instanceof MapKeysFunction) {
                    MapType type = (MapType)node.getChild(0).getType();
                    node.setType(ListType.of(type.getKeyType()));
                } else if (sourceFunction instanceof MapValuesMethod) {
                    MapType type = (MapType)node.getChild(0).getType();
                    node.setType(ListType.of(type.getValueType()));
                } else if (sourceFunction instanceof MapEntriesMethod) {
                    MapType type = (MapType)node.getChild(0).getType();
                    node.setType(ListType.of(RecordType.of((ImmutableMap<String, ? extends SoyType>)ImmutableMap.of((Object)"key", (Object)type.getKeyType(), (Object)"value", (Object)type.getValueType()))));
                } else if (sourceFunction instanceof ListSliceMethod) {
                    node.setType(node.getBaseExprChild().getType());
                } else if (sourceFunction instanceof NumberListSortMethod) {
                    node.setType(node.getBaseExprChild().getType());
                } else {
                    node.setType(sourceMethod.getReturnType());
                }
            } else {
                throw new AssertionError();
            }
        }

        @Nullable
        private SoyMethod resolveMethodFromBaseType(MethodCallNode node, SoyType baseType) {
            if (SoyTypes.isNullable(baseType)) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getBaseExprChild().getSourceLocation(), METHOD_BASE_TYPE_NULL_SAFE_REQUIRED, baseType);
                return null;
            }
            int numParams = node.numChildren() - 1;
            String methodName = node.getMethodName().identifier();
            SourceLocation srcLoc = node.getAccessSourceLocation();
            List<SoyType> argTypes = node.getParams().stream().map(ExprNode::getType).collect(Collectors.toList());
            ImmutableList<? extends SoyMethod> matchNameAndType = ResolveExpressionTypesPass.this.methodRegistry.matchForNameAndBase(methodName, baseType);
            List andMatchArgCount = matchNameAndType.stream().filter(m -> m.getNumArgs() == numParams).collect(Collectors.toList());
            if (!matchNameAndType.isEmpty() && andMatchArgCount.isEmpty()) {
                Set allNumArgs = (Set)matchNameAndType.stream().map(SoyMethod::getNumArgs).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()));
                String validSize = Joiner.on((String)" or ").join((Iterable)allNumArgs);
                ResolveExpressionTypesPass.this.errorReporter.report(srcLoc, METHOD_INVALID_PARAM_NUM, methodName, numParams, validSize);
                return null;
            }
            List andMatchArgType = andMatchArgCount.stream().filter(m -> m.appliesToArgs(argTypes)).collect(Collectors.toList());
            if (andMatchArgType.size() == 1) {
                SoyMethod method = (SoyMethod)andMatchArgCount.get(0);
                PluginResolver.warnIfDeprecated(ResolveExpressionTypesPass.this.errorReporter, methodName, method, srcLoc);
                return method;
            }
            if (!andMatchArgType.isEmpty()) {
                ResolveExpressionTypesPass.this.errorReporter.report(srcLoc, MULTIPLE_METHODS_MATCH, methodName, numParams, baseType);
            } else if (!andMatchArgCount.isEmpty()) {
                String expected = Joiner.on((String)", ").join(((SoySourceFunctionMethod)andMatchArgCount.get(0)).getArgTypes());
                String actual = Joiner.on((String)", ").join(argTypes);
                ResolveExpressionTypesPass.this.errorReporter.report(srcLoc, METHOD_INVALID_PARAM_TYPES, methodName, actual, expected);
            } else {
                String didYouMean = "";
                HashSet<String> matching = new HashSet<String>((Collection<String>)ResolveExpressionTypesPass.this.methodRegistry.matchForBaseAndArgs(baseType, argTypes).values());
                if (!matching.isEmpty()) {
                    didYouMean = SoyErrors.getDidYouMeanMessage(matching, methodName);
                }
                if (ResolveExpressionTypesPass.this.pluginResolutionMode == PluginResolver.Mode.REQUIRE_DEFINITIONS) {
                    ResolveExpressionTypesPass.this.errorReporter.report(srcLoc, INVALID_METHOD_BASE, methodName, baseType, didYouMean);
                } else if (ResolveExpressionTypesPass.this.pluginResolutionMode == PluginResolver.Mode.ALLOW_UNDEFINED_AND_WARN) {
                    ResolveExpressionTypesPass.this.errorReporter.warn(srcLoc, INVALID_METHOD_BASE, methodName, baseType, didYouMean);
                }
            }
            return null;
        }

        @Override
        protected void visitGlobalNode(GlobalNode node) {
        }

        @Override
        protected void visitNegativeOpNode(OperatorNodes.NegativeOpNode node) {
            this.visitChildren(node);
            SoyType childType = node.getChild(0).getType();
            if (SoyTypes.isNumericOrUnknown(childType)) {
                node.setType(childType);
            } else {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getOperatorLocation(), INCOMPATIBLE_ARITHMETIC_OP_UNARY, childType);
                node.setType(UnknownType.getInstance());
            }
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitNotOpNode(OperatorNodes.NotOpNode node) {
            this.visitChildren(node);
            node.setType(BoolType.getInstance());
        }

        @Override
        protected void visitTimesOpNode(OperatorNodes.TimesOpNode node) {
            this.visitArithmeticOpNode(node);
        }

        @Override
        protected void visitDivideByOpNode(OperatorNodes.DivideByOpNode node) {
            this.visitArithmeticOpNode(node);
        }

        @Override
        protected void visitModOpNode(OperatorNodes.ModOpNode node) {
            this.visitArithmeticOpNode(node);
        }

        @Override
        protected void visitPlusOpNode(OperatorNodes.PlusOpNode node) {
            this.visitChildren(node);
            SoyType left = node.getChild(0).getType();
            SoyType right = node.getChild(1).getType();
            SoyType result = SoyTypes.getSoyTypeForBinaryOperator(left, right, new SoyTypes.SoyTypePlusOperator());
            if (result == null) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getOperatorLocation(), INCOMPATIBLE_ARITHMETIC_OP, left, right);
                result = UnknownType.getInstance();
            }
            node.setType(result);
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitMinusOpNode(OperatorNodes.MinusOpNode node) {
            this.visitArithmeticOpNode(node);
        }

        @Override
        protected void visitLessThanOpNode(OperatorNodes.LessThanOpNode node) {
            this.visitComparisonOpNode(node);
        }

        @Override
        protected void visitGreaterThanOpNode(OperatorNodes.GreaterThanOpNode node) {
            this.visitComparisonOpNode(node);
        }

        @Override
        protected void visitLessThanOrEqualOpNode(OperatorNodes.LessThanOrEqualOpNode node) {
            this.visitComparisonOpNode(node);
        }

        @Override
        protected void visitGreaterThanOrEqualOpNode(OperatorNodes.GreaterThanOrEqualOpNode node) {
            this.visitComparisonOpNode(node);
        }

        @Override
        protected void visitEqualOpNode(OperatorNodes.EqualOpNode node) {
            this.visitEqualComparisonOpNode(node);
        }

        @Override
        protected void visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
            this.visitEqualComparisonOpNode(node);
        }

        @Override
        protected void visitAndOpNode(OperatorNodes.AndOpNode node) {
            this.visit(node.getChild(0));
            TypeSubstitution savedSubstitutionState = ResolveExpressionTypesPass.this.substitutions;
            TypeNarrowingConditionVisitor visitor = new TypeNarrowingConditionVisitor();
            visitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            ResolveExpressionTypesPass.this.addTypeSubstitutions(visitor.positiveTypeConstraints);
            this.visit(node.getChild(1));
            ResolveExpressionTypesPass.this.substitutions = savedSubstitutionState;
            node.setType(BoolType.getInstance());
        }

        @Override
        protected void visitOrOpNode(OperatorNodes.OrOpNode node) {
            ExprNode lhs = node.getChild(0);
            if (SoyTreeUtils.isConstantExpr(lhs)) {
                ResolveExpressionTypesPass.this.errorReporter.warn(node.getOperatorLocation(), OR_OPERATOR_HAS_CONSTANT_OPERAND, lhs.toSourceString());
            }
            this.visit(lhs);
            TypeSubstitution savedSubstitutionState = ResolveExpressionTypesPass.this.substitutions;
            TypeNarrowingConditionVisitor visitor = new TypeNarrowingConditionVisitor();
            visitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            ResolveExpressionTypesPass.this.addTypeSubstitutions(visitor.negativeTypeConstraints);
            ExprNode rhs = node.getChild(1);
            this.visit(rhs);
            if (SoyTreeUtils.isConstantExpr(rhs)) {
                ResolveExpressionTypesPass.this.errorReporter.warn(node.getOperatorLocation(), OR_OPERATOR_HAS_CONSTANT_OPERAND, rhs.toSourceString());
            }
            ResolveExpressionTypesPass.this.substitutions = savedSubstitutionState;
            node.setType(BoolType.getInstance());
        }

        @Override
        protected void visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
            this.visit(node.getChild(0));
            TypeSubstitution savedSubstitutionState = ResolveExpressionTypesPass.this.substitutions;
            TypeNarrowingConditionVisitor visitor = new TypeNarrowingConditionVisitor();
            visitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            ResolveExpressionTypesPass.this.addTypeSubstitutions(visitor.positiveTypeConstraints);
            this.visit(node.getChild(0));
            ResolveExpressionTypesPass.this.addTypeSubstitutions(visitor.negativeTypeConstraints);
            this.visit(node.getChild(1));
            ResolveExpressionTypesPass.this.substitutions = savedSubstitutionState;
            node.setType(SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, node.getChild(0).getType(), node.getChild(1).getType()));
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
            this.visit(node.getChild(0));
            TypeSubstitution savedSubstitutionState = ResolveExpressionTypesPass.this.substitutions;
            TypeNarrowingConditionVisitor visitor = new TypeNarrowingConditionVisitor();
            visitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            ResolveExpressionTypesPass.this.addTypeSubstitutions(visitor.positiveTypeConstraints);
            this.visit(node.getChild(1));
            ResolveExpressionTypesPass.this.substitutions = savedSubstitutionState;
            ResolveExpressionTypesPass.this.addTypeSubstitutions(visitor.negativeTypeConstraints);
            this.visit(node.getChild(2));
            ResolveExpressionTypesPass.this.substitutions = savedSubstitutionState;
            node.setType(SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, node.getChild(1).getType(), node.getChild(2).getType()));
            this.tryApplySubstitution(node);
        }

        @Nullable
        private ResolvedSignature getOrCreateFunctionSignature(Signature signature, String className, ErrorReporter errorReporter) {
            ResolvedSignature resolvedSignature = (ResolvedSignature)ResolveExpressionTypesPass.this.signatureMap.get(signature);
            if (resolvedSignature != null) {
                return resolvedSignature;
            }
            ImmutableList.Builder paramTypes = ImmutableList.builder();
            SourceFilePath classFilePath = SourceFilePath.create(className);
            for (String paramTypeString : signature.parameterTypes()) {
                TypeNode paramType = SoyFileParser.parseType(paramTypeString, classFilePath, errorReporter);
                if (paramType == null) {
                    return null;
                }
                paramTypes.add((Object)ResolveExpressionTypesPass.this.pluginTypeConverter.getOrCreateType(paramType));
            }
            TypeNode returnType = SoyFileParser.parseType(signature.returnType(), classFilePath, errorReporter);
            if (returnType == null) {
                return null;
            }
            resolvedSignature = ResolvedSignature.create((ImmutableList<SoyType>)paramTypes.build(), ResolveExpressionTypesPass.this.pluginTypeConverter.getOrCreateType(returnType));
            ResolveExpressionTypesPass.this.signatureMap.put(signature, resolvedSignature);
            return resolvedSignature;
        }

        @Override
        protected void visitFunctionNode(FunctionNode node) {
            this.visitChildren(node);
            Object knownFunction = node.getSoyFunction();
            if (knownFunction.getClass().isAnnotationPresent(SoyFunctionSignature.class)) {
                Preconditions.checkState((knownFunction instanceof TypedSoyFunction || knownFunction instanceof SoySourceFunction ? 1 : 0) != 0, (Object)"Classes annotated with @SoyFunctionSignature must either extend TypedSoyFunction or implement SoySourceFunction.");
                this.visitSoyFunctionWithSignature(knownFunction.getClass().getAnnotation(SoyFunctionSignature.class), knownFunction.getClass().getCanonicalName(), node);
            } else if (knownFunction instanceof BuiltinFunction) {
                this.visitBuiltinFunction((BuiltinFunction)knownFunction, node);
            }
            this.visitInternalSoyFunction(knownFunction, node);
            this.tryApplySubstitution(node);
            if (node.getParamsStyle() == ExprNode.CallableExpr.ParamsStyle.POSITIONAL && node.getAllowedParamTypes() == null) {
                node.setAllowedParamTypes(Collections.nCopies(node.numChildren(), UnknownType.getInstance()));
            }
        }

        private void visitSoyFunctionWithSignature(SoyFunctionSignature fnSignature, String className, FunctionNode node) {
            ResolvedSignature matchedSignature = null;
            for (Signature signature : fnSignature.value()) {
                if (signature.parameterTypes().length != node.numChildren()) continue;
                matchedSignature = this.getOrCreateFunctionSignature(signature, className, ResolveExpressionTypesPass.this.errorReporter);
                break;
            }
            if (matchedSignature == null) {
                node.setType(UnknownType.getInstance());
                return;
            }
            if (node.getParamsStyle() == ExprNode.CallableExpr.ParamsStyle.NAMED) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getFunctionNameLocation(), INCORRECT_ARG_STYLE, new Object[0]);
                return;
            }
            for (int i = 0; i < node.numChildren(); ++i) {
                this.checkArgType(node.getChild(i), (SoyType)matchedSignature.parameterTypes().get(i), node);
            }
            node.setAllowedParamTypes((List<SoyType>)matchedSignature.parameterTypes());
            node.setType(matchedSignature.returnType());
        }

        private void visitKeysFunction(FunctionNode node) {
            ListType listType;
            SoyType argType = node.getChild(0).getType();
            if (argType.equals(LegacyObjectMapType.EMPTY_MAP)) {
                listType = ListType.EMPTY_LIST;
            } else {
                SoyType listArg;
                if (argType.getKind() == SoyType.Kind.LEGACY_OBJECT_MAP) {
                    listArg = ((LegacyObjectMapType)argType).getKeyType();
                } else if (argType.getKind() == SoyType.Kind.LIST) {
                    listArg = IntType.getInstance();
                } else if (argType.getKind() == SoyType.Kind.MAP) {
                    ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), KEYS_PASSED_MAP, new Object[0]);
                    listArg = UnknownType.getInstance();
                } else {
                    listArg = UnknownType.getInstance();
                }
                listType = ResolveExpressionTypesPass.this.typeRegistry.getOrCreateListType(listArg);
            }
            node.setType(listType);
        }

        private void visitMapKeysFunction(FunctionNode node) {
            SoyType argType = node.getChild(0).getType();
            if (argType.equals(MapType.EMPTY_MAP)) {
                node.setType(ListType.EMPTY_LIST);
            } else {
                node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateListType(((MapType)argType).getKeyType()));
            }
        }

        private void visitLegacyObjectMapToMapFunction(FunctionNode node) {
            SoyType argType = node.getChild(0).getType();
            if (argType.equals(LegacyObjectMapType.EMPTY_MAP)) {
                node.setType(MapType.EMPTY_MAP);
            } else if (argType == UnknownType.getInstance()) {
                node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateMapType(StringType.getInstance(), UnknownType.getInstance()));
            } else {
                LegacyObjectMapType actualArgType = (LegacyObjectMapType)argType;
                node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateMapType(StringType.getInstance(), actualArgType.getValueType()));
            }
        }

        private void visitMapToLegacyObjectMapFunction(FunctionNode node) {
            SoyType argType = node.getChild(0).getType();
            if (argType.equals(MapType.EMPTY_MAP)) {
                node.setType(LegacyObjectMapType.EMPTY_MAP);
            } else {
                MapType actualArgType = (MapType)argType;
                node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateLegacyObjectMapType(StringType.getInstance(), actualArgType.getValueType()));
            }
        }

        private void visitProtoInitFunction(FunctionNode node) {
            SoyType soyType = ((FunctionNode)node).getNameExpr().getType();
            if (soyType.getKind() != SoyType.Kind.PROTO_TYPE) {
                ResolveExpressionTypesPass.this.errorReporter.report(((FunctionNode)node).getNameExpr().getSourceLocation(), NOT_PROTO_MESSAGE, new Object[0]);
                ((AbstractParentExprNode)node).setType(UnknownType.getInstance());
                return;
            }
            ProtoImportType type = (ProtoImportType)((FunctionNode)node).getNameExpr().getType();
            String protoFqn = type.toString();
            if (SoyTypes.SAFE_PROTO_TO_SANITIZED_TYPE.containsKey((Object)protoFqn)) {
                ResolveExpressionTypesPass.this.errorReporter.report(((AbstractExprNode)node).getSourceLocation(), TypeNodeConverter.SAFE_PROTO_TYPE, SoyTypes.SAFE_PROTO_TO_SANITIZED_TYPE.get((Object)protoFqn), protoFqn);
                ((AbstractParentExprNode)node).setType(UnknownType.getInstance());
                return;
            }
            SoyProtoType protoType = (SoyProtoType)ResolveExpressionTypesPass.this.typeRegistry.getProtoRegistry().getProtoType(protoFqn);
            ((AbstractParentExprNode)node).setType(protoType);
            HashSet<String> givenParams = new HashSet<String>();
            ImmutableSet<String> fields = protoType.getFieldNames();
            boolean hasAliasedParams = false;
            ArrayList<Identifier> resolvedIdentifiers = new ArrayList<Identifier>();
            for (Identifier id : ((FunctionNode)node).getParamNames()) {
                String originalName = id.identifier();
                boolean hasOriginal = fields.contains((Object)originalName);
                boolean hasOriginalExt = hasOriginal && protoType.getFieldDescriptor(originalName).isExtension();
                Identifier resolvedName = ResolveExpressionTypesPass.this.typeRegistry.resolve(id);
                if (resolvedName == null) {
                    if (hasOriginalExt) {
                        ResolveExpressionTypesPass.this.errorReporter.report(id.location(), PROTO_EXT_FQN, new Object[0]);
                    }
                } else if (!resolvedName.identifier().equals(originalName)) {
                    if (hasOriginal && !hasOriginalExt) {
                        ResolveExpressionTypesPass.this.errorReporter.report(id.location(), PROTO_FIELD_NAME_ALIAS_CONFLICT, originalName, protoType.getDescriptor().getName());
                        ((AbstractParentExprNode)node).setType(UnknownType.getInstance());
                        continue;
                    }
                    hasAliasedParams = true;
                    id = resolvedName;
                }
                resolvedIdentifiers.add(id);
                givenParams.add(id.identifier());
            }
            if (hasAliasedParams) {
                FunctionNode resolvedNode = CallableExprBuilder.builder((FunctionNode)node).setParamNames(resolvedIdentifiers).buildFunction();
                resolvedNode.setSoyFunction(((FunctionNode)node).getSoyFunction());
                resolvedNode.setType(((AbstractParentExprNode)node).getType());
                ((AbstractExprNode)node).getParent().replaceChild(node, resolvedNode);
                node = resolvedNode;
            }
            for (String field : fields) {
                if (!protoType.getFieldDescriptor(field).isRequired() || givenParams.contains(field)) continue;
                ResolveExpressionTypesPass.this.errorReporter.report(((AbstractExprNode)node).getSourceLocation(), PROTO_MISSING_REQUIRED_FIELD, field);
            }
            for (int i = 0; i < ((AbstractParentExprNode)node).numChildren(); ++i) {
                SoyType argElementType;
                SoyType fieldType;
                Identifier fieldName = (Identifier)((FunctionNode)node).getParamNames().get(i);
                ExprNode expr = ((AbstractParentExprNode)node).getChild(i);
                if (!fields.contains((Object)fieldName.identifier())) {
                    String extraErrorMessage = SoyErrors.getDidYouMeanMessageForProtoFields(fields, protoType.getDescriptor(), fieldName.identifier());
                    ResolveExpressionTypesPass.this.errorReporter.report(fieldName.location(), PROTO_FIELD_DOES_NOT_EXIST, fieldName.identifier(), protoType, extraErrorMessage);
                    continue;
                }
                SoyType argType = expr.getType();
                if (argType.equals(NullType.getInstance())) {
                    ResolveExpressionTypesPass.this.errorReporter.report(expr.getSourceLocation(), PROTO_NULL_ARG_TYPE, fieldName.identifier());
                }
                if ((fieldType = protoType.getFieldType(fieldName.identifier())).getKind() == SoyType.Kind.LIST && argType.getKind() == SoyType.Kind.LIST && ((argElementType = ((ListType)argType).getElementType()) == null || argElementType.equals(UnknownType.getInstance()))) continue;
                SoyType expectedType = SoyTypes.makeNullable(fieldType);
                if (!expectedType.isAssignableFromLoose(argType)) {
                    argType = RuntimeTypeCoercion.maybeCoerceType(expr, expectedType instanceof UnionType ? ((UnionType)expectedType).getMembers() : ImmutableList.of((Object)expectedType));
                }
                if (expectedType.isAssignableFromLoose(argType)) continue;
                ResolveExpressionTypesPass.this.errorReporter.report(expr.getSourceLocation(), CheckTemplateCallsPass.ARGUMENT_TYPE_MISMATCH, fieldName.identifier(), expectedType, argType);
            }
        }

        @Override
        protected void visitVeLiteralNode(VeLiteralNode node) {
            SoyType type;
            ValidatedLoggingConfig.ValidatedLoggableElement config = ResolveExpressionTypesPass.this.loggingConfig.getElement(node.getName().identifier());
            if (config == null) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getName().location(), VE_NO_CONFIG_FOR_ELEMENT, SoyErrors.getDidYouMeanMessage(ResolveExpressionTypesPass.this.loggingConfig.allKnownIdentifiers(), node.getName().identifier()));
                type = UnknownType.getInstance();
            } else {
                if (ResolveExpressionTypesPass.this.importIndex.containsKey((Object)node.getName().identifier())) {
                    ResolveExpressionTypesPass.this.errorReporter.report(node.getName().location(), VE_CONFLICTS_WITH_TYPE, ((ImportedVar)ResolveExpressionTypesPass.this.importIndex.get((Object)node.getName().identifier())).nameLocation().getBeginLine());
                }
                type = config.getProtoName().isPresent() ? ResolveExpressionTypesPass.this.typeRegistry.getOrCreateVeType(config.getProtoName().get()) : VeType.NO_DATA;
                node.setLoggableElement(config);
            }
            node.setType(type);
        }

        @Override
        protected void visitTemplateLiteralNode(TemplateLiteralNode node) {
            if (this.isDefaultInitializerForInferredParam) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), TEMPLATE_TYPE_PARAMETERS_CANNOT_USE_INFERRED_TYPES, new Object[0]);
            }
        }

        private void visitComparisonOpNode(AbstractOperatorNode node) {
            this.visitChildren(node);
            SoyType left = node.getChild(0).getType();
            SoyType right = node.getChild(1).getType();
            SoyType result = SoyTypes.getSoyTypeForBinaryOperator(left, right, new SoyTypes.SoyTypeComparisonOp());
            if (result == null) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getOperatorLocation(), TYPE_MISMATCH, left, right);
            }
            node.setType(BoolType.getInstance());
        }

        private void visitEqualComparisonOpNode(AbstractOperatorNode node) {
            this.visitChildren(node);
            SoyType left = node.getChild(0).getType();
            SoyType right = node.getChild(1).getType();
            SoyType result = SoyTypes.getSoyTypeForBinaryOperator(left, right, new SoyTypes.SoyTypeEqualComparisonOp());
            if (result == null) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getOperatorLocation(), TYPE_MISMATCH, left, right);
            }
            node.setType(BoolType.getInstance());
        }

        private void visitArithmeticOpNode(AbstractOperatorNode node) {
            this.visitChildren(node);
            boolean isDivide = node instanceof OperatorNodes.DivideByOpNode;
            SoyType left = node.getChild(0).getType();
            SoyType right = node.getChild(1).getType();
            SoyType result = SoyTypes.getSoyTypeForBinaryOperator(left, right, new SoyTypes.SoyTypeArithmeticOperator());
            if (result == null) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getOperatorLocation(), INCOMPATIBLE_ARITHMETIC_OP, left, right);
                result = UnknownType.getInstance();
            }
            node.setType(isDivide ? FloatType.getInstance() : result);
            this.tryApplySubstitution(node);
        }

        private void requireNodeType(ExprNode node) {
            if (node.getType() == null) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), MISSING_SOY_TYPE, node.getClass().getName());
            }
        }

        private SoyType getFieldType(SoyType baseType, String fieldName, SourceLocation sourceLocation) {
            Preconditions.checkNotNull((Object)baseType);
            switch (baseType.getKind()) {
                case UNKNOWN: {
                    return UnknownType.getInstance();
                }
                case RECORD: {
                    RecordType recordType = (RecordType)baseType;
                    SoyType fieldType = recordType.getMemberType(fieldName);
                    if (fieldType != null) {
                        return fieldType;
                    }
                    String extraErrorMessage = SoyErrors.getDidYouMeanMessage(recordType.getMemberNames(), fieldName);
                    ResolveExpressionTypesPass.this.errorReporter.report(sourceLocation, UNDEFINED_FIELD_FOR_RECORD_TYPE, fieldName, baseType, extraErrorMessage);
                    return UnknownType.getInstance();
                }
                case PROTO: {
                    SoyProtoType protoType = (SoyProtoType)baseType;
                    SoyType fieldType = protoType.getFieldType(fieldName);
                    if (fieldType != null) {
                        return fieldType;
                    }
                    String extraErrorMessage = SoyErrors.getDidYouMeanMessageForProtoFields(protoType.getFieldNames(), protoType.getDescriptor(), fieldName);
                    ResolveExpressionTypesPass.this.errorReporter.report(sourceLocation, UNDEFINED_FIELD_FOR_PROTO_TYPE, fieldName, baseType, extraErrorMessage);
                    return UnknownType.getInstance();
                }
                case LEGACY_OBJECT_MAP: {
                    ResolveExpressionTypesPass.this.errorReporter.report(sourceLocation, DOT_ACCESS_NOT_SUPPORTED_CONSIDER_RECORD, baseType);
                    return UnknownType.getInstance();
                }
                case UNION: {
                    ErrorReporter.Checkpoint cp = ResolveExpressionTypesPass.this.errorReporter.checkpoint();
                    UnionType unionType = (UnionType)baseType;
                    ArrayList<SoyType> fieldTypes = new ArrayList<SoyType>(unionType.getMembers().size());
                    for (SoyType unionMember : unionType.getMembers()) {
                        if (unionMember.getKind() == SoyType.Kind.NULL) continue;
                        SoyType fieldType = this.getFieldType(unionMember, fieldName, sourceLocation);
                        if (ResolveExpressionTypesPass.this.errorReporter.errorsSince(cp)) {
                            return fieldType;
                        }
                        fieldTypes.add(fieldType);
                    }
                    return SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, fieldTypes);
                }
                case STRING: 
                case CSS: 
                case JS: 
                case ATTRIBUTES: 
                case ELEMENT: 
                case HTML: 
                case URI: {
                    if (fieldName.equals("length")) {
                        ResolveExpressionTypesPass.this.errorReporter.report(sourceLocation, STRING_LENGTH_ERROR, new Object[0]);
                        return UnknownType.getInstance();
                    }
                }
                case LIST: {
                    if (fieldName.equals("length")) {
                        ResolveExpressionTypesPass.this.errorReporter.report(sourceLocation, LIST_LENGTH_ERROR, new Object[0]);
                        return UnknownType.getInstance();
                    }
                }
                case ANY: 
                case NULL: 
                case BOOL: 
                case INT: 
                case FLOAT: 
                case TRUSTED_RESOURCE_URI: 
                case MAP: 
                case NAMED_TEMPLATE: 
                case PROTO_ENUM: 
                case TEMPLATE: 
                case VE: 
                case VE_DATA: 
                case MESSAGE: 
                case TEMPLATE_TYPE: 
                case TEMPLATE_MODULE: {
                    ResolveExpressionTypesPass.this.errorReporter.report(sourceLocation, DOT_ACCESS_NOT_SUPPORTED, baseType);
                    return UnknownType.getInstance();
                }
                case PROTO_TYPE: {
                    return UnknownType.getInstance();
                }
            }
            throw new AssertionError((Object)("unhandled kind: " + (Object)((Object)baseType.getKind())));
        }

        private SoyType getItemType(SoyType baseType, SoyType keyType, boolean isNullSafe, SourceLocation baseLocation, SourceLocation keyLocation) {
            Preconditions.checkNotNull((Object)baseType);
            Preconditions.checkNotNull((Object)keyType);
            switch (baseType.getKind()) {
                case UNKNOWN: {
                    return UnknownType.getInstance();
                }
                case LIST: {
                    ListType listType = (ListType)baseType;
                    if (listType.equals(ListType.EMPTY_LIST)) {
                        ResolveExpressionTypesPass.this.errorReporter.report(baseLocation, EMPTY_LIST_ACCESS, new Object[0]);
                        return UnknownType.getInstance();
                    }
                    if (!IntType.getInstance().isAssignableFromLoose(keyType)) {
                        ResolveExpressionTypesPass.this.errorReporter.report(keyLocation, BAD_INDEX_TYPE, keyType, baseType);
                    }
                    return listType.getElementType();
                }
                case LEGACY_OBJECT_MAP: 
                case MAP: {
                    AbstractMapType mapType = (AbstractMapType)baseType;
                    if (mapType.equals(LegacyObjectMapType.EMPTY_MAP) || mapType.equals(MapType.EMPTY_MAP)) {
                        ResolveExpressionTypesPass.this.errorReporter.report(baseLocation, EMPTY_MAP_ACCESS, new Object[0]);
                        return UnknownType.getInstance();
                    }
                    if (!mapType.getKeyType().isAssignableFromLoose(keyType)) {
                        ResolveExpressionTypesPass.this.errorReporter.report(keyLocation, BAD_KEY_TYPE, keyType, baseType);
                    }
                    return mapType.getValueType();
                }
                case UNION: {
                    ErrorReporter.Checkpoint cp = ResolveExpressionTypesPass.this.errorReporter.checkpoint();
                    UnionType unionType = (UnionType)baseType;
                    ArrayList<SoyType> itemTypes = new ArrayList<SoyType>(unionType.getMembers().size());
                    for (SoyType unionMember : unionType.getMembers()) {
                        if (unionMember.equals(NullType.getInstance())) continue;
                        SoyType itemType = this.getItemType(unionMember, keyType, isNullSafe, baseLocation, keyLocation);
                        if (ResolveExpressionTypesPass.this.errorReporter.errorsSince(cp)) {
                            return itemType;
                        }
                        itemTypes.add(itemType);
                    }
                    if (unionType.isNullable() && !isNullSafe) {
                        ResolveExpressionTypesPass.this.errorReporter.report(baseLocation, BRACKET_ACCESS_NULLABLE_UNION, new Object[0]);
                        return UnknownType.getInstance();
                    }
                    return SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, itemTypes);
                }
                case RECORD: 
                case PROTO: 
                case STRING: 
                case CSS: 
                case JS: 
                case ATTRIBUTES: 
                case ELEMENT: 
                case HTML: 
                case URI: 
                case ANY: 
                case NULL: 
                case BOOL: 
                case INT: 
                case FLOAT: 
                case TRUSTED_RESOURCE_URI: 
                case NAMED_TEMPLATE: 
                case PROTO_ENUM: 
                case TEMPLATE: 
                case VE: 
                case VE_DATA: 
                case MESSAGE: 
                case TEMPLATE_TYPE: 
                case TEMPLATE_MODULE: 
                case PROTO_TYPE: 
                case PROTO_EXTENSION: 
                case PROTO_MODULE: 
                case PROTO_ENUM_TYPE: {
                    ResolveExpressionTypesPass.this.errorReporter.report(baseLocation, BRACKET_ACCESS_NOT_SUPPORTED, baseType);
                    return UnknownType.getInstance();
                }
            }
            throw new AssertionError((Object)("unhandled kind: " + (Object)((Object)baseType.getKind())));
        }

        private void tryApplySubstitution(AbstractParentExprNode parentNode) {
            SoyType newType = this.getTypeSubstitution(parentNode);
            if (newType != null) {
                if (!parentNode.getType().isAssignableFromStrict(newType)) {
                    ResolveExpressionTypesPass.this.errorReporter.report(parentNode.getSourceLocation(), INVALID_TYPE_SUBSTITUTION, parentNode.getType(), newType);
                }
                parentNode.setType(newType);
            }
        }

        @Nullable
        private SoyType getTypeSubstitution(ExprNode expr) {
            TypeSubstitution subst = ResolveExpressionTypesPass.this.substitutions;
            while (subst != null) {
                if (ResolveExpressionTypesPass.this.exprEquivalence.equivalent(subst.expression, expr)) {
                    return subst.type;
                }
                subst = subst.parent;
            }
            return null;
        }

        private void visitBuiltinFunction(BuiltinFunction builtinFunction, FunctionNode node) {
            switch (builtinFunction) {
                case CHECK_NOT_NULL: {
                    SoyType type = node.getChild(0).getType();
                    if (type.equals(NullType.getInstance())) {
                        ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), CHECK_NOT_NULL_ON_COMPILE_TIME_NULL, "call checkNotNull");
                        break;
                    }
                    node.setType(SoyTypes.removeNull(type));
                    break;
                }
                case INDEX: {
                    this.requireLoopVariableInScope(node, 0);
                    node.setType(IntType.getInstance());
                    break;
                }
                case IS_PRIMARY_MSG_IN_USE: {
                    node.setType(BoolType.getInstance());
                    break;
                }
                case IS_FIRST: 
                case IS_LAST: {
                    this.requireLoopVariableInScope(node, 0);
                    node.setType(BoolType.getInstance());
                    break;
                }
                case CSS: {
                    this.checkArgIsStringLiteral(node, node.numChildren() - 1, builtinFunction);
                    node.setType(StringType.getInstance());
                    break;
                }
                case SOY_SERVER_KEY: 
                case XID: {
                    node.setType(StringType.getInstance());
                    break;
                }
                case UNKNOWN_JS_GLOBAL: {
                    this.checkArgIsStringLiteral(node, 0, builtinFunction);
                    node.setType(UnknownType.getInstance());
                    break;
                }
                case IS_PARAM_SET: 
                case DEBUG_SOY_TEMPLATE_INFO: {
                    node.setType(BoolType.getInstance());
                    break;
                }
                case VE_DATA: {
                    node.setType(VeDataType.getInstance());
                    break;
                }
                case TO_FLOAT: 
                case REMAINDER: {
                    node.setType(IntType.getInstance());
                    break;
                }
                case MSG_WITH_ID: {
                    node.setType(RecordType.of((ImmutableMap<String, ? extends SoyType>)ImmutableMap.of((Object)"id", (Object)StringType.getInstance(), (Object)"msg", (Object)(node.numChildren() > 0 ? node.getChild(0).getType() : UnknownType.getInstance()))));
                    break;
                }
                case LEGACY_DYNAMIC_TAG: {
                    node.setType(StringType.getInstance());
                    break;
                }
                case PROTO_INIT: {
                    this.visitProtoInitFunction(node);
                    break;
                }
                case TEMPLATE: {
                    node.setType(UnknownType.getInstance());
                }
            }
        }

        private void checkArgIsStringLiteral(FunctionNode node, int childIndex, BuiltinFunction funcName) {
            if (childIndex < 0 || childIndex >= node.numChildren()) {
                return;
            }
            ExprNode arg = node.getChild(childIndex);
            if (!(arg instanceof StringNode)) {
                ResolveExpressionTypesPass.this.errorReporter.report(arg.getSourceLocation(), STRING_LITERAL_REQUIRED, funcName.getName());
            }
        }

        private void visitInternalSoyFunction(Object fn, FunctionNode node) {
            if (fn instanceof LegacyObjectMapToMapFunction) {
                if (this.checkArgType(node.getChild(0), LegacyObjectMapType.ANY_MAP, node)) {
                    this.visitLegacyObjectMapToMapFunction(node);
                } else {
                    node.setType(UnknownType.getInstance());
                }
            } else if (fn instanceof MapToLegacyObjectMapFunction) {
                if (this.checkArgType(node.getChild(0), MapType.ANY_MAP, node, UnknownPolicy.DISALLOWED)) {
                    this.visitMapToLegacyObjectMapFunction(node);
                } else {
                    node.setType(UnknownType.getInstance());
                }
            } else if (fn instanceof KeysFunction) {
                this.visitKeysFunction(node);
            } else if (fn instanceof MapKeysFunction) {
                if (this.checkArgType(node.getChild(0), MapType.ANY_MAP, node, UnknownPolicy.DISALLOWED)) {
                    this.visitMapKeysFunction(node);
                } else {
                    node.setType(UnknownType.getInstance());
                }
            } else if (fn instanceof ConcatListsFunction) {
                node.setType(this.getGenericListType(node.getChildren()));
            } else if (fn instanceof LoggingFunction) {
                node.setType(StringType.getInstance());
            } else if (fn instanceof MaxFunction || fn instanceof MinFunction) {
                if (node.getChildren().size() > 1) {
                    node.setType(SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, node.getChild(0).getType(), node.getChild(1).getType()));
                }
            } else if (node.getType() == null) {
                node.setType(UnknownType.getInstance());
            }
        }

        private SoyType getGenericListType(Iterable<ExprNode> intersectionOf) {
            ImmutableSet.Builder elementTypesBuilder = ImmutableSet.builder();
            for (ExprNode childNode : intersectionOf) {
                if (!(childNode.getType() instanceof ListType)) {
                    return UnknownType.getInstance();
                }
                SoyType elementType = ((ListType)childNode.getType()).getElementType();
                if (elementType == null) continue;
                elementTypesBuilder.add((Object)elementType);
            }
            ImmutableSet elementTypes = elementTypesBuilder.build();
            return elementTypes.isEmpty() ? ListType.EMPTY_LIST : ResolveExpressionTypesPass.this.typeRegistry.getOrCreateListType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateUnionType((Collection<SoyType>)elementTypes));
        }

        private SoyType getGenericMapType(Iterable<ExprNode> intersectionOf) {
            ImmutableSet.Builder keyTypesBuilder = ImmutableSet.builder();
            ImmutableSet.Builder valueTypesBuilder = ImmutableSet.builder();
            for (ExprNode childNode : intersectionOf) {
                if (!(childNode.getType() instanceof MapType)) {
                    return UnknownType.getInstance();
                }
                MapType mapType = (MapType)childNode.getType();
                if (mapType.getKeyType() != null) {
                    keyTypesBuilder.add((Object)mapType.getKeyType());
                }
                if (mapType.getValueType() == null) continue;
                valueTypesBuilder.add((Object)mapType.getValueType());
            }
            ImmutableSet keys = keyTypesBuilder.build();
            ImmutableSet values = valueTypesBuilder.build();
            return MapType.of(keys.isEmpty() ? UnknownType.getInstance() : ResolveExpressionTypesPass.this.typeRegistry.getOrCreateUnionType((Collection<SoyType>)keys), values.isEmpty() ? UnknownType.getInstance() : ResolveExpressionTypesPass.this.typeRegistry.getOrCreateUnionType((Collection<SoyType>)values));
        }

        private void requireLoopVariableInScope(FunctionNode fn, int childIndex) {
            if (childIndex < 0 || childIndex >= fn.numChildren()) {
                return;
            }
            ExprNode loopVariable = fn.getChild(childIndex);
            if (!(loopVariable instanceof VarRefNode && ((VarRefNode)loopVariable).getDefnDecl() instanceof LocalVar && ((LocalVar)((VarRefNode)loopVariable).getDefnDecl()).declaringNode() instanceof ForNonemptyNode)) {
                ResolveExpressionTypesPass.this.errorReporter.report(fn.getSourceLocation(), LOOP_VARIABLE_NOT_IN_SCOPE, fn.getStaticFunctionName());
            }
        }

        private boolean checkArgType(ExprNode arg, SoyType expectedType, FunctionNode node) {
            return this.checkArgType(arg, expectedType, node, UnknownPolicy.ALLOWED);
        }

        private boolean checkArgType(ExprNode arg, SoyType expectedType, FunctionNode node, UnknownPolicy policy) {
            if (!expectedType.isAssignableFromLoose(arg.getType()) || policy == UnknownPolicy.DISALLOWED && arg.getType() == UnknownType.getInstance()) {
                ResolveExpressionTypesPass.this.errorReporter.report(arg.getSourceLocation(), INCORRECT_ARG_TYPE, node.getStaticFunctionName(), arg.getType(), expectedType);
                return false;
            }
            return true;
        }
    }

    private final class TypeAssignmentSoyVisitor
    extends AbstractSoyNodeVisitor<Void> {
        private TypeAssignmentSoyVisitor() {
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            ImmutableList<TemplateHeaderVarDefn> headerVars = node.getHeaderParams();
            for (TemplateHeaderVarDefn headerVar : headerVars) {
                if (headerVar.defaultValue() == null) continue;
                block5: for (ExprNode nonConstantChild : SoyTreeUtils.getNonConstantChildren(headerVar.defaultValue())) {
                    String extra;
                    switch (nonConstantChild.getKind()) {
                        case VAR_REF_NODE: {
                            VarRefNode refNode = (VarRefNode)nonConstantChild;
                            if (headerVar instanceof TemplateStateVar) {
                                if (!(refNode.getDefnDecl() instanceof TemplateStateVar)) continue block5;
                                extra = "State cannot be referenced in default initializers";
                            } else {
                                extra = "Default parameters cannot depend on other parameters or state";
                            }
                            refNode.setSubstituteType(UnknownType.getInstance());
                            break;
                        }
                        case FUNCTION_NODE: {
                            if (headerVar instanceof TemplateStateVar) continue block5;
                            extra = "Only pure functions can be used in default param initializers";
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Unexpected non-constant expression: " + nonConstantChild));
                        }
                    }
                    ResolveExpressionTypesPass.this.errorReporter.report(nonConstantChild.getSourceLocation(), STATE_MUST_BE_CONSTANT, headerVar.name(), extra);
                }
            }
            for (TemplateHeaderVarDefn headerVar : headerVars) {
                if (headerVar.getTypeNode() != null && NullType.getInstance().equals(headerVar.type())) {
                    ResolveExpressionTypesPass.this.errorReporter.report(headerVar.getTypeNode().sourceLocation(), EXPLICIT_NULL, new Object[0]);
                }
                if (headerVar.defaultValue() == null) continue;
                new ResolveTypesExprVisitor(headerVar.getTypeNode() == null, node).exec(headerVar.defaultValue());
                SoyType actualType = headerVar.defaultValue().getRoot().getType();
                if (headerVar.getTypeNode() != null) {
                    SoyType declaredType = headerVar.type();
                    if (SoyTypes.transitivelyContainsKind(declaredType, SoyType.Kind.TEMPLATE) && SoyTypes.transitivelyContainsKind(actualType, SoyType.Kind.NAMED_TEMPLATE)) continue;
                    if (!declaredType.isAssignableFromStrict(actualType)) {
                        actualType = RuntimeTypeCoercion.maybeCoerceType(headerVar.defaultValue().getRoot(), SoyTypes.expandUnions(declaredType));
                    }
                    if (declaredType.isAssignableFromStrict(actualType)) continue;
                    ResolveExpressionTypesPass.this.errorReporter.report(headerVar.defaultValue().getSourceLocation(), DECLARED_DEFAULT_TYPE_MISMATCH, headerVar.name(), actualType, declaredType);
                    continue;
                }
                headerVar.setType(actualType);
            }
            for (ExprRootNode expr : node.getExprList()) {
                if (expr.getType() != null) continue;
                new ResolveTypesExprVisitor(false, node).exec(expr);
            }
            this.visitChildren(node);
        }

        @Override
        protected void visitPrintNode(PrintNode node) {
            this.visitSoyNode(node);
        }

        @Override
        protected void visitConstNode(ConstNode node) {
            this.visitSoyNode(node);
            node.getVar().setType(node.getExpr().getType());
        }

        @Override
        protected void visitLetValueNode(LetValueNode node) {
            this.visitSoyNode(node);
            node.getVar().setType(node.getExpr().getType());
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            this.visitSoyNode(node);
            node.getVar().setType(node.getContentKind() != null ? SanitizedType.getTypeForContentKind(node.getContentKind()) : StringType.getInstance());
        }

        @Override
        protected void visitIfNode(IfNode node) {
            TypeSubstitution savedSubstitutionState = ResolveExpressionTypesPass.this.substitutions;
            for (SoyNode child : node.getChildren()) {
                if (child instanceof IfCondNode) {
                    IfCondNode icn = (IfCondNode)child;
                    ResolveExpressionTypesPass.this.visitExpressions(icn);
                    TypeNarrowingConditionVisitor visitor = new TypeNarrowingConditionVisitor();
                    visitor.exec(icn.getExpr());
                    TypeSubstitution previousSubstitutionState = ResolveExpressionTypesPass.this.substitutions;
                    ResolveExpressionTypesPass.this.addTypeSubstitutions(visitor.positiveTypeConstraints);
                    this.visitChildren(icn);
                    ResolveExpressionTypesPass.this.substitutions = previousSubstitutionState;
                    ResolveExpressionTypesPass.this.addTypeSubstitutions(visitor.negativeTypeConstraints);
                    continue;
                }
                if (!(child instanceof IfElseNode)) continue;
                IfElseNode ien = (IfElseNode)child;
                this.visitChildren(ien);
            }
            ResolveExpressionTypesPass.this.substitutions = savedSubstitutionState;
        }

        @Override
        protected void visitSwitchNode(SwitchNode node) {
            ResolveExpressionTypesPass.this.visitExpressions(node);
            TypeSubstitution savedSubstitutionState = ResolveExpressionTypesPass.this.substitutions;
            ExprNode switchExpr = node.getExpr().getRoot();
            for (SoyNode child : node.getChildren()) {
                if (child instanceof SwitchCaseNode) {
                    SwitchCaseNode scn = (SwitchCaseNode)child;
                    ResolveExpressionTypesPass.this.visitExpressions(scn);
                    ArrayList<SoyType> caseTypes = new ArrayList<SoyType>();
                    boolean nullFound = false;
                    for (ExprRootNode expr : scn.getExprList()) {
                        caseTypes.add(expr.getType());
                        if (expr.getRoot().getKind() != ExprNode.Kind.NULL_NODE) continue;
                        nullFound = true;
                    }
                    SoyType caseType = ResolveExpressionTypesPass.this.typeRegistry.getOrCreateUnionType(caseTypes);
                    TypeSubstitution previousSubstitutionState = ResolveExpressionTypesPass.this.substitutions;
                    HashMap<ExprEquivalence.Wrapper, SoyType> positiveTypeConstraints = new HashMap<ExprEquivalence.Wrapper, SoyType>();
                    positiveTypeConstraints.put(ResolveExpressionTypesPass.this.exprEquivalence.wrap(switchExpr), caseType);
                    ResolveExpressionTypesPass.this.addTypeSubstitutions(positiveTypeConstraints);
                    this.visitChildren(scn);
                    ResolveExpressionTypesPass.this.substitutions = previousSubstitutionState;
                    if (!nullFound) continue;
                    HashMap<ExprEquivalence.Wrapper, SoyType> negativeTypeConstraints = new HashMap<ExprEquivalence.Wrapper, SoyType>();
                    negativeTypeConstraints.put(ResolveExpressionTypesPass.this.exprEquivalence.wrap(switchExpr), SoyTypes.tryRemoveNull(switchExpr.getType()));
                    ResolveExpressionTypesPass.this.addTypeSubstitutions(negativeTypeConstraints);
                    continue;
                }
                if (!(child instanceof SwitchDefaultNode)) continue;
                SwitchDefaultNode sdn = (SwitchDefaultNode)child;
                this.visitChildren(sdn);
            }
            ResolveExpressionTypesPass.this.substitutions = savedSubstitutionState;
        }

        @Override
        protected void visitForNonemptyNode(ForNonemptyNode node) {
            node.getVar().setType(ResolveExpressionTypesPass.this.getElementType(node.getExpr().getType(), node));
            if (node.getIndexVar() != null) {
                node.getIndexVar().setType(IntType.getInstance());
            }
            this.visitChildren(node);
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ExprHolderNode) {
                ResolveExpressionTypesPass.this.visitExpressions((SoyNode.ExprHolderNode)node);
            }
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }
}

