/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.LocalVariablesNodeVisitor;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.defn.UndeclaredVar;

public final class ResolveNamesPass
implements CompilerFilePass {
    private static final SoyErrorKind GLOBAL_MATCHES_VARIABLE = SoyErrorKind.of("Found global reference aliasing a local variable ''{0}'', did you mean ''${0}''?", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UKNOWN_VARIABLE = SoyErrorKind.of("Unknown variable.{0}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private final ErrorReporter errorReporter;

    public ResolveNamesPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        new LocalVariablesNodeVisitor(new Visitor()).exec(file);
    }

    private final class ResolveNamesExprVisitor
    extends LocalVariablesNodeVisitor.ExprVisitor {
        private ResolveNamesExprVisitor() {
        }

        @Override
        protected void visitGlobalNode(GlobalNode node) {
            String globalName = node.getName();
            LocalVariablesNodeVisitor.LocalVariables localVariables = this.getLocalVariables();
            VarDefn varDefn = localVariables.lookup("$" + globalName);
            if (varDefn != null) {
                node.suppressUnknownGlobalErrors();
                ResolveNamesPass.this.errorReporter.report(node.getSourceLocation(), GLOBAL_MATCHES_VARIABLE, globalName);
            }
        }

        @Override
        protected void visitVarRefNode(VarRefNode varRef) {
            if (varRef.getDefnDecl() != null) {
                return;
            }
            LocalVariablesNodeVisitor.LocalVariables localVariables = this.getLocalVariables();
            VarDefn varDefn = localVariables.lookup(varRef.getName());
            if (varDefn == null) {
                ResolveNamesPass.this.errorReporter.report(varRef.getSourceLocation(), UKNOWN_VARIABLE, SoyErrors.getDidYouMeanMessage(localVariables.allVariablesInScope(), varRef.getName()));
                varDefn = new UndeclaredVar(varRef.getName(), varRef.getSourceLocation());
            }
            varRef.setDefn(varDefn);
        }
    }

    private final class Visitor
    extends LocalVariablesNodeVisitor.NodeVisitor {
        private final ResolveNamesExprVisitor exprVisitor;

        private Visitor() {
            this.exprVisitor = new ResolveNamesExprVisitor();
        }

        @Override
        protected LocalVariablesNodeVisitor.ExprVisitor getExprVisitor() {
            return this.exprVisitor;
        }

        @Override
        protected ErrorReporter getErrorReporter() {
            return ResolveNamesPass.this.errorReporter;
        }
    }
}

