/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.exprtree.AbstractExprNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.ResolveDottedImportsPass;
import com.google.template.soy.passes.ResolveTemplateImportsPass;
import com.google.template.soy.passes.ResolveTemplateNamesPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.types.ProtoImportType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.TemplateImportType;
import java.util.List;
import java.util.stream.Collectors;

@RunAfter(value={ResolveTemplateImportsPass.class, ResolveDottedImportsPass.class})
@RunBefore(value={ResolveTemplateNamesPass.class})
final class ResolveTemplateFunctionsPass
implements CompilerFilePass {
    ResolveTemplateFunctionsPass() {
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        SoyTreeUtils.allNodesOfType(file, HtmlOpenTagNode.class).filter(tag -> !tag.getTagName().isStatic()).flatMap(tag -> SoyTreeUtils.allNodesOfType(tag.getTagName().getDynamicTagName(), FunctionNode.class)).filter(fct -> !fct.hasStaticName() && (fct.getParamsStyle() == ExprNode.CallableExpr.ParamsStyle.NONE || fct.getParamsStyle() == ExprNode.CallableExpr.ParamsStyle.NAMED)).filter(fct -> fct.getNameExpr().getKind() == ExprNode.Kind.VAR_REF_NODE).collect(Collectors.toList()).forEach(ResolveTemplateFunctionsPass::convertToBind);
    }

    private static void convertToBind(FunctionNode fct) {
        AbstractExprNode bindTarget;
        VarRefNode varRefNode = (VarRefNode)fct.getNameExpr();
        if (varRefNode.hasType() && varRefNode.getType() instanceof ProtoImportType) {
            return;
        }
        if (varRefNode.hasType() && varRefNode.getType().getKind() == SoyType.Kind.TEMPLATE_TYPE) {
            TemplateImportType type = (TemplateImportType)varRefNode.getType();
            bindTarget = new TemplateLiteralNode(Identifier.create(varRefNode.getName(), varRefNode.getSourceLocation()), varRefNode.getSourceLocation(), true, type);
        } else {
            bindTarget = varRefNode;
        }
        RecordLiteralNode record = new RecordLiteralNode(Identifier.create("record", fct.getSourceLocation()), (Iterable<Identifier>)fct.getParamNames(), fct.getSourceLocation());
        record.addChildren((List<? extends ExprNode>)fct.getChildren());
        MethodCallNode bind = MethodCallNode.newWithPositionalArgs(bindTarget, (List<ExprNode>)ImmutableList.of((Object)record), Identifier.create("bind", SourceLocation.UNKNOWN), SourceLocation.UNKNOWN, false);
        fct.getParent().replaceChild(fct, bind);
    }
}

