/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.ImportsPass;
import com.google.template.soy.passes.ResolveTemplateNamesPass;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.ImportsContext;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateNameRegistry;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.TemplatesPerFile;
import com.google.template.soy.soytree.defn.ImportedVar;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.TemplateImportType;
import com.google.template.soy.types.TemplateModuleImportType;
import com.google.template.soy.types.UnknownType;
import java.util.LinkedHashMap;
import java.util.Map;

@RunBefore(value={ResolveTemplateNamesPass.class})
public final class ResolveTemplateImportsPass
extends ImportsPass
implements CompilerFileSetPass {
    private TemplateNameRegistry templateNameRegistry = null;
    private final SoyGeneralOptions options;
    private final ErrorReporter errorReporter;

    ResolveTemplateImportsPass(SoyGeneralOptions options, ErrorReporter errorReporter) {
        this.options = options;
        this.errorReporter = errorReporter;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator nodeIdGen, TemplateNameRegistry templateNameRegistry, TemplateRegistry unusedPartialTemplateRegistry) {
        this.templateNameRegistry = templateNameRegistry;
        for (SoyFileNode sourceFile : sourceFiles) {
            this.visitFile(sourceFile);
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    ErrorReporter errorReporter() {
        return this.errorReporter;
    }

    @Override
    TemplateImportVisitor createImportVisitorForFile(SoyFileNode file) {
        return new TemplateImportVisitor(file, this.templateNameRegistry, this.options, this.errorReporter, file.getSoyTypeRegistry());
    }

    static final class TemplateImportVisitor
    extends ImportsPass.ImportVisitor {
        private final TemplateNameRegistry templateNameRegistry;
        final Map<String, TemplatesPerFile.TemplateName> symbolsToTemplatesMap = new LinkedHashMap<String, TemplatesPerFile.TemplateName>();
        private final ImmutableMap<String, String> symbolToTemplateName;
        private final SoyTypeRegistry typeRegistry;

        TemplateImportVisitor(SoyFileNode file, TemplateNameRegistry templateNameRegistry, SoyGeneralOptions options, ErrorReporter errorReporter, SoyTypeRegistry typeRegistry) {
            super(file, (ImmutableSet<ImportNode.ImportType>)ImmutableSet.of((Object)((Object)ImportNode.ImportType.TEMPLATE)), options, errorReporter);
            this.templateNameRegistry = templateNameRegistry;
            this.symbolToTemplateName = (ImmutableMap)file.getTemplates().stream().collect(ImmutableMap.toImmutableMap(TemplateNode::getLocalTemplateSymbol, TemplateNode::getPartialTemplateName, (existing, replacement) -> existing));
            this.typeRegistry = typeRegistry;
        }

        @Override
        void processImportedSymbols(ImportNode node) {
            TemplatesPerFile templatesPerFile = this.templateNameRegistry.getTemplatesForFile(SourceFilePath.create(node.getPath()));
            for (ImportedVar symbol : node.getIdentifiers()) {
                String name = symbol.getSymbol();
                if (!templatesPerFile.hasTemplateWithUnqualifiedName(name)) {
                    this.reportUnknownSymbolError(symbol.nameLocation(), name, node.getPath(), (Iterable<String>)templatesPerFile.getUnqualifiedTemplateNames());
                    symbol.setType(UnknownType.getInstance());
                    continue;
                }
                String partialTemplateName = (String)this.symbolToTemplateName.get((Object)symbol.name());
                if (partialTemplateName != null) {
                    symbol.setType(UnknownType.getInstance());
                    continue;
                }
                TemplatesPerFile.TemplateName templateName = templatesPerFile.getFullTemplateName(name);
                this.symbolsToTemplatesMap.put(symbol.name(), templateName);
                symbol.setType(this.typeRegistry.intern(TemplateImportType.create(templateName.fullyQualifiedName())));
            }
        }

        @Override
        void processImportedModule(ImportNode node) {
            TemplatesPerFile templatesPerFile = this.templateNameRegistry.getTemplatesForFile(SourceFilePath.create(node.getPath()));
            ((ImportedVar)Iterables.getOnlyElement(node.getIdentifiers())).setType(this.typeRegistry.intern(TemplateModuleImportType.create(templatesPerFile.getNamespace(), templatesPerFile.getFilePath(), (ImmutableSet<String>)((ImmutableSet)templatesPerFile.getTemplateNames().stream().map(TemplatesPerFile.TemplateName::unqualifiedName).collect(ImmutableSet.toImmutableSet())))));
            templatesPerFile.getUnqualifiedTemplateNames().forEach(template -> this.symbolsToTemplatesMap.put(node.getModuleAlias() + "." + template, templatesPerFile.getFullTemplateName((String)template)));
        }

        @Override
        boolean importExists(ImportNode.ImportType type, String path) {
            return this.templateNameRegistry.hasFile(SourceFilePath.create(path));
        }

        @Override
        ImmutableSet<String> getValidImportPathsForType(ImportNode.ImportType type) {
            return (ImmutableSet)this.templateNameRegistry.allFiles().stream().map(SourceFilePath::path).collect(ImmutableSet.toImmutableSet());
        }

        @Override
        void updateImportsContext() {
            this.file.getImportsContext().setTemplateRegistry(new ImportsContext.ImportsTemplateRegistry(this.file, (ImmutableMap<String, TemplatesPerFile.TemplateName>)ImmutableMap.copyOf(this.symbolsToTemplatesMap)));
        }
    }
}

