/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.ResolveDottedImportsPass;
import com.google.template.soy.passes.ResolveNamesPass;
import com.google.template.soy.passes.ResolvePluginsPass;
import com.google.template.soy.passes.ResolveTemplateImportsPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.passes.SoyElementPass;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.TemplateImportType;
import javax.annotation.Nullable;

@RunAfter(value={ResolveTemplateImportsPass.class, ResolvePluginsPass.class, ResolveNamesPass.class, ResolveDottedImportsPass.class})
@RunBefore(value={SoyElementPass.class})
public final class ResolveTemplateNamesPass
implements CompilerFileSetPass {
    private static final SoyErrorKind DATA_ATTRIBUTE_ONLY_ALLOWED_ON_STATIC_CALLS = SoyErrorKind.of("The `data` attribute is only allowed on static calls.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_TEMPLATE_FUNCT_PARAM = SoyErrorKind.of("The argument to the template() function must be a local, imported, or global template name.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNIMPORTED_TEMPLATE_CALL = SoyErrorKind.of("Template must be imported. See go/soy-external-calls.", new SoyErrorKind.StyleAllowance[0]);
    private static final ImmutableSet<String> TEMPLATE_IMPORT_EXEMPTIONS_BY_NAMESPACE = ImmutableSet.of();
    private final ErrorReporter errorReporter;
    private final boolean requireTemplateImports;
    private boolean isFileExemptedFromTemplateImports = false;

    public ResolveTemplateNamesPass(ErrorReporter errorReporter, boolean requireTemplateImports) {
        this.errorReporter = errorReporter;
        this.requireTemplateImports = requireTemplateImports;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        for (SoyFileNode file : sourceFiles) {
            this.isFileExemptedFromTemplateImports = ResolveTemplateNamesPass.isFileExemptedFromTemplateImports(file);
            this.visitFile(file);
        }
        this.isFileExemptedFromTemplateImports = false;
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void visitFile(SoyFileNode file) {
        SoyTreeUtils.allNodesOfType(file, CallBasicNode.class).forEach(ResolveTemplateNamesPass::importedVarRefToTemplateLiteral);
        SoyTreeUtils.allFunctionInvocations(file, BuiltinFunction.TEMPLATE).forEach(node -> this.resolveTemplateFunction((FunctionNode)node, file.getHeaderInfo()));
        SoyTreeUtils.allNodesOfType(file, VarRefNode.class).forEach(v -> {
            TemplateLiteralNode converted = ResolveTemplateNamesPass.varRefToLiteral(v, v.getSourceLocation(), false);
            if (converted != null) {
                v.getParent().replaceChild(v, converted);
            }
        });
        SoyTreeUtils.allNodesOfType(file, TemplateLiteralNode.class).filter(n -> !n.isResolved()).forEach(node -> this.resolveTemplateName((TemplateLiteralNode)node, file.getHeaderInfo()));
        SoyTreeUtils.allNodesOfType(file, CallBasicNode.class).filter(callNode -> callNode.isPassingData() && !callNode.isStaticCall()).forEach(callNode -> this.errorReporter.report(callNode.getOpenTagLocation(), DATA_ATTRIBUTE_ONLY_ALLOWED_ON_STATIC_CALLS, new Object[0]));
    }

    private static void importedVarRefToTemplateLiteral(CallBasicNode callNode) {
        ExprNode templateExpr = callNode.getCalleeExpr().getRoot();
        TemplateLiteralNode converted = ResolveTemplateNamesPass.varRefToLiteral(templateExpr, templateExpr.getSourceLocation(), true);
        if (converted != null) {
            callNode.setCalleeExpr(new ExprRootNode(converted));
        }
    }

    private void resolveTemplateFunction(FunctionNode functionNode, TemplateNode.SoyFileHeaderInfo header) {
        if (functionNode.numChildren() != 1) {
            return;
        }
        ExprNode param = functionNode.getParams().get(0);
        TemplateLiteralNode converted = ResolveTemplateNamesPass.varRefToLiteral(param, functionNode.getSourceLocation(), false);
        if (converted != null) {
            functionNode.getParent().replaceChild(functionNode, converted);
        } else if (param.getKind() == ExprNode.Kind.GLOBAL_NODE) {
            Identifier unresolved = ((GlobalNode)param).getIdentifier();
            Identifier fqn = this.resolveTemplateName(((GlobalNode)param).getIdentifier(), header);
            TemplateLiteralNode template = new TemplateLiteralNode(unresolved, param.getSourceLocation(), false);
            template.resolveTemplateName(fqn);
            functionNode.getParent().replaceChild(functionNode, template);
        } else {
            this.errorReporter.report(param.getSourceLocation(), INVALID_TEMPLATE_FUNCT_PARAM, new Object[0]);
        }
    }

    @Nullable
    private static TemplateLiteralNode varRefToLiteral(ExprNode expr, SourceLocation sourceLocation, boolean isSynthetic) {
        if (expr.getKind() != ExprNode.Kind.VAR_REF_NODE) {
            return null;
        }
        VarRefNode varRef = (VarRefNode)expr;
        if (varRef.hasType() && expr.getType().getKind() == SoyType.Kind.TEMPLATE_TYPE) {
            return new TemplateLiteralNode(Identifier.create(varRef.getName(), varRef.getSourceLocation()), sourceLocation, isSynthetic, (TemplateImportType)expr.getType());
        }
        return null;
    }

    private Identifier resolveTemplateName(Identifier unresolvedIdent, TemplateNode.SoyFileHeaderInfo header) {
        switch (unresolvedIdent.type()) {
            case SINGLE_IDENT: 
            case DOT_IDENT: {
                return Identifier.create(TemplateNodeBuilder.combineNsAndName(header.getNamespace(), unresolvedIdent.identifier()), unresolvedIdent.identifier(), unresolvedIdent.location());
            }
            case DOTTED_IDENT: {
                if (this.requireTemplateImports && !this.isFileExemptedFromTemplateImports) {
                    this.errorReporter.report(unresolvedIdent.location(), UNIMPORTED_TEMPLATE_CALL, new Object[0]);
                }
                return header.resolveAlias(unresolvedIdent);
            }
        }
        throw new AssertionError((Object)unresolvedIdent.type());
    }

    private void resolveTemplateName(TemplateLiteralNode templateLiteralNode, TemplateNode.SoyFileHeaderInfo header) {
        templateLiteralNode.resolveTemplateName(this.resolveTemplateName(templateLiteralNode.getIdentifier(), header));
    }

    private static boolean isFileExemptedFromTemplateImports(SoyFileNode file) {
        return TEMPLATE_IMPORT_EXEMPTIONS_BY_NAMESPACE.contains((Object)file.getNamespace()) || file.getFilePath().toString().contains("recaptcha/");
    }
}

