/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractLocalVarDefn;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VeLiteralNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.RestoreGlobalsPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;

@RunAfter(value={RestoreGlobalsPass.class})
public final class RestoreCompilerChecksPass
implements CompilerFilePass {
    private static final SoyErrorKind MUST_BE_DOLLAR_IDENT = SoyErrorKind.of("Name must begin with a ''$''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MUST_NOT_BE_DOLLAR_IDENT = SoyErrorKind.of("Name must not begin with a ''$''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MUST_BE_CONSTANT = SoyErrorKind.of("Expected constant identifier.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    public RestoreCompilerChecksPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        SoyTreeUtils.allNodesOfType(file, CallBasicNode.class).filter(callNode -> callNode.getCalleeExpr().getRoot().getKind() == ExprNode.Kind.GLOBAL_NODE).forEach(callNode -> {
            GlobalNode global = (GlobalNode)callNode.getCalleeExpr().getRoot();
            callNode.setCalleeExpr(new ExprRootNode(new TemplateLiteralNode(global.getIdentifier(), global.getSourceLocation(), true)));
        });
        SoyTreeUtils.allNodesOfType(file, LetNode.class).map(LetNode::getVar).forEach(this::checkDollarIdent);
        SoyTreeUtils.allNodesOfType(file, ForNonemptyNode.class).forEach(forNode -> {
            this.checkDollarIdent(forNode.getVar());
            if (forNode.getIndexVar() != null) {
                this.checkDollarIdent(forNode.getIndexVar());
            }
        });
        SoyTreeUtils.allNodesOfType(file, ListComprehensionNode.class).forEach(listNode -> {
            this.checkDollarIdent(listNode.getListIterVar());
            if (listNode.getIndexVar() != null) {
                this.checkDollarIdent(listNode.getIndexVar());
            }
        });
        SoyTreeUtils.allNodesOfType(file, RecordLiteralNode.class).flatMap(r -> r.getKeys().stream()).filter(k -> k.identifier().startsWith("$")).forEach(k -> this.errorReporter.report(k.location(), MUST_NOT_BE_DOLLAR_IDENT, new Object[0]));
        SoyTreeUtils.allNodesOfType(file, VeLiteralNode.class).forEach(veNode -> {
            if (veNode.getName().identifier().startsWith("$")) {
                this.errorReporter.report(veNode.getName().location(), MUST_BE_CONSTANT, new Object[0]);
            }
        });
    }

    private void checkDollarIdent(AbstractLocalVarDefn<?> localVar) {
        if (!localVar.getOriginalName().startsWith("$")) {
            this.errorReporter.report(localVar.nameLocation(), MUST_BE_DOLLAR_IDENT, new Object[0]);
        }
    }
}

