/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.data.internalutils.InternalValueUtils;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.passes.CheckGlobalsPass;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.passes.VeRewritePass;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;

@RunAfter(value={VeRewritePass.class})
@RunBefore(value={CheckGlobalsPass.class})
final class RewriteGlobalsPass
implements CompilerFilePass {
    private final ImmutableMap<String, PrimitiveData> compileTimeGlobals;

    RewriteGlobalsPass(ImmutableMap<String, PrimitiveData> compileTimeGlobals) {
        this.compileTimeGlobals = compileTimeGlobals;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        SoyTreeUtils.allNodesOfType(file, GlobalNode.class).forEach(global -> this.resolveGlobal(file, (GlobalNode)global));
    }

    private void resolveGlobal(SoyFileNode file, GlobalNode global) {
        String name;
        PrimitiveData value;
        Identifier alias = file.resolveAlias(global.getIdentifier());
        if (alias != null) {
            global.setName(alias.identifier());
        }
        if ((value = (PrimitiveData)this.compileTimeGlobals.get((Object)(name = global.getName()))) != null) {
            ExprNode.PrimitiveNode expr = InternalValueUtils.convertPrimitiveDataToExpr(value, global.getSourceLocation());
            global.resolve(expr.getType(), expr);
        }
    }
}

