/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableTable;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.SoyType;
import java.util.Collection;
import javax.annotation.CheckReturnValue;

final class RuntimeTypeCoercion {
    private static final ImmutableTable<SoyType, SoyType, BuiltinFunction> AVAILABLE_CALL_SITE_COERCIONS = new ImmutableTable.Builder().put((Object)IntType.getInstance(), (Object)FloatType.getInstance(), (Object)BuiltinFunction.TO_FLOAT).build();

    @CheckReturnValue
    static SoyType maybeCoerceType(ExprNode node, Collection<SoyType> toTypes) {
        SoyType fromType = node.getType();
        if (AVAILABLE_CALL_SITE_COERCIONS.row((Object)fromType).isEmpty()) {
            return fromType;
        }
        for (SoyType formalType : toTypes) {
            if (!formalType.isAssignableFromStrict(fromType)) continue;
            return fromType;
        }
        for (SoyType coercionTargetType : AVAILABLE_CALL_SITE_COERCIONS.row((Object)fromType).keySet()) {
            BuiltinFunction function = null;
            for (SoyType formalType : toTypes) {
                if (!formalType.isAssignableFromStrict(coercionTargetType)) continue;
                if (function == null) {
                    function = (BuiltinFunction)AVAILABLE_CALL_SITE_COERCIONS.get((Object)fromType, (Object)coercionTargetType);
                    continue;
                }
                function = null;
                break;
            }
            if (function == null) continue;
            FunctionNode coercedValue = FunctionNode.newPositional(Identifier.create(function.getName(), node.getSourceLocation()), function, node.getSourceLocation());
            coercedValue.setType(coercionTargetType);
            ExprNode.ParentExprNode parent = node.getParent();
            parent.replaceChild(node, coercedValue);
            coercedValue.addChild(node);
            return coercionTargetType;
        }
        return fromType;
    }

    private RuntimeTypeCoercion() {
    }
}

