/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.TemplateContentKind;
import com.google.template.soy.basetree.AbstractNodeVisitor;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;

public final class ShouldEnsureDataIsDefinedVisitor {
    public boolean exec(TemplateNode template) {
        boolean hasOptional = false;
        for (TemplateParam param : template.getParams()) {
            if (param.isImplicit() && !(template.getTemplateContentKind() instanceof TemplateContentKind.ElementContentKind)) continue;
            if (param.isRequired()) {
                return false;
            }
            hasOptional = true;
        }
        if (hasOptional) {
            return true;
        }
        return new AbstractNodeVisitor<Node, Boolean>(){
            boolean shouldEnsureDataIsDefined;

            @Override
            public Boolean exec(Node node) {
                this.visit(node);
                return this.shouldEnsureDataIsDefined;
            }

            @Override
            public void visit(Node node) {
                if (node instanceof VarRefNode) {
                    VarRefNode varRefNode = (VarRefNode)node;
                    VarDefn var = varRefNode.getDefnDecl();
                    if (!(!varRefNode.isPossibleHeaderVar().booleanValue() || var.kind() == VarDefn.Kind.STATE || ((TemplateParam)var).isImplicit() || var.kind() == VarDefn.Kind.PARAM && ((TemplateParam)var).isInjected())) {
                        this.shouldEnsureDataIsDefined = true;
                        return;
                    }
                }
                if (node instanceof CallNode && ((CallNode)node).isPassingAllData()) {
                    this.shouldEnsureDataIsDefined = true;
                    return;
                }
                if (node instanceof ParentNode) {
                    for (Node child : ((ParentNode)node).getChildren()) {
                        this.visit(child);
                        if (!this.shouldEnsureDataIsDefined) continue;
                        return;
                    }
                }
                if (node instanceof SoyNode.ExprHolderNode) {
                    for (ExprRootNode expr : ((SoyNode.ExprHolderNode)node).getExprList()) {
                        this.visit(expr);
                        if (!this.shouldEnsureDataIsDefined) continue;
                        return;
                    }
                }
            }
        }.exec((Node)template);
    }
}

